/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.snapshot;

import com.integ.janoslib.utils.HexUtils;
import com.integ.supporter.AssemblyInfo;
import com.integ.supporter.Constants;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.RollingLog;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class SubmitSnapshotDialog
extends JDialog {
    private static final Pattern EMAIL_REGEX_PATTERN = Pattern.compile("^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$");
    private final Logger Logger = RollingLog.getLogger("SubmitSnapshot");
    private File _snapshotFile;
    private JButton cancelButton;
    private JTextField companyTextField;
    private JTextField emailTextField;
    private JTextField firstNameTextField;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JLabel jLabel9;
    private JScrollPane jScrollPane1;
    private JTextField lastNameTextField;
    private JTextPane messageTextPane;
    private JComboBox<String> modelComboBox;
    private JTextField phoneTextField;
    private JLabel snapshotNameLabel;
    private JTextField subjectTextField;
    private JButton submitButton;

    public SubmitSnapshotDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.startSubmitValidationTime();
    }

    public void setSnapshotFile(File file) {
        this._snapshotFile = file;
        String snapshotFilePath = file.getPath();
        snapshotFilePath = snapshotFilePath.substring(Constants.SNAPSHOTS_FOLDER.length());
        this.snapshotNameLabel.setText(snapshotFilePath);
    }

    private void initComponents() {
        this.snapshotNameLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel6 = new JLabel();
        this.firstNameTextField = new JTextField();
        this.lastNameTextField = new JTextField();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.companyTextField = new JTextField();
        this.jLabel11 = new JLabel();
        this.emailTextField = new JTextField();
        this.modelComboBox = new JComboBox();
        this.subjectTextField = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.messageTextPane = new JTextPane();
        this.jLabel12 = new JLabel();
        this.submitButton = new JButton();
        this.cancelButton = new JButton();
        this.phoneTextField = new JTextField();
        this.jLabel13 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Submit Snapshot");
        this.setModal(true);
        this.setResizable(false);
        this.snapshotNameLabel.setText("...");
        this.jLabel1.setFont(new Font("Segoe UI", 1, 12));
        this.jLabel1.setText("Snapshot Name:");
        this.jLabel2.setText("First Name:");
        this.jLabel4.setText("Model:");
        this.jLabel6.setText("Subject:");
        this.firstNameTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SubmitSnapshotDialog.this.firstNameTextFieldActionPerformed(evt);
            }
        });
        this.lastNameTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SubmitSnapshotDialog.this.lastNameTextFieldActionPerformed(evt);
            }
        });
        this.jLabel9.setText("Last Name:");
        this.jLabel10.setText("Company:");
        this.companyTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SubmitSnapshotDialog.this.companyTextFieldActionPerformed(evt);
            }
        });
        this.jLabel11.setText("Email:");
        this.emailTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SubmitSnapshotDialog.this.emailTextFieldActionPerformed(evt);
            }
        });
        this.modelComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Series 4", "410", "412", "412 DMX", "414", "Series 3", "310", "312", "314", "Not Specified"}));
        this.modelComboBox.setSelectedIndex(-1);
        this.subjectTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SubmitSnapshotDialog.this.subjectTextFieldActionPerformed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.messageTextPane);
        this.jLabel12.setText("Message:");
        this.submitButton.setText("Submit");
        this.submitButton.setEnabled(false);
        this.submitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SubmitSnapshotDialog.this.submitButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SubmitSnapshotDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.phoneTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SubmitSnapshotDialog.this.phoneTextFieldActionPerformed(evt);
            }
        });
        this.phoneTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                SubmitSnapshotDialog.this.phoneTextFieldKeyTyped(evt);
            }
        });
        this.jLabel13.setText("Phone:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(19, 19, 19).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.snapshotNameLabel)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.submitButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.firstNameTextField, -2, 150, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lastNameTextField, -2, 150, -2))).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(30, 30, 30).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel6).addComponent(this.jLabel12)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.subjectTextField).addComponent(this.jScrollPane1))).addGroup(layout.createSequentialGroup().addGap(24, 24, 24).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.modelComboBox, -2, 150, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.emailTextField, -2, 150, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.companyTextField, -2, 150, -2))).addGap(33, 33, 33).addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phoneTextField, -2, 150, -2))).addGap(17, 17, 17)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(17, 17, 17).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.snapshotNameLabel).addComponent(this.jLabel1)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.firstNameTextField, -2, -1, -2).addComponent(this.jLabel9).addComponent(this.lastNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.emailTextField, -2, -1, -2).addComponent(this.jLabel13).addComponent(this.phoneTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.companyTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.modelComboBox, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.subjectTextField, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 99, -2).addComponent(this.jLabel12)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 15, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.submitButton).addComponent(this.cancelButton)).addGap(16, 16, 16)));
        this.pack();
    }

    private void firstNameTextFieldActionPerformed(ActionEvent evt) {
    }

    private void lastNameTextFieldActionPerformed(ActionEvent evt) {
    }

    private void companyTextFieldActionPerformed(ActionEvent evt) {
    }

    private void emailTextFieldActionPerformed(ActionEvent evt) {
    }

    private void subjectTextFieldActionPerformed(ActionEvent evt) {
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void submitButtonActionPerformed(ActionEvent evt) {
        try {
            String urlString = "https://jnior.com/contact";
            String charset = StandardCharsets.UTF_8.name();
            String boundary = Long.toHexString(System.currentTimeMillis());
            URL url = new URL(urlString);
            HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
            httpConnection.setDoOutput(true);
            httpConnection.setRequestMethod("POST");
            httpConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            try (DataOutputStream outputStream = new DataOutputStream(httpConnection.getOutputStream());){
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                String secreteMessage = String.format("jnior_supporter-%s", simpleDateFormat.format(new Date()));
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(secreteMessage.getBytes());
                byte[] digest = md.digest();
                String secreteHash = HexUtils.bytesToHex(digest).toLowerCase();
                SubmitSnapshotDialog.addFormField(outputStream, "secret_message", secreteHash, boundary, charset);
                SubmitSnapshotDialog.addFormField(outputStream, "message_name_first", this.firstNameTextField.getText(), boundary, charset);
                SubmitSnapshotDialog.addFormField(outputStream, "message_name_last", this.lastNameTextField.getText(), boundary, charset);
                SubmitSnapshotDialog.addFormField(outputStream, "message_company", this.companyTextField.getText(), boundary, charset);
                SubmitSnapshotDialog.addFormField(outputStream, "message_email", this.emailTextField.getText(), boundary, charset);
                SubmitSnapshotDialog.addFormField(outputStream, "message_phone", this.phoneTextField.getText(), boundary, charset);
                SubmitSnapshotDialog.addFormField(outputStream, "message_model", this.modelComboBox.getSelectedItem().toString(), boundary, charset);
                SubmitSnapshotDialog.addFormField(outputStream, "message_subject", this.subjectTextField.getText(), boundary, charset);
                SubmitSnapshotDialog.addFormField(outputStream, "message_text", this.messageTextPane.getText(), boundary, charset);
                SubmitSnapshotDialog.addFormField(outputStream, "last_page", "jnior-supporter", boundary, charset);
                SubmitSnapshotDialog.addFilePart(outputStream, "snapshot_file", this._snapshotFile.getPath(), boundary, charset);
                SubmitSnapshotDialog.addFormField(outputStream, "reference", "Supporter v" + AssemblyInfo.getVersion(), boundary, charset);
                outputStream.write(("--" + boundary + "--\r\n").getBytes(charset));
            }
            String submissionError = httpConnection.getHeaderField("SubmissionError");
            if (Boolean.valueOf(submissionError).booleanValue()) {
                String submissionErrors = httpConnection.getHeaderField("SubmissionErrors");
                NotificationCollection.addError("Error Submitting Snapshot: " + submissionErrors);
            }
            StringBuilder response = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(httpConnection.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    response.append(line).append("\r\n");
                }
            }
            String responseString = response.toString();
            this.Logger.info(responseString);
            this.setVisible(false);
        }
        catch (Exception ex) {
            NotificationCollection.addError("Error Submitting Snapshot", ex);
        }
    }

    private void phoneTextFieldActionPerformed(ActionEvent evt) {
    }

    private void phoneTextFieldKeyTyped(KeyEvent evt) {
        if ((evt.getKeyChar() < '0' || evt.getKeyChar() > '9') && evt.getKeyCode() != 8 && evt.getKeyCode() != 127) {
            evt.consume();
        }
    }

    private static void addFormField(DataOutputStream outputStream, String name, String value, String boundary, String charset) throws IOException {
        outputStream.write(("--" + boundary + "\r\n").getBytes(charset));
        outputStream.write(("Content-Disposition: form-data; name=\"" + name + "\"\r\n").getBytes(charset));
        outputStream.write(("Content-Type: text/plain; charset=" + charset + "\r\n").getBytes(charset));
        outputStream.write(("\r\n" + value + "\r\n").getBytes(charset));
    }

    private static void addFilePart(DataOutputStream outputStream, String fieldName, String filePath, String boundary, String charset) throws IOException {
        String fileName = Paths.get(filePath, new String[0]).getFileName().toString();
        outputStream.write(("--" + boundary + "\r\n").getBytes(charset));
        outputStream.write(("Content-Disposition: form-data; name=\"" + fieldName + "\"; filename=\"" + fileName + "\"\r\n").getBytes(charset));
        outputStream.write(("Content-Type: " + Files.probeContentType(Paths.get(filePath, new String[0])) + "\r\n").getBytes(charset));
        outputStream.write("Content-Transfer-Encoding: binary\r\n".getBytes(charset));
        outputStream.write("\r\n".getBytes(charset));
        Files.copy(Paths.get(filePath, new String[0]), outputStream);
        outputStream.write("\r\n".getBytes(charset));
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(SubmitSnapshotDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(SubmitSnapshotDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(SubmitSnapshotDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(SubmitSnapshotDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubmitSnapshotDialog dialog = new SubmitSnapshotDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    private void startSubmitValidationTime() {
        this.validateForm();
        ActionListener validateFieldsTask = evt -> this.validateForm();
        Timer timer = new Timer(250, validateFieldsTask);
        timer.start();
    }

    private void validateForm() {
        boolean validated = true;
        validated &= !this.setComponentErrorState(this.firstNameTextField, this.firstNameTextField.getText().isBlank());
        validated &= !this.setComponentErrorState(this.lastNameTextField, this.lastNameTextField.getText().isBlank());
        boolean emailHasError = this.emailTextField.getText().isBlank() || !EMAIL_REGEX_PATTERN.matcher(this.emailTextField.getText()).matches();
        validated &= !this.setComponentErrorState(this.emailTextField, emailHasError);
        validated &= !this.setComponentErrorState(this.companyTextField, this.companyTextField.getText().isBlank());
        validated &= !this.setComponentErrorState(this.subjectTextField, this.subjectTextField.getText().isBlank());
        validated &= !this.setComponentErrorState(this.messageTextPane, this.messageTextPane.getText().isBlank());
        validated &= !this.setComponentErrorState(this.jScrollPane1, this.messageTextPane.getText().isBlank());
        this.submitButton.setEnabled(validated &= !this.setComponentErrorState(this.modelComboBox, -1 == this.modelComboBox.getSelectedIndex()));
    }

    private boolean setComponentErrorState(JComponent component, boolean inErrorState) {
        if (inErrorState) {
            component.putClientProperty("JComponent.outline", "error");
        } else {
            component.putClientProperty("JComponent.outline", null);
        }
        return inErrorState;
    }
}

