/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui.celleditors;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerDateModel;
import javax.swing.table.TableCellEditor;

public class TimingCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private final JSpinner _spinner = new JSpinner(new SpinnerDateModel());
    private JSpinner.DateEditor _dateEditor;

    @Override
    public JComponent getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        String timingString = (String)value;
        String minutesString = timingString.substring(0, timingString.indexOf(":"));
        String secondsString = timingString.substring(timingString.indexOf(":") + 1);
        int minutes = Integer.parseInt(minutesString);
        int seconds = Integer.parseInt(secondsString);
        seconds = minutes * 60 + seconds;
        try {
            SpinnerDateModel model = new SpinnerDateModel();
            model.setCalendarField(13);
            this._spinner.setModel(model);
            this._spinner.setEditor(new JSpinner.DateEditor(this._spinner, "m:ss"));
            this._spinner.setValue(new SimpleDateFormat("m:ss").parse(timingString));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Object getCellEditorValue() {
        return this._spinner.getValue();
    }
}

