/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter;

import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.janoslib.utils.PathUtils;
import com.integ.janoslib.utils.ResourceUtils;
import com.integ.janoslib.utils.StringUtils;
import com.integ.supporter.Constants;
import com.integ.supporter.NotificationCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;

public class OpenTaskManagerApplet {
    private static final Logger LOGGER = Logger.getLogger(OpenTaskManagerApplet.class.getName());
    private final String _host;

    public OpenTaskManagerApplet(String host) {
        this._host = host;
    }

    public void execute() {
        try {
            LOGGER.info(String.format("is windows: %s", Boolean.toString(Constants.IS_WINDOWS)));
            File destFile = new File(PathUtils.combine(Constants.TEMP_DIRECTORY, "TaskManagerInterface-" + (int)(Math.random() * 100.0) + ".jar"));
            LOGGER.info(String.format("extracting %s", destFile));
            ResourceUtils.extractResource("/resources/TaskManagerInterface.jar", destFile);
            LOGGER.info(String.format("extracted %s", destFile));
            File jniorProtocolDestFile = new File(PathUtils.combine(Constants.TEMP_DIRECTORY, "JniorProtocol.jar"));
            LOGGER.info(String.format("extracting %s", jniorProtocolDestFile));
            ResourceUtils.extractResource("/resources/JniorProtocol.jar", jniorProtocolDestFile);
            LOGGER.info(String.format("extracted %s", jniorProtocolDestFile));
            ArrayList<String> cmdArrayList = new ArrayList<String>();
            String javaHome = System.getProperty("java.home");
            if (!"".equals(this._host)) {
                Collections.addAll(cmdArrayList, "java", "-jar", "\"" + destFile.getPath() + "\"");
                cmdArrayList.add(this._host);
            } else {
                Collections.addAll(cmdArrayList, "java", "-jar", "\"" + destFile.getPath() + "\"");
            }
            String[] cmdArray = cmdArrayList.toArray(new String[cmdArrayList.size()]);
            LOGGER.info(String.format("%s", StringUtils.join(cmdArray, " ")));
            String commandString = StringUtils.join(cmdArray, " ");
            ProcessBuilder processBuilder = new ProcessBuilder(commandString);
            processBuilder.inheritIO();
            Map<String, String> environment = processBuilder.environment();
            environment.put("JAVA_HOME", javaHome);
            System.out.println(environment.get("JAVA_HOME"));
            processBuilder.command(cmdArray).start();
            LOGGER.info(String.format("executing %s for %s", destFile, this._host));
        }
        catch (Exception ex) {
            LOGGER.severe(ExceptionUtils.getStackTrace(ex));
            NotificationCollection.addError("Error opening console", ex);
        }
    }
}

