/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.updater.steps;

import com.integ.supporter.updater.steps.ProjectStep;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RegistryStep
extends ProjectStep {
    private String _regKey = "";
    private String _regValue = "";
    private boolean _mustReboot = false;

    public RegistryStep(String name) {
        super(name);
        this._type = "LoadRegistryProperty";
    }

    public RegistryStep(Element xmlElement) {
        super(xmlElement);
        this._regKey = this.getChildNodeString("RegKey");
        System.out.println("RegKey: " + this._regKey);
        this._regValue = this.getChildNodeString("RegValue");
        System.out.println("RegValue: " + this._regValue);
        this._mustReboot = Boolean.valueOf(this.getChildNodeString("MustReboot"));
        System.out.println("MustReboot: " + this._mustReboot);
    }

    public String getRegKey() {
        return this._regKey;
    }

    public void setRegKey(String regKey) {
        this._regKey = regKey;
    }

    public String getRegValue() {
        return this._regValue;
    }

    public void setRegValue(String regValue) {
        this._regValue = regValue;
    }

    public boolean getMustReboot() {
        return this._mustReboot;
    }

    public void setMustReboot(boolean mustReboot) {
        this._mustReboot = mustReboot;
    }

    @Override
    public Element getXmlElement(Document document) {
        Element xmlElement = super.getXmlElement(document);
        Element element = document.createElement("RegKey");
        element.appendChild(document.createTextNode(this._regKey));
        xmlElement.appendChild(element);
        element = document.createElement("RegValue");
        element.appendChild(document.createTextNode(this._regValue));
        xmlElement.appendChild(element);
        element = document.createElement("MustReboot");
        element.appendChild(document.createTextNode(String.valueOf(this._mustReboot)));
        xmlElement.appendChild(element);
        return xmlElement;
    }

    @Override
    public boolean execute() throws Exception {
        String currentValue = this.getRegistryKeyValue(this._regKey);
        boolean isNotDefined = currentValue.contains("is not defined");
        if (isNotDefined || !currentValue.equals(this._regValue)) {
            this.setNewValue();
            if (this._mustReboot) {
                this._updateProjectExecutor.setRebootNeededFlag();
            }
        } else {
            this._logger.info(String.format("  registry key already set to \"%s\"", this._regValue));
        }
        return true;
    }

    private String getRegistryKeyValue(String registryKey) throws Exception {
        String command = String.format("registry %s", registryKey);
        String currentValue = "";
        String regResponse = this._jniorUpdateControlConnection.exec(command);
        int equalsPos = regResponse.indexOf("= ");
        if (-1 != equalsPos) {
            currentValue = regResponse.substring(equalsPos + 2);
        }
        return currentValue;
    }

    private void setNewValue() throws Exception {
        String command = String.format("registry %s = \"%s\"", this._regKey, this._regValue);
        String response = this._jniorUpdateControlConnection.exec(command);
        this._logger.info(String.format("  %s set to \"%s\"", this._regKey, this._regValue));
    }
}

