/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.snapshot;

import com.integ.janoslib.net.LoginFailedException;
import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.janoslib.utils.ZipUtils;
import com.integ.protocols.events.ConnectionEvent;
import com.integ.protocols.jmpprotocol.helpers.FileListing;
import com.integ.supporter.AssemblyInfo;
import com.integ.supporter.BackgroundAction;
import com.integ.supporter.Constants;
import com.integ.supporter.JniorControlConnection;
import com.integ.supporter.JniorControlConnectionAuthenticationEvent;
import com.integ.supporter.JniorControlConnectionAuthenticationListener;
import com.integ.supporter.JniorControlConnectionListener;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.RollingLog;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.backup.FileHistory;
import com.integ.supporter.snapshot.FileInfo;
import com.integ.supporter.snapshot.JniorSnapshotTab;
import com.integ.supporter.snapshot.SnapshotListener;
import com.integ.supporter.ui.dialogs.LoginDialog;
import com.integ.supporter.ui.toasts.MessageToast;
import com.integ.supporter.ui.toasts.ToastNotifications;
import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class TakeSnapshot
extends BackgroundAction {
    private final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final SimpleDateFormat SNAPSHOT_DATE_FORMAT = new SimpleDateFormat("ddMMMyyyy_HHmmss");
    private static final String[] PRE_SNAPSHOT_COMMANDS = new String[]{"date", "stats", "ps", "jrflash", "ipconfig", "netstat"};
    private static final String[] SERIES4_PRE_SNAPSHOT_COMMANDS = new String[]{"netstat -av", "gc -m", "gc -b", "ps -v", "thd", "iolog", "extern", "netstat -c", "reg * > temp/registry.ini"};
    private static final String[] SERIES4_POST_SNAPSHOT_COMMANDS = new String[]{"rm jniorio.log", "rm auxio.log"};
    private Logger _logger;
    private JniorInfo _jniorInfo;
    private JniorControlConnection _jniorControlConnection;
    private String _rootFolder;
    private final ArrayList<FileListing> _remoteFilesList = new ArrayList();
    private SnapshotListener _snapshotListener = null;
    private Exception _exception;
    private String _exceptionString;
    private File _zipFile;
    private int _authenticationFailedOccurances = 0;
    private boolean _snapshotStarted;

    public TakeSnapshot(JniorInfo jniorInfo) {
        super(jniorInfo);
        this._jniorInfo = jniorInfo;
        try {
            this._logger = RollingLog.getLogger(String.format("Snapshot_%s", jniorInfo.IpAddress));
            String filename = String.format("%s%s.log", Constants.SNAPSHOT_LOGS_DIRECTORY, this._logger.getName());
            FileHandler fileHandler = new FileHandler(filename);
            fileHandler.setFormatter(new SimpleFormatter());
            this._logger.addHandler(fileHandler);
        }
        catch (IOException ex) {
            Logger.getLogger(JniorSnapshotTab.class.getName()).severe(ex.getMessage());
        }
        catch (SecurityException ex) {
            Logger.getLogger(JniorSnapshotTab.class.getName()).severe(ex.getMessage());
        }
    }

    @Override
    public String getTitle() {
        return String.format("Snapshot for %s", this._jniorInfo.IpAddress);
    }

    public Logger getLogger() {
        return this._logger;
    }

    public void setLogger(Logger logger) {
        this._logger = logger;
    }

    public void setFolder(String folder) {
        this._rootFolder = folder;
    }

    public void setSnapshotListener(SnapshotListener listener) {
        this._snapshotListener = listener;
    }

    public Exception getLastException() {
        return this._exception;
    }

    public String getLastExceptionString() {
        return this._exceptionString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void execute() throws InterruptedException {
        block76: {
            block74: {
                String response;
                super.getResult().start();
                this.update(String.format("%s, Starting Snapshot for %s...\n", this.SIMPLE_DATE_FORMAT.format(new Date()), this._jniorInfo.IpAddress), 0);
                this._logger.info(String.format("%s, Starting Snapshot for %s...\n", this.SIMPLE_DATE_FORMAT.format(new Date()), this._jniorInfo.IpAddress));
                this._logger.info(String.format("%s v%s", AssemblyInfo.getName(), AssemblyInfo.getVersion()));
                this._jniorControlConnection = JniorControlConnection.getFor(this._jniorInfo, this._logger);
                this._jniorControlConnection.addConnectionListener(new JniorControlConnectionListener(){

                    @Override
                    public void onConnected(ConnectionEvent event) {
                        System.out.println("event = " + event);
                    }

                    @Override
                    public void onClosed(ConnectionEvent event) {
                        System.out.println("event = " + event);
                    }

                    @Override
                    public void onError(ConnectionEvent event) {
                        if (!TakeSnapshot.this._jniorControlConnection.isCommandConnectionConnected()) {
                            TakeSnapshot.super.getResult().fail("JNIOR is not connected");
                            throw new RuntimeException("JNIOR is not connected");
                        }
                        try {
                            TakeSnapshot.this._jniorControlConnection.abort();
                            TakeSnapshot.this._jniorControlConnection.disconnect();
                            if (TakeSnapshot.this._snapshotStarted) {
                                TakeSnapshot.this._jniorControlConnection.allowReconnect(false);
                                TakeSnapshot.super.getResult().fail("Connection Lost");
                            }
                        }
                        catch (IOException ex) {
                            NotificationCollection.addError(ex);
                        }
                        if (!TakeSnapshot.this._jniorControlConnection.isLoggedIn()) {
                            TakeSnapshot.super.getResult().fail("JNIOR is not logged in");
                            throw new RuntimeException("JNIOR is not logged in");
                        }
                    }
                });
                this._jniorControlConnection.addAuthenticationListener(new JniorControlConnectionAuthenticationListener(){

                    @Override
                    public void onAuthenticationSuccess(JniorControlConnectionAuthenticationEvent event) {
                        TakeSnapshot.this._logger.info("Authenticated!");
                    }

                    @Override
                    public void onAuthenticationFailed(JniorControlConnectionAuthenticationEvent event) {
                        try {
                            ++TakeSnapshot.this._authenticationFailedOccurances;
                            TakeSnapshot.this._logger.info(String.format("%d auth failures", TakeSnapshot.this._authenticationFailedOccurances));
                            if (1 < TakeSnapshot.this._authenticationFailedOccurances) {
                                LoginDialog loginDialog = new LoginDialog((Frame)SupporterMain.getMainFrame(), true);
                                loginDialog.setDescription("Snapshot for " + TakeSnapshot.this._jniorInfo.IpAddress);
                                loginDialog.centerParent();
                                loginDialog.setVisible(true);
                                if (loginDialog.getResult() == 1) {
                                    TakeSnapshot.this._jniorInfo.Username = loginDialog.getUsername();
                                    TakeSnapshot.this._jniorInfo.Password = loginDialog.getPassword();
                                } else {
                                    TakeSnapshot.this._logger.info("user declined supplying credentials");
                                    TakeSnapshot.super.getResult().abort("user declined supplying credentials");
                                    try {
                                        TakeSnapshot.this._jniorControlConnection.abort();
                                        TakeSnapshot.this._jniorControlConnection.disconnect();
                                    }
                                    catch (IOException ex) {
                                        ex.printStackTrace();
                                    }
                                }
                            }
                            TakeSnapshot.this._jniorControlConnection.login(TakeSnapshot.this._jniorInfo.Username, TakeSnapshot.this._jniorInfo.Password);
                        }
                        catch (LoginFailedException ex) {
                            NotificationCollection.addError("Error providing custom credentials for " + TakeSnapshot.this._jniorControlConnection.toString(), ex);
                        }
                    }
                });
                if (!this._jniorControlConnection.connect()) {
                    if (TakeSnapshot.super.getResult().wasAborted()) {
                        throw new InterruptedException("User Aborted");
                    }
                    throw new InterruptedException("Could not connect to " + this._jniorInfo.IpAddress);
                }
                this._logger.info("waiting for " + this._jniorControlConnection.getUnitSerialNumber() + " to log in...");
                while (!this._jniorControlConnection.isLoggedIn()) {
                    Thread.sleep(100L);
                }
                this._logger.info(this._jniorControlConnection.getUnitSerialNumber() + " has logged in...");
                this._snapshotStarted = true;
                for (String preSnapshotAction : PRE_SNAPSHOT_COMMANDS) {
                    if (TakeSnapshot.super.getResult().wasAborted()) {
                        throw new InterruptedException("User Aborted");
                    }
                    try {
                        this.update(preSnapshotAction + "...", 0);
                        this._logger.info(preSnapshotAction + "...");
                        response = this._jniorControlConnection.exec(preSnapshotAction, 120000);
                        if (null == response || "".equals(response)) continue;
                        this._logger.info(response + "\n");
                    }
                    catch (Exception ex) {
                        if (TakeSnapshot.super.getResult().wasAborted()) continue;
                        this._logger.severe(ExceptionUtils.getStackTrace(ex));
                        this._jniorControlConnection.disconnect();
                    }
                }
                if (3 != this._jniorInfo.getSeries()) {
                    for (String preSnapshotAction : SERIES4_PRE_SNAPSHOT_COMMANDS) {
                        if (TakeSnapshot.super.getResult().wasAborted()) {
                            throw new InterruptedException("User Aborted");
                        }
                        try {
                            this._logger.info(preSnapshotAction + "...");
                            response = this._jniorControlConnection.exec(preSnapshotAction);
                            if (null == response || "".equals(response)) continue;
                            this._logger.info(response + "\n");
                        }
                        catch (Exception ex) {
                            if (TakeSnapshot.super.getResult().wasAborted()) continue;
                            TakeSnapshot.super.getResult().fail("", ex);
                            this._logger.severe(ExceptionUtils.getStackTrace(ex));
                            this._jniorControlConnection.disconnect();
                        }
                    }
                }
                this._logger.info("collect the files that should be downloaded\r\n");
                this.update("collect the files that should be downloaded", 0);
                this.getDirectory("/");
                if (TakeSnapshot.super.getResult().wasAborted()) {
                    throw new InterruptedException("User Aborted");
                }
                this._logger.info("download the collected files\r\n");
                this.downloadFiles();
                if (3 != this._jniorInfo.getSeries()) {
                    for (String postSnapshotAction : SERIES4_POST_SNAPSHOT_COMMANDS) {
                        if (!super.getResult().isInProgress()) break;
                        try {
                            this._logger.info(String.format("execute %s\n", postSnapshotAction));
                            response = this._jniorControlConnection.exec(postSnapshotAction);
                            if (null == response || "".equals(response)) continue;
                            this._logger.info(response + "\n");
                        }
                        catch (Exception ex) {
                            if (TakeSnapshot.super.getResult().wasAborted()) continue;
                            TakeSnapshot.super.getResult().fail("", ex);
                            this._logger.severe(ExceptionUtils.getStackTrace(ex));
                            this._jniorControlConnection.disconnect();
                        }
                    }
                }
                super.getResult().complete();
                if (null == this._jniorControlConnection) break block74;
                try {
                    this._jniorControlConnection.disconnect();
                }
                catch (IOException ex) {
                    Logger.getLogger(TakeSnapshot.class.getName()).severe(ex.getMessage());
                }
            }
            long elapsedMillis = System.currentTimeMillis() - super.getStartedTime();
            long elapsedSeconds = elapsedMillis / 1000L;
            long minutes = elapsedSeconds % 3600L / 60L;
            long seconds = elapsedSeconds % 60L;
            String resultString = "completed SUCCESSFULLY";
            this.setLevel(1);
            if (this.getResult().hasFailed()) {
                resultString = "FAILED";
                this.setLevel(4);
            } else if (this.getResult().wasAborted()) {
                resultString = "was ABORTED";
                this.setLevel(3);
            }
            this.update(resultString, 100);
            resultString = String.format("snapshot for %d %s in %d:%02d\n", this._jniorInfo.getSerialNumber(), resultString, minutes, seconds);
            this._logger.info(resultString);
            if (this.getResult().hasFailed()) {
                NotificationCollection.addError(resultString);
            } else if (this.getResult().wasAborted()) {
                // empty if block
            }
            MessageToast toast = new MessageToast(resultString);
            toast.setAutoHideDuration(3000);
            if (this.getResult().hasFailed()) {
                toast.setMessageType(0);
            } else if (this.getResult().wasAborted()) {
                toast.setMessageType(2);
            } else if (this.getResult().wasSuccessful()) {
                toast.setMessageType(4);
            }
            ToastNotifications.getInstance().display(toast);
            this.update(resultString, 100);
            if (this.getResult().wasSuccessful()) {
                try {
                    this.zipTempFolder();
                }
                catch (IOException ex) {
                    ex = new IOException("Unable to create zip file", ex);
                    this._logger.severe(ExceptionUtils.getStackTrace(ex));
                }
            }
            if (null != this._snapshotListener) {
                this._snapshotListener.snapshotResult(this);
            }
            this.getResult().complete();
            break block76;
            catch (Exception ex) {
                block75: {
                    try {
                        if (!TakeSnapshot.super.getResult().wasAborted()) {
                            this._logger.severe(ExceptionUtils.getStackTrace(ex));
                            super.getResult().fail("", ex);
                        }
                        if (null == this._jniorControlConnection) break block75;
                    }
                    catch (Throwable throwable) {
                        if (null != this._jniorControlConnection) {
                            try {
                                this._jniorControlConnection.disconnect();
                            }
                            catch (IOException ex2) {
                                Logger.getLogger(TakeSnapshot.class.getName()).severe(ex2.getMessage());
                            }
                        }
                        long elapsedMillis2 = System.currentTimeMillis() - super.getStartedTime();
                        long elapsedSeconds2 = elapsedMillis2 / 1000L;
                        long minutes2 = elapsedSeconds2 % 3600L / 60L;
                        long seconds2 = elapsedSeconds2 % 60L;
                        String resultString2 = "completed SUCCESSFULLY";
                        this.setLevel(1);
                        if (this.getResult().hasFailed()) {
                            resultString2 = "FAILED";
                            this.setLevel(4);
                        } else if (this.getResult().wasAborted()) {
                            resultString2 = "was ABORTED";
                            this.setLevel(3);
                        }
                        this.update(resultString2, 100);
                        resultString2 = String.format("snapshot for %d %s in %d:%02d\n", this._jniorInfo.getSerialNumber(), resultString2, minutes2, seconds2);
                        this._logger.info(resultString2);
                        if (this.getResult().hasFailed()) {
                            NotificationCollection.addError(resultString2);
                        } else if (this.getResult().wasAborted()) {
                            // empty if block
                        }
                        MessageToast toast2 = new MessageToast(resultString2);
                        toast2.setAutoHideDuration(3000);
                        if (this.getResult().hasFailed()) {
                            toast2.setMessageType(0);
                        } else if (this.getResult().wasAborted()) {
                            toast2.setMessageType(2);
                        } else if (this.getResult().wasSuccessful()) {
                            toast2.setMessageType(4);
                        }
                        ToastNotifications.getInstance().display(toast2);
                        this.update(resultString2, 100);
                        if (this.getResult().wasSuccessful()) {
                            try {
                                this.zipTempFolder();
                            }
                            catch (IOException ex3) {
                                ex3 = new IOException("Unable to create zip file", ex3);
                                this._logger.severe(ExceptionUtils.getStackTrace(ex3));
                            }
                        }
                        if (null != this._snapshotListener) {
                            this._snapshotListener.snapshotResult(this);
                        }
                        this.getResult().complete();
                        throw throwable;
                    }
                    try {
                        this._jniorControlConnection.disconnect();
                    }
                    catch (IOException ex4) {
                        Logger.getLogger(TakeSnapshot.class.getName()).severe(ex4.getMessage());
                    }
                }
                elapsedMillis = System.currentTimeMillis() - super.getStartedTime();
                elapsedSeconds = elapsedMillis / 1000L;
                minutes = elapsedSeconds % 3600L / 60L;
                seconds = elapsedSeconds % 60L;
                resultString = "completed SUCCESSFULLY";
                this.setLevel(1);
                if (this.getResult().hasFailed()) {
                    resultString = "FAILED";
                    this.setLevel(4);
                } else if (this.getResult().wasAborted()) {
                    resultString = "was ABORTED";
                    this.setLevel(3);
                }
                this.update(resultString, 100);
                resultString = String.format("snapshot for %d %s in %d:%02d\n", this._jniorInfo.getSerialNumber(), resultString, minutes, seconds);
                this._logger.info(resultString);
                if (this.getResult().hasFailed()) {
                    NotificationCollection.addError(resultString);
                } else if (this.getResult().wasAborted()) {
                    // empty if block
                }
                toast = new MessageToast(resultString);
                toast.setAutoHideDuration(3000);
                if (this.getResult().hasFailed()) {
                    toast.setMessageType(0);
                } else if (this.getResult().wasAborted()) {
                    toast.setMessageType(2);
                } else if (this.getResult().wasSuccessful()) {
                    toast.setMessageType(4);
                }
                ToastNotifications.getInstance().display(toast);
                this.update(resultString, 100);
                if (this.getResult().wasSuccessful()) {
                    try {
                        this.zipTempFolder();
                    }
                    catch (IOException ex5) {
                        ex5 = new IOException("Unable to create zip file", ex5);
                        this._logger.severe(ExceptionUtils.getStackTrace(ex5));
                    }
                }
                if (null != this._snapshotListener) {
                    this._snapshotListener.snapshotResult(this);
                }
                this.getResult().complete();
            }
        }
    }

    @Override
    public void run() {
        block2: {
            try {
                this.execute();
            }
            catch (InterruptedException ex) {
                this._exception = ex;
                this._logger.severe(ExceptionUtils.getStackTrace(ex));
                if (null == this._snapshotListener) break block2;
                this._snapshotListener.snapshotResult(this);
            }
        }
    }

    private void getDirectory(String directory) throws InterruptedException {
        if (this.getResult().wasAborted()) {
            throw new InterruptedException("User Aborted");
        }
        try {
            FileListing[] ftpFiles = this._jniorControlConnection.listFiles(directory);
            this._logger.info(String.format("%d files in %s", ftpFiles.length, directory));
            for (FileListing ftpFile : ftpFiles) {
                System.out.println(String.format("  %s", ftpFile.getName()));
                if (".".equals(ftpFile.getName()) || "..".equals(ftpFile.getName())) continue;
                FileInfo fileInfo = new FileInfo(ftpFile.getName());
                Object filePath = directory + "/" + ftpFile.getName();
                filePath = ((String)filePath).replaceAll("//", "/");
                ftpFile.setName((String)filePath);
                if (ftpFile.isDirectory()) {
                    this.getDirectory((String)filePath);
                    continue;
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat("mm-dd-yy H:mm:ss");
                ftpFile.setTimestamp(ftpFile.getTimestamp());
                this._remoteFilesList.add(ftpFile);
            }
        }
        catch (IOException ex) {
            String stackTrace = ExceptionUtils.getStackTrace(ex);
            this._logger.severe(stackTrace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFiles() throws InterruptedException {
        File tempDirectory = new File(this._rootFolder);
        if (tempDirectory.exists()) {
            tempDirectory.delete();
        } else {
            tempDirectory.mkdir();
        }
        this._logger.info("retrieve remote files...");
        int remoteFileCount = this._remoteFilesList.size();
        int totalBytesTodownload = 0;
        for (int i = 0; !this.getResult().wasAborted() && i < remoteFileCount; ++i) {
            FileListing ftpFile = this._remoteFilesList.get(i);
            totalBytesTodownload = (int)((long)totalBytesTodownload + ftpFile.getSize());
        }
        this._logger.info(String.format("pending %d bytes to download...", totalBytesTodownload));
        int bytesDownloaded = 0;
        for (int i = 0; this.getResult().isInProgress() && i < remoteFileCount; ++i) {
            FileListing ftpFile = this._remoteFilesList.get(i);
            if (ftpFile.isDirectory()) continue;
            Object remoteFile = ftpFile.getName();
            this.update("Downloading " + (String)remoteFile, (int)((double)bytesDownloaded / (double)totalBytesTodownload * 100.0));
            boolean retry = true;
            while (true) {
                block20: {
                    try {
                        File parentFile;
                        if (this.getResult().wasAborted()) {
                            throw new InterruptedException("User Aborted");
                        }
                        this._exception = null;
                        this._exceptionString = null;
                        if (null != this._snapshotListener) {
                            this._snapshotListener.downloadFileAttempt(i + 1, remoteFileCount, (String)remoteFile);
                        }
                        if (!((String)remoteFile).startsWith("/")) {
                            remoteFile = "/" + (String)remoteFile;
                        }
                        String localFileString = tempDirectory.getPath() + (String)remoteFile;
                        File localFile = new File(localFileString);
                        ArrayList<File> parentFiles = new ArrayList<File>();
                        for (parentFile = localFile.getParentFile(); null != parentFile && !parentFile.exists(); parentFile = parentFile.getParentFile()) {
                            parentFiles.add(0, parentFile);
                        }
                        while (0 < parentFiles.size()) {
                            parentFile = (File)parentFiles.remove(0);
                            if (parentFile.exists()) continue;
                            parentFile.mkdir();
                        }
                        boolean result = false;
                        FileOutputStream out = new FileOutputStream(localFile.getPath());
                        try {
                            result = this._jniorControlConnection.retrieveFile((String)remoteFile, out);
                            if (null != this._snapshotListener) {
                                this._snapshotListener.downloadFileResult(i + 1, remoteFileCount, (String)remoteFile, result);
                            }
                        }
                        finally {
                            if (null != out) {
                                out.close();
                            }
                            System.out.println(new Date(ftpFile.getTimestamp()));
                            localFile.setLastModified(ftpFile.getTimestamp());
                        }
                        if (result) {
                            FileHistory.fileDownloaded(this._jniorInfo.getSerialNumber(), localFile, (String)remoteFile);
                        }
                        break block20;
                    }
                    catch (Exception ex) {
                        if (!this.getResult().wasAborted()) {
                            String stacktrace;
                            this._exception = ex;
                            this._exceptionString = stacktrace = ExceptionUtils.getStackTrace(ex);
                            this._logger.severe(stacktrace);
                            super.getResult().fail("", ex);
                        }
                        if (null == this._snapshotListener) break;
                        this._snapshotListener.downloadFileResult(i, remoteFileCount, (String)remoteFile, false);
                    }
                    break;
                }
                if (!retry) break;
                retry = false;
            }
            bytesDownloaded = (int)((long)bytesDownloaded + ftpFile.getSize());
            this.update("Downloaded " + (String)remoteFile, (int)((double)bytesDownloaded / (double)totalBytesTodownload * 100.0));
        }
    }

    private void zipTempFolder() throws IOException {
        File folder = new File(this._rootFolder);
        String hostname = this._jniorInfo.Hostname;
        if (hostname.contains("\r")) {
            hostname = hostname.substring(0, this._jniorInfo.Hostname.indexOf("\r"));
        }
        String zipFilename = String.format("%s\\%d_%s_%s.zip", folder.getParent(), this._jniorInfo.getSerialNumber(), hostname, this.SNAPSHOT_DATE_FORMAT.format(new Date()));
        this._logger.info(String.format("create %s\n", zipFilename));
        String[] fileNames = folder.list();
        for (int i = 0; i < fileNames.length; ++i) {
            fileNames[i] = String.format("%s\\%s", this._rootFolder, fileNames[i]);
        }
        ZipUtils.zip(fileNames, zipFilename);
        File tempZipFile = new File(zipFilename);
        this._zipFile = new File(Constants.SNAPSHOTS_FOLDER + tempZipFile.getName());
        tempZipFile.renameTo(this._zipFile);
    }

    File getZipFile() {
        return this._zipFile;
    }
}

