/*
 * Decompiled with CFR 0.152.
 */
package com.integ.janoslib.utils;

import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.janoslib.utils.HexUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.logging.Logger;

public class FileUtils {
    public static void ensureDirectoryPathExists(File file) {
        ArrayList<File> parentFiles = new ArrayList<File>();
        File parentFile = file.getParentFile();
        while (!parentFile.exists()) {
            parentFiles.add(0, parentFile);
            parentFile = parentFile.getParentFile();
        }
        while (!parentFiles.isEmpty()) {
            parentFile = (File)parentFiles.remove(0);
            if (parentFile.exists()) continue;
            System.out.println("create " + parentFile.getPath());
            parentFile.mkdir();
        }
    }

    public static void writeAllBytes(String filename, byte[] bytes) throws IOException {
        FileUtils.ensureDirectoryPathExists(new File(filename));
        FileUtils.writeBytes(filename, bytes, 0, bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBytes(String filename, byte[] bytes, int offset, int length) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filename);
            fos.write(bytes, offset, length);
            fos.flush();
        }
        finally {
            try {
                if (null != fos) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                String stacktrace = ExceptionUtils.getStackTrace(ex);
                Logger.getGlobal().severe(stacktrace);
            }
        }
    }

    public static void appendAllBytes(String filename, byte[] bytes) throws IOException {
        FileUtils.appendBytes(filename, bytes, 0, bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendBytes(String filename, byte[] bytes, int offset, int length) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filename, true);
            fos.write(bytes, offset, length);
            fos.flush();
        }
        finally {
            try {
                if (null != fos) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                String stacktrace = ExceptionUtils.getStackTrace(ex);
                Logger.getGlobal().severe(stacktrace);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readAllBytes(String filename) throws IOException {
        File file = new File(filename);
        int fileLength = (int)file.length();
        if (0 > fileLength) {
            throw new RuntimeException(filename + " is too large");
        }
        byte[] bytes = new byte[fileLength];
        FileInputStream fis = new FileInputStream(file.getPath());
        DataInputStream dis = new DataInputStream(fis);
        try {
            dis.readFully(bytes);
        }
        finally {
            dis.close();
            fis.close();
        }
        return bytes;
    }

    public static String readAllText(String filename) throws IOException {
        byte[] fileBytes = FileUtils.readAllBytes(filename);
        String fileContent = new String(fileBytes);
        return fileContent;
    }

    public static void copyfile(File srcFile, int srPos, File dstFile, int dtPos) {
        try {
            int len;
            long start = System.currentTimeMillis();
            if (dstFile.exists()) {
                dstFile.delete();
            }
            RandomAccessFile in = new RandomAccessFile(srcFile, "r");
            in.seek(srPos);
            RandomAccessFile out = new RandomAccessFile(dstFile, "rw");
            out.seek(dtPos);
            byte[] buf = new byte[16384];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
            out.close();
            long elapsed = System.currentTimeMillis() - start;
            System.out.println("took " + elapsed + " to copy " + srcFile.getAbsolutePath() + " to " + dstFile.getAbsolutePath());
        }
        catch (Exception ex) {
            String stacktrace = ExceptionUtils.getStackTrace(ex);
            Logger.getGlobal().severe("Error copying file " + srcFile.getPath() + " to " + dstFile.getPath() + ": " + stacktrace);
        }
    }

    public static boolean deleteDirectory(File dir) {
        if (dir.isDirectory()) {
            File[] children = dir.listFiles();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtils.deleteDirectory(children[i]);
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static String getFileMd5(String filepath) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] downloadedFileBytes = FileUtils.readAllBytes(filepath);
        md.update(downloadedFileBytes);
        byte[] digest = md.digest();
        return HexUtils.bytesToHex(digest).toLowerCase();
    }
}

