/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui;

import com.integ.supporter.Notification;
import com.integ.supporter.ui.ColorConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class LevelRenderer
implements TableCellRenderer {
    private final DefaultTableCellRenderer DEFAULT_RENDERER = new DefaultTableCellRenderer();
    private final ArrayList<Notification> _notifications;

    public LevelRenderer(ArrayList<Notification> notifications) {
        this._notifications = notifications;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component c = this.DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Notification notification = this._notifications.get(this._notifications.size() - row - 1);
        switch (notification.getLevel()) {
            case 1: {
                c.setBackground(ColorConstants.PALE_GREEN);
                break;
            }
            case 2: {
                c.setBackground(Color.WHITE);
                break;
            }
            case 3: {
                c.setBackground(ColorConstants.PALE_YELLOW);
                break;
            }
            case 4: {
                c.setBackground(ColorConstants.PALE_RED);
                if (null == notification.getUserObject()) break;
                Font font = c.getFont();
                c.setFont(new Font(font.getFontName(), 1, font.getSize()));
            }
        }
        return c;
    }
}

