/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.updater;

import com.integ.janoslib.net.LoginFailedException;
import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.protocols.events.ConnectionEvent;
import com.integ.supporter.BackgroundAction;
import com.integ.supporter.JniorControlConnection;
import com.integ.supporter.JniorControlConnectionAuthenticationEvent;
import com.integ.supporter.JniorControlConnectionAuthenticationListener;
import com.integ.supporter.JniorControlConnectionListener;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.ui.dialogs.LoginDialog;
import com.integ.supporter.ui.toasts.ErrorMessageToast;
import com.integ.supporter.ui.toasts.MessageToast;
import com.integ.supporter.ui.toasts.ToastNotifications;
import com.integ.supporter.updater.UpdateProjectFile;
import com.integ.supporter.updater.UpdateProjectListener;
import com.integ.supporter.updater.steps.ProjectStep;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

public class UpdateProjectExecutor
extends BackgroundAction
implements Runnable {
    private final UpdateProjectFile _updateProjectFile;
    private final JniorInfo _targetJniorInfo;
    private final ArrayList<ProjectStep> _steps;
    private Logger _logger = Logger.getGlobal();
    private UpdateProjectListener _updateProjectListener;
    private JniorControlConnection _jniorControlConnection;
    private boolean _rebootNeeded = false;
    private int authenticationFailedOccurances = 0;

    public UpdateProjectExecutor(UpdateProjectFile updateProjectFile, JniorInfo targetJniorInfo, ArrayList<ProjectStep> steps) {
        super(targetJniorInfo);
        this._updateProjectFile = updateProjectFile;
        this._targetJniorInfo = targetJniorInfo;
        this._steps = steps;
    }

    public UpdateProjectExecutor setLogger(Logger logger) {
        this._logger = logger;
        return this;
    }

    public void setListener(UpdateProjectListener updateProjectListener) {
        this._updateProjectListener = updateProjectListener;
    }

    public void abort() {
        super.getResult().abort();
        this._jniorControlConnection.abort();
        try {
            this._jniorControlConnection.disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block58: {
            block56: {
                ProjectStep step;
                int i;
                super.getResult().start();
                boolean projectResult = true;
                this._logger.info(String.format("Publishing %s to %s", this._updateProjectFile.getFilePath(), this._targetJniorInfo.IpAddress));
                this._jniorControlConnection = JniorControlConnection.getFor(this._targetJniorInfo, this._logger);
                this._jniorControlConnection.addConnectionListener(new JniorControlConnectionListener(){

                    @Override
                    public void onConnected(ConnectionEvent event) {
                        UpdateProjectExecutor.this.authenticationFailedOccurances = 0;
                    }

                    @Override
                    public void onClosed(ConnectionEvent event) {
                    }

                    @Override
                    public void onError(ConnectionEvent event) {
                        if (!UpdateProjectExecutor.this._jniorControlConnection.isCommandConnectionConnected()) {
                            UpdateProjectExecutor.super.getResult().fail("JNIOR is not connected");
                            throw new RuntimeException("JNIOR is not connected");
                        }
                        try {
                            UpdateProjectExecutor.this._jniorControlConnection.abort();
                            UpdateProjectExecutor.this._jniorControlConnection.disconnect();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        if (!UpdateProjectExecutor.this._jniorControlConnection.isLoggedIn()) {
                            UpdateProjectExecutor.super.getResult().fail("JNIOR is not connected");
                            throw new RuntimeException("JNIOR is not logged in");
                        }
                    }
                });
                this._jniorControlConnection.addAuthenticationListener(new JniorControlConnectionAuthenticationListener(){

                    @Override
                    public void onAuthenticationSuccess(JniorControlConnectionAuthenticationEvent event) {
                    }

                    @Override
                    public void onAuthenticationFailed(JniorControlConnectionAuthenticationEvent event) {
                        try {
                            ++UpdateProjectExecutor.this.authenticationFailedOccurances;
                            JniorInfo jniorInfo = UpdateProjectExecutor.this.getJniorInfo();
                            if (1 < UpdateProjectExecutor.this.authenticationFailedOccurances) {
                                LoginDialog loginDialog = new LoginDialog((Frame)SupporterMain.getMainFrame(), true);
                                loginDialog.setDescription("Snapshot for " + jniorInfo.IpAddress);
                                loginDialog.centerParent();
                                loginDialog.setVisible(true);
                                if (loginDialog.getResult() == 1) {
                                    jniorInfo.Username = loginDialog.getUsername();
                                    jniorInfo.Password = loginDialog.getPassword();
                                } else {
                                    UpdateProjectExecutor.this._logger.info("user declined supplying credentials");
                                    UpdateProjectExecutor.super.getResult().abort("user declined supplying credentials");
                                    try {
                                        UpdateProjectExecutor.this._jniorControlConnection.abort();
                                        UpdateProjectExecutor.this._jniorControlConnection.disconnect();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                            }
                            UpdateProjectExecutor.this._jniorControlConnection.login(jniorInfo.Username, jniorInfo.Password);
                        }
                        catch (LoginFailedException ex) {
                            NotificationCollection.addError("Error providing custom credentials for " + UpdateProjectExecutor.this._jniorControlConnection.toString(), ex);
                        }
                    }
                });
                if (!this._jniorControlConnection.init()) {
                    if (UpdateProjectExecutor.super.getResult().wasAborted()) {
                        throw new InterruptedException("User Aborted");
                    }
                    UpdateProjectExecutor.super.getResult().fail("JNIOR connection not initiated");
                    this.update("JNIOR connection not initiated");
                    throw new RuntimeException("JNIOR connection not initiated");
                }
                while (!this._jniorControlConnection.isLoggedIn()) {
                    Thread.sleep(100L);
                }
                int requiredSeries = this._updateProjectFile.getRequiredSeries();
                if (-1 != requiredSeries && this._targetJniorInfo.getSeries() != requiredSeries) {
                    String message = String.format("%s is an incorrect series JNIOR.  Series %d required", this._targetJniorInfo.toString(), requiredSeries);
                    ErrorMessageToast errorMessageToast = new ErrorMessageToast(message);
                    ToastNotifications.getInstance().display(errorMessageToast);
                    throw new Exception(message);
                }
                if (-1 != requiredSeries) {
                    int serialNumber = this._jniorControlConnection.getUnitSerialNumber();
                    System.out.println("serialNumber = " + serialNumber);
                    if (requiredSeries == 4 && serialNumber < 600000000) {
                        throw new RuntimeException("JNIOR incorrect series.  Series " + requiredSeries + " required");
                    }
                    if (requiredSeries == 3 && serialNumber > 600000000) {
                        throw new RuntimeException("JNIOR incorrect series.  Series " + requiredSeries + " required");
                    }
                }
                ArrayList<ProjectStep> projectStepArrayList = this._steps;
                int projectStepCount = projectStepArrayList.size();
                for (i = 0; i < projectStepCount; ++i) {
                    if (super.getResult().wasAborted()) {
                        throw new Exception("User Aborted");
                    }
                    step = projectStepArrayList.get(i);
                    this._logger.info(String.format("Execute %s", step.toString()));
                    this.update(String.format("Execute %s", step.toString()));
                    step.setExecutor(this);
                    step.setLogger(this._logger);
                    step.setJniorInfo(this._targetJniorInfo);
                    step.setJniorUpdateControlConnection(this._jniorControlConnection);
                    boolean result = step.execute();
                    if (null != this._updateProjectListener) {
                        int percentage = (int)((double)(i + 1) / (double)projectStepCount * 100.0);
                        this._updateProjectListener.updateProjectStepResult(step, result, i + 1, projectStepCount);
                        this.update(String.format("Execute %s", step.toString()), percentage);
                    }
                    if (result) continue;
                    super.getResult().fail(step + " FAILED!");
                    this._logger.severe(step + " FAILED!");
                    projectResult = false;
                    break;
                }
                super.getResult().complete();
                this._logger.info("Summary:");
                for (i = 0; i < projectStepCount; ++i) {
                    step = projectStepArrayList.get(i);
                    String summary = step.getSummary();
                    if (null == summary) continue;
                    this._logger.info(String.format("  %s: %s", step.getName(), summary));
                }
                this.setLevel(projectResult ? 1 : 4);
                if (null == this._updateProjectListener) break block56;
                this._updateProjectListener.updateProjectResult(this, projectResult);
            }
            try {
                if (null != this._jniorControlConnection) {
                    try {
                        this._jniorControlConnection.disconnect();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(UpdateProjectExecutor.class.getName()).severe(ex.getMessage());
                    }
                }
                long elapsedMillis = System.currentTimeMillis() - super.getStartedTime();
                long elapsedSeconds = elapsedMillis / 1000L;
                long minutes = elapsedSeconds % 3600L / 60L;
                long seconds = elapsedSeconds % 60L;
                String resultString = "completed SUCCESSFULLY";
                if (super.getResult().hasFailed()) {
                    resultString = "has FAILED";
                } else if (super.getResult().wasAborted()) {
                    resultString = "was ABORTED";
                }
                resultString = String.format("Update project for %s %s in %d:%02d", this._targetJniorInfo.IpAddress, resultString, minutes, seconds);
                this.update(resultString);
                if (this.getResult().hasFailed()) {
                    NotificationCollection.addError(resultString);
                }
                MessageToast toast = new MessageToast(resultString);
                if (super.getResult().hasFailed()) {
                    toast.setMessageType(0);
                } else if (super.getResult().wasAborted()) {
                    toast.setMessageType(2);
                } else {
                    toast.setMessageType(4);
                }
                ToastNotifications.getInstance().display(toast);
            }
            catch (Exception ex) {
                NotificationCollection.addError(ex);
            }
            break block58;
            catch (Exception ex) {
                block57: {
                    try {
                        ex.printStackTrace();
                        if (this.getResult().hasFailed()) {
                            this._logger.severe(String.format("error in UpdateProject.run(): %s", ExceptionUtils.getStackTrace(ex)));
                            if (null != this._updateProjectListener) {
                                this._updateProjectListener.updateProjectResult(this, false);
                            }
                            break block57;
                        }
                        if (!this.getResult().wasAborted()) break block57;
                        this._logger.info("user aborted");
                        this.update("user aborted");
                        if (null == this._updateProjectListener) break block57;
                        this._updateProjectListener.updateProjectResult(this, false);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (null != this._jniorControlConnection) {
                                try {
                                    this._jniorControlConnection.disconnect();
                                }
                                catch (IOException ex2) {
                                    Logger.getLogger(UpdateProjectExecutor.class.getName()).severe(ex2.getMessage());
                                }
                            }
                            long elapsedMillis = System.currentTimeMillis() - super.getStartedTime();
                            long elapsedSeconds = elapsedMillis / 1000L;
                            long minutes = elapsedSeconds % 3600L / 60L;
                            long seconds = elapsedSeconds % 60L;
                            String resultString = "completed SUCCESSFULLY";
                            if (super.getResult().hasFailed()) {
                                resultString = "has FAILED";
                            } else if (super.getResult().wasAborted()) {
                                resultString = "was ABORTED";
                            }
                            resultString = String.format("Update project for %s %s in %d:%02d", this._targetJniorInfo.IpAddress, resultString, minutes, seconds);
                            this.update(resultString);
                            if (this.getResult().hasFailed()) {
                                NotificationCollection.addError(resultString);
                            }
                            MessageToast toast = new MessageToast(resultString);
                            if (super.getResult().hasFailed()) {
                                toast.setMessageType(0);
                            } else if (super.getResult().wasAborted()) {
                                toast.setMessageType(2);
                            } else {
                                toast.setMessageType(4);
                            }
                            ToastNotifications.getInstance().display(toast);
                        }
                        catch (Exception ex3) {
                            NotificationCollection.addError(ex3);
                        }
                        throw throwable;
                    }
                }
                try {
                    if (null != this._jniorControlConnection) {
                        try {
                            this._jniorControlConnection.disconnect();
                        }
                        catch (IOException ex4) {
                            Logger.getLogger(UpdateProjectExecutor.class.getName()).severe(ex4.getMessage());
                        }
                    }
                    long elapsedMillis = System.currentTimeMillis() - super.getStartedTime();
                    long elapsedSeconds = elapsedMillis / 1000L;
                    long minutes = elapsedSeconds % 3600L / 60L;
                    long seconds = elapsedSeconds % 60L;
                    String resultString = "completed SUCCESSFULLY";
                    if (super.getResult().hasFailed()) {
                        resultString = "has FAILED";
                    } else if (super.getResult().wasAborted()) {
                        resultString = "was ABORTED";
                    }
                    resultString = String.format("Update project for %s %s in %d:%02d", this._targetJniorInfo.IpAddress, resultString, minutes, seconds);
                    this.update(resultString);
                    if (this.getResult().hasFailed()) {
                        NotificationCollection.addError(resultString);
                    }
                    MessageToast toast = new MessageToast(resultString);
                    if (super.getResult().hasFailed()) {
                        toast.setMessageType(0);
                    } else if (super.getResult().wasAborted()) {
                        toast.setMessageType(2);
                    } else {
                        toast.setMessageType(4);
                    }
                    ToastNotifications.getInstance().display(toast);
                }
                catch (Exception ex5) {
                    NotificationCollection.addError(ex5);
                }
            }
        }
    }

    public void setRebootNeededFlag() {
        this._logger.info("Setting reboot needed flag");
        this._rebootNeeded = true;
    }

    public boolean isRebootNeeded() {
        return this._rebootNeeded;
    }

    public void clearRebootFlag() {
        this._logger.info("Clear reboot needed flag");
        this._rebootNeeded = false;
    }

    @Override
    public JniorInfo getJniorInfo() {
        return this._targetJniorInfo;
    }

    @Override
    public String getTitle() {
        File fileFromPath = new File(this._updateProjectFile.getFilePath());
        return String.format("%s -> %s", fileFromPath.getName(), this._targetJniorInfo.IpAddress);
    }
}

