/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.cinema;

import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.supporter.Constants;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.cinema.RemoteCinemaFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.io.CopyStreamAdapter;

public class RemoteCinemaFileOpener
extends RemoteCinemaFile {
    private File _localTempFile = null;
    private final String _remoteFolderPath = "/";
    private FTPFile _selectedRemoteFile = null;
    private FilenameFilter _filenameFilter;

    public RemoteCinemaFileOpener(JniorInfo jniorInfo) {
        super(jniorInfo);
    }

    public void setFilenameFilter(FilenameFilter filenameFilter) {
        this._filenameFilter = filenameFilter;
    }

    public File getLocalFile() {
        return this._localTempFile;
    }

    @Override
    public void run() {
        try {
            FTPFile[] fileEntries;
            if (null == super.getJniorInfo()) {
                return;
            }
            if (!this.createFtpClient()) {
                return;
            }
            CopyStreamAdapter streamListener = new CopyStreamAdapter(){

                @Override
                public void bytesTransferred(long totalBytesTransferred, int bytesTransferred, long streamSize) {
                    int percent = (int)(totalBytesTransferred * 100L / RemoteCinemaFileOpener.this._selectedRemoteFile.getSize());
                    RemoteCinemaFileOpener.this.update(String.format("downloading %s", RemoteCinemaFileOpener.this._selectedRemoteFile.getName()), percent);
                }
            };
            this._ftpClient.setCopyStreamListener(streamListener);
            super.update("Checking for Device Files");
            ArrayList<FTPFile> deviceFiles = new ArrayList<FTPFile>();
            for (FTPFile fileEntry : fileEntries = this._ftpClient.listFiles("/")) {
                boolean isCinemaFile = this._filenameFilter.accept(new File("/"), fileEntry.getName());
                if (!isCinemaFile) continue;
                deviceFiles.add(fileEntry);
            }
            if (1 == deviceFiles.size()) {
                this._selectedRemoteFile = (FTPFile)deviceFiles.get(0);
                String remoteDeviceFilePath = this._selectedRemoteFile.getName();
                if (this.downloadDeviceFile(remoteDeviceFilePath)) {
                    super.update("Successfully downloaded " + remoteDeviceFilePath);
                    NotificationCollection.addNotification(String.format("%s has been downloaded", remoteDeviceFilePath));
                }
            } else {
                super.update("There are not any remote Device Files");
            }
            super.getResult().complete();
        }
        catch (Exception ex) {
            super.getResult().fail("", ex);
            super.update("ERROR: " + ex.getMessage());
            NotificationCollection.addError("Error downloading remote device file from " + super.getJniorInfo().toString(), ex);
        }
    }

    private boolean downloadDeviceFile(String remoteDeviceFilePath) throws FileNotFoundException, IOException {
        File jniorTempDirectory;
        File tempDirectory = new File(Constants.TEMP_DIRECTORY);
        if (!tempDirectory.exists()) {
            tempDirectory.mkdir();
        }
        if (!(jniorTempDirectory = new File(Constants.TEMP_DIRECTORY + File.separator + super.getJniorInfo().getSerialNumber())).exists()) {
            jniorTempDirectory.mkdir();
        }
        this._localTempFile = new File(jniorTempDirectory.getPath() + File.separator + remoteDeviceFilePath);
        FileOutputStream out = new FileOutputStream(this._localTempFile.getPath());
        return this._ftpClient.retrieveFile(remoteDeviceFilePath, out);
    }
}

