/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.cinema.devices;

import com.integ.supporter.cinema.devices.CinemaDevice;
import com.integ.supporter.cinema.devices.CinemaManagerDevice;
import com.integ.supporter.cinema.devices.CinemaServerClientDevice;
import com.integ.supporter.cinema.devices.FrontPanelLEDDevice;
import com.integ.supporter.cinema.devices.FrontPanelSoundDevice;
import com.integ.supporter.cinema.devices.HttpRequestDevice;
import com.integ.supporter.cinema.devices.InternalInputDevice;
import com.integ.supporter.cinema.devices.InternalOutputDevice;
import com.integ.supporter.cinema.devices.PreshowClientDevice;
import com.integ.supporter.cinema.devices.RawEthernetDevice;
import com.integ.supporter.cinema.devices.RawSerialDevice;
import com.integ.supporter.cinema.devices.RawUDPDevice;
import com.integ.supporter.cinema.devices.WakeOnLanDevice;
import com.integ.supporter.cinema.devices.projectors.BarcoProjectorDevice;
import com.integ.supporter.cinema.devices.projectors.ChristieProjectorDevice;
import com.integ.supporter.cinema.devices.projectors.NECProjectorDevice;
import com.integ.supporter.cinema.devices.projectors.NECSeries2ProjectorDevice;
import com.integ.supporter.cinema.devices.soundprocessors.Dolby3DDFC100Device;
import com.integ.supporter.cinema.devices.soundprocessors.DolbyCP650Device;
import com.integ.supporter.cinema.devices.soundprocessors.DolbyCP750Device;
import com.integ.supporter.cinema.devices.soundprocessors.DolbyCP850Device;
import com.integ.supporter.cinema.devices.soundprocessors.NECVT700Device;
import com.integ.supporter.cinema.devices.soundprocessors.QSCDCP300Device;
import com.integ.supporter.cinema.devices.soundprocessors.USLJSD100Device;

public class CinemaDeviceFactory {
    public static CinemaDevice getCinemaDevice(String device) {
        if ((device = device.toLowerCase()).startsWith("din")) {
            return new InternalInputDevice();
        }
        if (device.startsWith("rout")) {
            return new InternalOutputDevice();
        }
        if (device.startsWith("fpled")) {
            return new FrontPanelLEDDevice();
        }
        if (device.startsWith("fpsound")) {
            return new FrontPanelSoundDevice();
        }
        if (device.startsWith("cinema_server_client")) {
            return new CinemaServerClientDevice();
        }
        if (device.startsWith("preshow_client")) {
            return new PreshowClientDevice();
        }
        if (device.startsWith("cinema_manager")) {
            return new CinemaManagerDevice();
        }
        if (device.equals("raw ethernet")) {
            return new RawEthernetDevice();
        }
        if (device.equals("raw udp")) {
            return new RawUDPDevice();
        }
        if (device.equals("raw serial")) {
            return new RawSerialDevice();
        }
        if (device.equals("http request")) {
            return new HttpRequestDevice();
        }
        if (device.equals("wake on lan")) {
            return new WakeOnLanDevice();
        }
        if (device.equals("barco")) {
            return new BarcoProjectorDevice();
        }
        if (device.equals("christie")) {
            return new ChristieProjectorDevice();
        }
        if (device.equals("nec")) {
            return new NECProjectorDevice();
        }
        if (device.equals("nec series 2")) {
            return new NECSeries2ProjectorDevice();
        }
        if (device.equals("usl jsd100 ethernet")) {
            return new USLJSD100Device();
        }
        if (device.equals("dolby cp650 ethernet")) {
            return new DolbyCP650Device();
        }
        if (device.equals("dolby cp650 serial")) {
            return new DolbyCP650Device();
        }
        if (device.equals("dolby cp750 ethernet")) {
            return new DolbyCP750Device();
        }
        if (device.equals("dolby cp750 serial")) {
            return new DolbyCP750Device();
        }
        if (device.equals("dolby cp850 ethernet")) {
            return new DolbyCP850Device();
        }
        if (device.equals("dolby cp850")) {
            return new DolbyCP850Device();
        }
        if (device.equals("qsc dcp300 ethernet")) {
            return new QSCDCP300Device();
        }
        if (device.equals("dolby 3d dfc100 ethernet")) {
            return new Dolby3DDFC100Device();
        }
        if (device.equals("dolby 3d dfc100 serial")) {
            return new Dolby3DDFC100Device();
        }
        if (device.equals("nec vt700 serial")) {
            return new NECVT700Device();
        }
        throw new RuntimeException(String.format("Unknown device: %s", device));
    }
}

