/*
 * Decompiled with CFR 0.152.
 */
package com.integ.janoslib.net.beacon;

import com.integ.janoslib.net.beacon.Beacon;
import com.integ.janoslib.net.beacon.BeaconListener;
import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.janoslib.net.beacon.commands.RebootCommand;

public class BeaconRebooter
implements BeaconListener {
    private static final int TIMEOUT = 30000;
    private final JniorInfo _jniorInfo;
    private boolean _rebooting = false;

    public BeaconRebooter(JniorInfo jniorInfo) {
        this._jniorInfo = jniorInfo;
    }

    public boolean reboot() {
        try {
            Beacon.getInstance().addBeaconListener(this);
            Beacon.getInstance().broadcastCommand(new RebootCommand(this._jniorInfo));
            Beacon.getInstance().getBeaconNotifier().fireUnitUpdated(this._jniorInfo);
            long rebootTimeout = System.currentTimeMillis() + 30000L;
            while (!this._rebooting && System.currentTimeMillis() <= rebootTimeout) {
            }
        }
        finally {
            Beacon.getInstance().addBeaconListener(this);
        }
        return this._rebooting;
    }

    @Override
    public void unitUpdated(JniorInfo jniorInfo) {
        if (this._jniorInfo.getSerialNumber() == jniorInfo.getSerialNumber() && 2 == jniorInfo.Status) {
            this._rebooting = true;
            System.out.println(jniorInfo.getSerialNumber() + " is rebooting...");
        }
    }
}

