/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.backup;

import com.integ.janoslib.utils.PathUtils;
import com.integ.supporter.Constants;
import com.integ.supporter.backup.DownloadLogic;
import com.integ.supporter.backup.DownloadLogicFactory;
import java.io.File;
import org.json.JSONObject;

public class CacheDownloadLogic
extends DownloadLogic {
    public CacheDownloadLogic(JSONObject fileJson) {
        super(fileJson);
    }

    @Override
    public String getStorageDirectory() {
        String storagePath = PathUtils.combine(Constants.BACKUP_DIRECTORY, "cache");
        return storagePath;
    }

    @Override
    public String getLocalPath() {
        String fileParentDirectory = this._filepath.substring(0, this._filepath.lastIndexOf("/"));
        String filename = this._filepath.substring(fileParentDirectory.length() + 1);
        String fileExtension = PathUtils.getFileExtension(filename);
        String backupFilePath = PathUtils.combine(this.getStorageDirectory(), String.format("%s.%s", this._fileJson.getString("md5"), fileExtension));
        return backupFilePath;
    }

    @Override
    public boolean isFileNeeded() {
        boolean isNeeded;
        boolean bl = isNeeded = !new File(this.getLocalPath()).exists();
        if (isNeeded) {
            DownloadLogicFactory.LOGGER.info(String.format("backup cache needs %s", this._filepath));
        } else {
            ++this._savedDownloadCount;
            int fileLength = this._fileJson.getInt("length");
            this._savedDownloadSize += (long)fileLength;
        }
        return isNeeded;
    }

    @Override
    public String whyNotNeeded() {
        return String.format("%s exists in the backup cache", this._filepath);
    }

    @Override
    public File saveFileAs(byte[] fileContentBytes) {
        try {
            String localPath = this.getLocalPath();
            this.saveFileAs(localPath, fileContentBytes);
            return new File(localPath);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

