/*
 * Decompiled with CFR 0.152.
 */
package com.integ.protocols.jniorprotocol;

import com.integ.protocols.JniorConnection;
import com.integ.protocols.events.AuthenticationFailedEvent;
import com.integ.protocols.events.AuthenticationSuccessEvent;
import com.integ.protocols.events.JniorProtocolMessageListener;
import com.integ.protocols.events.JniorProtocolMessageNotifier;
import com.integ.protocols.events.JniorProtocolMessageReceivedEvent;
import com.integ.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JniorProtocolClient
extends JniorConnection {
    private static final int DEFAULT_PORT = 9200;
    private static final byte REQUEST_MESSAGE = 5;
    private static final byte COMMAND_MESSAGE = 10;
    private static final byte LOGIN_REQUEST_MESSAGE = 126;
    private static final short REQUEST_MONITOR_MESSAGE_REQUEST = 1;
    private static final short REQUEST_DISABLE_MONITOR_PACKET = 4;
    private long _lastAckTimeMs;
    protected final JniorProtocolMessageNotifier _messageNotifier = new JniorProtocolMessageNotifier();

    public JniorProtocolClient(String hostAddress) {
        super(hostAddress, 9200);
    }

    public JniorProtocolClient(String hostAddress, int port) {
        super(hostAddress, port);
    }

    public void addMessageListener(JniorProtocolMessageListener listener) {
        this._messageNotifier.addEventListener(listener);
    }

    public void removeMessageListener(JniorProtocolMessageListener listener) {
        this._messageNotifier.removeEventListener(listener);
    }

    @Override
    protected void connected() throws Exception {
        this._lastAckTimeMs = System.currentTimeMillis();
    }

    public void login(String username, String password) {
        ByteBuffer dbuf = ByteBuffer.allocate(3 + username.length() + password.length());
        dbuf.put((byte)126);
        dbuf.put((byte)username.length());
        dbuf.put(username.getBytes());
        dbuf.put((byte)password.length());
        dbuf.put(password.getBytes());
        byte[] commandBytes = dbuf.array();
        this.sendCommand(commandBytes);
    }

    public void disableMonitorPacket() {
        this.sendRequestPacket((short)4, 0);
    }

    public void scheduleMonitorPacket(int interval) {
        this.sendRequestPacket((short)1, interval);
    }

    private void sendRequestPacket(short option, int interval) {
        ByteBuffer dbuf = ByteBuffer.allocate(7);
        dbuf.put((byte)5);
        dbuf.putShort(option);
        dbuf.putInt(interval);
        this.sendCommand(dbuf.array());
    }

    public void closeOutput(int channel) {
        byte[] commandBytes = new byte[]{10, 1, 0, (byte)channel};
        this.sendCommand(commandBytes);
    }

    public void closeOutputs(int[] channels) {
        ByteBuffer sendBytesByteBuffer = ByteBuffer.allocate(9 * channels.length);
        for (int channel : channels) {
            byte[] commandBytes = new byte[]{10, 1, 0, (byte)channel};
            sendBytesByteBuffer.put(this.getSendBytes(commandBytes));
        }
        this.send(sendBytesByteBuffer.array());
    }

    public void openOutput(int channel) {
        byte[] commandBytes = new byte[]{10, 2, 0, (byte)channel};
        this.send(this.getSendBytes(commandBytes));
    }

    private byte[] getSendBytes(byte[] commandBytes) {
        ByteBuffer dbuf = ByteBuffer.allocate(5 + commandBytes.length);
        dbuf.put((byte)1);
        dbuf.putShort((short)commandBytes.length);
        dbuf.putShort((short)-1);
        dbuf.put(commandBytes);
        return dbuf.array();
    }

    public void sendCommand(byte[] commandBytes) {
        this.send(this.getSendBytes(commandBytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(byte[] outputBytes) {
        byte[] byArray = outputBytes;
        synchronized (outputBytes) {
            try {
                this._outputStream.write(outputBytes);
                this._outputStream.flush();
            }
            catch (IOException ex) {
                Logger.getLogger(JniorProtocolClient.class.getName()).log(Level.SEVERE, null, ex);
            }
            return;
        }
    }

    @Override
    public void runReceiverThread() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
        new Thread(() -> {
            block7: while (this.isConnected()) {
                try {
                    byte[] messageBytes = this.getMessage();
                    if (0 == messageBytes.length) continue;
                    System.out.println(String.format("<-- %s: %s", simpleDateFormat.format(new Date()), HexUtils.hexDump(messageBytes)));
                    int command = messageBytes[5] & 0xFF;
                    System.out.println("command = " + command);
                    switch (command) {
                        case 125: {
                            int authLevel = messageBytes[6] & 0xFF;
                            if (255 == authLevel) {
                                this._authenticationNotifier.fireAuthenticaionFailed(new AuthenticationFailedEvent(this, ""));
                                continue block7;
                            }
                            this._authenticationNotifier.fireAuthenticaionSuccess(new AuthenticationSuccessEvent(this, true, true));
                            continue block7;
                        }
                    }
                    this._messageNotifier.fireMessageReceived(new JniorProtocolMessageReceivedEvent(this, messageBytes));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        this.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }).start();
    }

    @Override
    protected byte[] getMessage() {
        try {
            System.out.println(System.currentTimeMillis() + ", _lastAckTimeMs: " + this._lastAckTimeMs);
            if (System.currentTimeMillis() >= this._lastAckTimeMs + 60000L) {
                this.send(new byte[]{6});
                this._lastAckTimeMs = System.currentTimeMillis();
            }
            this._socket.setSoTimeout(60000);
            System.out.println("timeout: " + this._socket.getSoTimeout());
            try {
                while (1 != this._dataInputStream.readByte()) {
                    Thread.sleep(10L);
                }
            }
            catch (SocketTimeoutException ex) {
                return new byte[0];
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.write(1);
            short length = this._dataInputStream.readShort();
            dataOutputStream.writeShort(length);
            short crc = this._dataInputStream.readShort();
            dataOutputStream.writeShort(crc);
            byte[] messageBytes = this._dataInputStream.readNBytes(length);
            dataOutputStream.write(messageBytes);
            byte[] bytes = byteArrayOutputStream.toByteArray();
            return bytes;
        }
        catch (Exception ex) {
            if (!this._socket.isClosed()) {
                throw new RuntimeException("Unable to read message", ex);
            }
            return null;
        }
    }
}

