/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui.menus;

import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.supporter.Constants;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.ui.menus.MenuAdapter;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;

public class FileMenu
extends JMenu {
    private JMenuItem _openOldJniorSupportToolDirectoryMenuItem;

    public FileMenu() {
        super("File");
        this.createMenu();
    }

    private void createMenu() {
        this.addOpenJniorSupporterDirectoryMenuItem();
        this.addOpenJniorSupportToolDirectoryMenuItem();
        this.addSeparator();
        this.addExitMenuItem();
        this.addMenuListener();
    }

    private void addOpenJniorSupporterDirectoryMenuItem() {
        JMenuItem menuItem = new JMenuItem("Open Jnior Supporter Directory...");
        menuItem.addActionListener(e -> {
            try {
                Desktop.getDesktop().open(new File(Constants.SUPPORTER_DIRECTORY));
            }
            catch (IOException ex) {
                String stacktrace = ExceptionUtils.getStackTrace(ex);
                Logger.getGlobal().severe(stacktrace);
                NotificationCollection.addError("Error opening the JNIOR Supporter Directory", ex);
            }
        });
        super.add(menuItem);
    }

    private void addOpenJniorSupportToolDirectoryMenuItem() {
        this._openOldJniorSupportToolDirectoryMenuItem = new JMenuItem("Open Old Jnior Support Tool Directory... ");
        this._openOldJniorSupportToolDirectoryMenuItem.addActionListener(e -> {
            try {
                Desktop.getDesktop().open(new File(Constants.JNIOR_SUPPORT_TOOL_DIRECTORY));
            }
            catch (IOException ex) {
                String stacktrace = ExceptionUtils.getStackTrace(ex);
                Logger.getGlobal().severe(stacktrace);
                NotificationCollection.addError("Error opening the JNIOR Supporter Directory", ex);
            }
        });
        super.add(this._openOldJniorSupportToolDirectoryMenuItem);
    }

    private void addExitMenuItem() {
        JMenuItem menuFileExit = new JMenuItem("Exit");
        menuFileExit.addActionListener(e -> SupporterMain.getInstance().tryExit());
        super.add(menuFileExit);
    }

    private void addMenuListener() {
        super.addMenuListener(new MenuAdapter(){

            @Override
            public void menuSelected(MenuEvent e) {
                File jniorSupportToolDirectoryFile = new File(Constants.JNIOR_SUPPORT_TOOL_DIRECTORY);
                FileMenu.this._openOldJniorSupportToolDirectoryMenuItem.setEnabled(jniorSupportToolDirectoryFile.exists());
            }
        });
    }
}

