/*
 * Decompiled with CFR 0.152.
 */
package com.integ.protocols.websockets;

import com.integ.protocols.jmpprotocol.Credentials;
import com.integ.protocols.jmpprotocol.JmpProtocolClient;
import com.integ.protocols.jmpprotocol.messages.JniorMessage;
import com.integ.protocols.jmpprotocol.messages.LoginMessage;
import com.integ.protocols.websockets.WebSocketFrame;
import java.io.IOException;
import java.util.Random;

public class WebSocketClient
extends JmpProtocolClient {
    private static final Object WRITE_LOCK = new Object();
    private static final int DEFAULT_PORT = 80;
    private byte[] _readBuffer = new byte[4096];
    private byte[] _writeBuffer = new byte[4096];

    public WebSocketClient(String hostString) {
        super(hostString, 80);
    }

    public WebSocketClient(String hostString, int port) {
        super(hostString, port);
    }

    @Override
    protected void connected() throws Exception {
        this.doUpgrade();
        super.connected();
    }

    private void doUpgrade() {
        try {
            String getRequest = "GET / HTTP/1.1\r\nUpgrade: WebSocket\r\nConnection: Upgrade\r\nSec-WebSocket-Version: 13\r\nSec-WebSocket-Key: ZTUxNjYwYTYtOTk1OS00Mw==\r\nHost: " + super.getHostAddress() + "\r\nOrigin: ws://" + super.getHostAddress() + "\r\n\r\n";
            byte[] getRequestBytes = getRequest.getBytes();
            this._outputStream.write(getRequestBytes);
            this._outputStream.flush();
            int bytesRead = this._dataInputStream.read(this._readBuffer, 0, this._readBuffer.length);
            String upgradeResponse = new String(this._readBuffer, 0, bytesRead);
            System.out.println(upgradeResponse);
            String[] responseParts = upgradeResponse.split(" ");
            if (0 > "400".compareTo(responseParts[1])) {
                throw new IOException("error upgrading connection for " + super.getHostAddress() + ": " + responseParts[2]);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("error requesting connection upgrade for " + super.getHostAddress(), ex);
        }
    }

    @Override
    protected byte[] getMessage() {
        try {
            WebSocketFrame webSocketFrame = WebSocketFrame.getFrame(this._dataInputStream);
            if (webSocketFrame.isTextFrame()) {
                String message = new String(webSocketFrame.getBytes(), 0, webSocketFrame.getLength());
                return message.getBytes();
            }
            return null;
        }
        catch (IOException ex) {
            throw new RuntimeException("error getting message for " + super.getHostAddress(), ex);
        }
    }

    private void sendPong() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(JniorMessage jniorMessage) throws IOException {
        if (jniorMessage instanceof LoginMessage) {
            LoginMessage loginMessage = (LoginMessage)jniorMessage;
            this._credentials = new Credentials(loginMessage.getUsername(), loginMessage.getPassword());
        }
        Object object = WRITE_LOCK;
        synchronized (object) {
            try {
                String jniorMessageString = jniorMessage.toString();
                System.out.println(String.format("%s: --> %s", this.getClientString(), jniorMessageString));
                int length = jniorMessageString.length();
                if (this._writeBuffer.length < length + 8) {
                    this._writeBuffer = new byte[length + 8];
                }
                int pos = 0;
                this._writeBuffer[pos++] = -127;
                if (length <= 125) {
                    this._writeBuffer[pos++] = (byte)length;
                } else if (length < 65536) {
                    this._writeBuffer[pos++] = 126;
                    this._writeBuffer[pos++] = (byte)(length >> 8 & 0xFF);
                    this._writeBuffer[pos++] = (byte)(length & 0xFF);
                }
                this._writeBuffer[1] = (byte)(this._writeBuffer[1] | 0x80);
                byte[] _maskingBuffer = new byte[4];
                for (int j = 0; j < 4; ++j) {
                    _maskingBuffer[j] = (byte)new Random().nextInt(255);
                }
                System.arraycopy(_maskingBuffer, 0, this._writeBuffer, pos, 4);
                pos += 4;
                byte[] messageBytes = jniorMessageString.getBytes();
                for (int i = 0; i < length; ++i) {
                    try {
                        this._writeBuffer[i + pos] = (byte)(messageBytes[i] ^ _maskingBuffer[i % 4]);
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                this._outputStream.write(this._writeBuffer, 0, length + pos);
                this._outputStream.flush();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    super.close();
                }
                catch (Exception ex1) {
                    throw new IOException(ex);
                }
            }
        }
    }
}

