/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.updater.steps;

import com.integ.supporter.updater.steps.FtpStep;
import org.w3c.dom.Element;

public class LoadApplicationStep
extends FtpStep {
    protected final String _versionLocation = this.getChildNodeString("VersionLocation");
    protected final String _version;
    protected final boolean _rebootRequired;

    public LoadApplicationStep(Element xmlElement) {
        super(xmlElement);
        System.out.println("VersionLocation: " + this._versionLocation);
        this._version = this.getChildNodeString("Version");
        System.out.println("Version: " + this._version);
        String rebootRequiredString = this.getAttributeString("RebootRequired");
        this._rebootRequired = Boolean.parseBoolean(rebootRequiredString);
        System.out.println("Version: " + this._version);
    }

    @Override
    public boolean execute() throws Exception {
        boolean success = true;
        boolean performUpdate = true;
        if (!"".equals(this._version)) {
            String remoteVersion = this.getRemoteVersion();
            boolean bl = performUpdate = !remoteVersion.equals(this._version);
        }
        if (performUpdate) {
            if (super.execute() && this._updated) {
                this._updateProjectExecutor.setRebootNeededFlag();
            }
        } else {
            this._logger.info("  update not needed");
        }
        return success;
    }

    private String getRemoteVersion() throws Exception {
        String version = "";
        if (null != this._versionLocation && !"".equals(this._versionLocation)) {
            version = this.getRegistryKeyValue(this._versionLocation);
            this._logger.info(String.format("  remote version is %s", version));
        }
        return version;
    }

    private String getRegistryKeyValue(String registryKey) throws Exception {
        String command = String.format("registry %s", registryKey);
        String currentValue = "";
        String regResponse = this._jniorUpdateControlConnection.exec(command);
        int equalsPos = regResponse.indexOf("= ");
        if (-1 != equalsPos) {
            currentValue = regResponse.substring(equalsPos + 2);
        }
        return currentValue;
    }
}

