/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui;

import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class ResizablePanel
extends JPanel {
    private boolean _dragging = false;
    private int _dragStartWidth;
    private Point _dragStartLocation = new Point();

    public ResizablePanel() {
        this.addMouseHandlers();
    }

    public final void addMouseHandlers() {
        this.setPreferredSize(new Dimension(500, 500));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (10.0 > e.getPoint().getX()) {
                    ResizablePanel.this.setCursor(Cursor.getPredefinedCursor(10));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ResizablePanel.this.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (10.0 > e.getPoint().getX()) {
                    ResizablePanel.this._dragging = true;
                    ResizablePanel.this._dragStartLocation = MouseInfo.getPointerInfo().getLocation();
                    ResizablePanel.this._dragStartWidth = ResizablePanel.this.getWidth();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ResizablePanel.this._dragging = false;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (ResizablePanel.this._dragging) {
                    double deltaX = MouseInfo.getPointerInfo().getLocation().getX() - ResizablePanel.this._dragStartLocation.getX();
                    int newWidth = (int)((double)ResizablePanel.this._dragStartWidth - deltaX);
                    Dimension size = new Dimension(newWidth, ResizablePanel.this.getHeight());
                    if (ResizablePanel.this.isMinimumSizeSet() && size.getWidth() < ResizablePanel.this.getMinimumSize().getWidth()) {
                        size = ResizablePanel.this.getMinimumSize();
                    } else if (ResizablePanel.this.isMaximumSizeSet() && size.getWidth() > ResizablePanel.this.getMaximumSize().getWidth()) {
                        size = ResizablePanel.this.getMaximumSize();
                    }
                    ResizablePanel.this.setPreferredSize(size);
                    ResizablePanel.this.revalidate();
                }
            }
        });
    }

    @Override
    protected void paintBorder(Graphics g) {
        Border border = this.getBorder();
        if (border != null && border instanceof EmptyBorder) {
            Color gripColor = UIManager.getColor("SplitPaneDivider.gripColor");
            int gripDotCount = FlatUIUtils.getUIInt("SplitPaneDivider.gripDotCount", 3);
            int gripDotSize = FlatUIUtils.getUIInt("SplitPaneDivider.gripDotSize", 3);
            int gripGap = FlatUIUtils.getUIInt("SplitPaneDivider.gripGap", 2);
            g.setColor(gripColor);
            FlatUIUtils.paintGrip(g, 0, 0, ((EmptyBorder)border).getBorderInsets().left, this.getHeight(), false, gripDotCount, gripDotSize, gripGap, true);
        }
    }
}

