/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.config;

import com.integ.supporter.Constants;
import com.integ.supporter.config.JsonConfigFile;
import java.io.File;
import java.util.Base64;
import java.util.Date;
import org.json.JSONObject;

public class JniorsSavedStates
extends JsonConfigFile {
    private static final File BACKUP_SERVICES_CONFIG_JSON_FILE = new File(Constants.CONFIG_DIRECTORY + "JniorsSavedStates.json");
    private static final JniorsSavedStates INSTANCE = new JniorsSavedStates();

    public static JniorsSavedStates getInstance() {
        return INSTANCE;
    }

    private JniorsSavedStates() {
        super(BACKUP_SERVICES_CONFIG_JSON_FILE);
    }

    private JSONObject getJniorsJsonObject() {
        if (!this._configJson.has("Jniors")) {
            this._configJson.put("Jniors", new JSONObject());
            this.changed();
        }
        JSONObject jsonObject = this._configJson.getJSONObject("Jniors");
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject getJsonForJnior(int serialNumber) {
        JniorsSavedStates jniorsSavedStates = INSTANCE;
        synchronized (jniorsSavedStates) {
            JSONObject jniorsJson = INSTANCE.getJniorsJsonObject();
            String serialNumberString = String.valueOf(serialNumber);
            if (!jniorsJson.has(serialNumberString)) {
                jniorsJson.put(serialNumberString, new JSONObject());
            }
            JSONObject jniorJson = jniorsJson.getJSONObject(serialNumberString);
            return jniorJson;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateUsernamePassword(int serialNumber, String username, String password) {
        JniorsSavedStates jniorsSavedStates = INSTANCE;
        synchronized (jniorsSavedStates) {
            INSTANCE.shouldReloadConfig();
            JSONObject jniorJson = INSTANCE.getJsonForJnior(serialNumber);
            jniorJson.put("Username", username);
            byte[] passwordBytes = password.getBytes();
            String encodedString = Base64.getEncoder().encodeToString(passwordBytes);
            jniorJson.put("Password", encodedString);
            INSTANCE.changed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getUsePassiveFtp(int serialNumber) {
        JniorsSavedStates jniorsSavedStates = INSTANCE;
        synchronized (jniorsSavedStates) {
            INSTANCE.shouldReloadConfig();
            JSONObject jniorJson = INSTANCE.getJsonForJnior(serialNumber);
            boolean userPassiveFtp = jniorJson.optBoolean("PassiveFtp", true);
            return userPassiveFtp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUsePassiveFtp(int serialNumber, boolean setUsePassiveFtp) {
        JniorsSavedStates jniorsSavedStates = INSTANCE;
        synchronized (jniorsSavedStates) {
            INSTANCE.shouldReloadConfig();
            JSONObject jniorJson = INSTANCE.getJsonForJnior(serialNumber);
            jniorJson.put("PassiveFtp", setUsePassiveFtp);
            INSTANCE.changed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastBackupTimeForJnior(int serialNumber) {
        JniorsSavedStates jniorsSavedStates = INSTANCE;
        synchronized (jniorsSavedStates) {
            INSTANCE.shouldReloadConfig();
            JSONObject jniorJson = INSTANCE.getJsonForJnior(serialNumber);
            if (jniorJson.has("LastBackupTime")) {
                long lastBackupTime = jniorJson.getLong("LastBackupTime");
                return lastBackupTime;
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLastBackupTimeForJnior(int serialNumber, long lastBackupTime) {
        JniorsSavedStates jniorsSavedStates = INSTANCE;
        synchronized (jniorsSavedStates) {
            INSTANCE.shouldReloadConfig();
            JSONObject jniorJson = INSTANCE.getJsonForJnior(serialNumber);
            jniorJson.put("LastBackupTime", lastBackupTime);
            jniorJson.put("LastBackupTimeString", new Date(lastBackupTime));
            INSTANCE.changed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastSnapshotTime(int serialNumber) {
        JniorsSavedStates jniorsSavedStates = INSTANCE;
        synchronized (jniorsSavedStates) {
            INSTANCE.shouldReloadConfig();
            JSONObject jniorJson = INSTANCE.getJsonForJnior(serialNumber);
            long lastSnapshotTime = 0L;
            if (jniorJson.has("LastSnapshotTime")) {
                lastSnapshotTime = jniorJson.getLong("LastSnapshotTime");
            }
            return lastSnapshotTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSnapshotTime(int serialNumber, long snapshotEndTime) {
        JniorsSavedStates jniorsSavedStates = INSTANCE;
        synchronized (jniorsSavedStates) {
            INSTANCE.shouldReloadConfig();
            JSONObject jniorJson = INSTANCE.getJsonForJnior(serialNumber);
            jniorJson.put("LastSnapshotTime", snapshotEndTime);
            jniorJson.put("LastSnapshotTimeString", new Date(snapshotEndTime));
            INSTANCE.changed();
        }
    }
}

