/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui.properties;

import com.integ.supporter.Constants;
import com.integ.supporter.config.GeneralConfig;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class GeneralPropertiesPanel
extends JPanel {
    private JCheckBox showCinemaInMainMenuCheckBox;
    private JCheckBox showFullOsVersionInBeacon;
    private JCheckBox showIconsWithTextMenuCheckBox;
    private JCheckBox useIconsInMainMenuCheckBox;

    public GeneralPropertiesPanel() {
        this.initComponents();
        this.loadConfig();
    }

    private void initComponents() {
        this.showFullOsVersionInBeacon = new JCheckBox();
        this.useIconsInMainMenuCheckBox = new JCheckBox();
        this.showIconsWithTextMenuCheckBox = new JCheckBox();
        this.showCinemaInMainMenuCheckBox = new JCheckBox();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                GeneralPropertiesPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new GridLayout(0, 1));
        this.showFullOsVersionInBeacon.setText("Show Full OS Version in Beacon");
        this.showFullOsVersionInBeacon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneralPropertiesPanel.this.showFullOsVersionInBeaconActionPerformed(evt);
            }
        });
        this.add(this.showFullOsVersionInBeacon);
        this.useIconsInMainMenuCheckBox.setText("Use Icons in Main Menu (If Applicable)");
        this.useIconsInMainMenuCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneralPropertiesPanel.this.useIconsInMainMenuCheckBoxActionPerformed(evt);
            }
        });
        this.add(this.useIconsInMainMenuCheckBox);
        this.showIconsWithTextMenuCheckBox.setText("Show Icons With Text");
        this.showIconsWithTextMenuCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneralPropertiesPanel.this.showIconsWithTextMenuCheckBoxActionPerformed(evt);
            }
        });
        this.add(this.showIconsWithTextMenuCheckBox);
        this.showCinemaInMainMenuCheckBox.setText("Enable Cinema Menu Item in Main Menu");
        this.showCinemaInMainMenuCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneralPropertiesPanel.this.showCinemaInMainMenuCheckBoxActionPerformed(evt);
            }
        });
        this.add(this.showCinemaInMainMenuCheckBox);
    }

    private void formComponentShown(ComponentEvent evt) {
        this.loadConfig();
        boolean iconsAvailable = true;
        if (Constants.OS_NAME.toLowerCase().startsWith("windows")) {
            System.out.println(System.getProperty("os.version"));
            double osVersion = Double.parseDouble(System.getProperty("os.version"));
            if (10.0 <= osVersion) {
                iconsAvailable = false;
            }
        }
        this.useIconsInMainMenuCheckBox.setEnabled(iconsAvailable);
    }

    private void showIconsWithTextMenuCheckBoxActionPerformed(ActionEvent evt) {
        GeneralConfig.setIconsWithText(this.showIconsWithTextMenuCheckBox.isSelected());
    }

    private void useIconsInMainMenuCheckBoxActionPerformed(ActionEvent evt) {
        GeneralConfig.setMainMenuUseIcons(this.useIconsInMainMenuCheckBox.isSelected());
    }

    private void showCinemaInMainMenuCheckBoxActionPerformed(ActionEvent evt) {
        GeneralConfig.setShowCinemaInMainMenu(this.showCinemaInMainMenuCheckBox.isSelected());
    }

    private void showFullOsVersionInBeaconActionPerformed(ActionEvent evt) {
        GeneralConfig.setShowFullOsVersion(this.showFullOsVersionInBeacon.isSelected());
    }

    private void loadConfig() {
        this.showFullOsVersionInBeacon.setSelected(GeneralConfig.getShowFullOsVersion());
        this.useIconsInMainMenuCheckBox.setSelected(GeneralConfig.getMainMenuUseIcons());
        this.showIconsWithTextMenuCheckBox.setSelected(GeneralConfig.getIconsWithText());
        this.showCinemaInMainMenuCheckBox.setSelected(GeneralConfig.getShowCinemaInMainMenu());
    }
}

