/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.snapshot;

import com.integ.janoslib.utils.ZipUtils;
import com.integ.supporter.snapshot.NotSnapshotFileException;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;

public class SnapshotFile {
    private final File _snapshotFile;
    private final boolean _isSnapshotFileFound;

    public SnapshotFile(File file) throws NotSnapshotFileException {
        this._snapshotFile = file;
        String lowercaseFileName = file.getName().toLowerCase();
        if (!lowercaseFileName.endsWith(".zip")) {
            throw new NotSnapshotFileException(file, "not a .zip file");
        }
        ZipEntry snapshotFileEntry = null;
        try {
            snapshotFileEntry = ZipUtils.getEntry(file.getPath(), "_snapshot.log");
        }
        catch (IOException ex) {
            throw new NotSnapshotFileException(file, ex);
        }
        boolean bl = this._isSnapshotFileFound = null != snapshotFileEntry;
        if (!this._isSnapshotFileFound) {
            throw new NotSnapshotFileException(file);
        }
    }

    public boolean isSnapshotFile() {
        return this._isSnapshotFileFound;
    }

    public File getFile() {
        return this._snapshotFile;
    }

    public String getName() {
        return this._snapshotFile.getName();
    }

    public byte[] getFileEntry(String entryFileName) throws IOException {
        byte[] contents = ZipUtils.extractEntry(this._snapshotFile.getPath(), entryFileName);
        return contents;
    }

    public boolean dumpLogExists() throws IOException {
        return ZipUtils.findEntry(this._snapshotFile.getPath(), "dump.log");
    }

    public boolean errorsLogExists() throws IOException {
        return ZipUtils.findEntry(this._snapshotFile.getPath(), "errors.log");
    }

    public String getSnapshotLogFileContent() {
        try {
            byte[] snapshotDotLogBytes = this.getFileEntry("_snapshot.log");
            if (null != snapshotDotLogBytes) {
                String snapshotDotLog = new String(snapshotDotLogBytes);
                snapshotDotLog = snapshotDotLog.replace("\r\n", "\n");
                return snapshotDotLog;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }
}

