/*
 * Decompiled with CFR 0.152.
 */
package com.integ.websocket.helpers;

import com.integ.websocket.WebSocketClient;
import com.integ.websocket.WebSocketClientMessageListener;
import com.integ.websocket.WebSocketClientMessageReceivedEvent;
import com.integ.websocket.helpers.FileProgressErrorEvent;
import com.integ.websocket.helpers.FileProgressListener;
import com.integ.websocket.helpers.FileProgressNotifier;
import com.integ.websocket.messages.FileRead;
import com.integ.websocket.messages.FileReadWithOffset;
import com.integ.websocket.messages.FileReadWithRequestId;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import org.json.JSONObject;

public class DownloadFile
implements WebSocketClientMessageListener {
    private static final HashMap<String, Object> FILE_RECEIVE_WAIT_OBJECT = new HashMap();
    private final int LIMIT = 131072;
    private final WebSocketClient _websocketClient;
    private final String _remotePath;
    private int _offset = 0;
    private FileRead _fileRead;
    private boolean _success;
    private final ByteArrayOutputStream _fileContents = new ByteArrayOutputStream();
    private final FileProgressNotifier _fileProgressNotifier = new FileProgressNotifier();

    public DownloadFile(WebSocketClient websocketClient, String filename) {
        websocketClient.addMessageListener(this);
        this._websocketClient = websocketClient;
        this._remotePath = filename;
    }

    public void addFileProgressListener(FileProgressListener fileProgressListener) {
        this._fileProgressNotifier.addEventListener(fileProgressListener);
    }

    public void removeFileProgressListener(FileProgressListener fileProgressListener) {
        this._fileProgressNotifier.removeEventListener(fileProgressListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(WebSocketClientMessageReceivedEvent event) {
        block26: {
            WebSocketClient websocketClient = event.getClient();
            JSONObject jsonMessage = event.getJsonMessage();
            String message = jsonMessage.getString("Message");
            if ("File Read Response".equals(message)) {
                String status = jsonMessage.getString("Status");
                JSONObject meta = jsonMessage.getJSONObject("Meta");
                String hash = meta.getString("Hash");
                if (!"Fail".equalsIgnoreCase(status)) {
                    try {
                        if (jsonMessage.has("RequestID")) {
                            long requestId = jsonMessage.getLong("RequestID");
                            URL url = new URL(String.format("http://%s/query.cgi?request=%d", websocketClient.getIpAddress(), requestId));
                            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                            connection.setRequestMethod("GET");
                            int httpGetStatus = connection.getResponseCode();
                            if (200 == httpGetStatus) {
                                try {
                                    Object thisFileWaitObject;
                                    int bytesRead;
                                    DataInputStream in = new DataInputStream(connection.getInputStream());
                                    byte[] buffer = new byte[4096];
                                    int contentLength = connection.getContentLength();
                                    this._fileContents.reset();
                                    while (0 < (bytesRead = in.read(buffer))) {
                                        this._fileContents.write(buffer, 0, bytesRead);
                                        int n = this._fileContents.size() * 100 / contentLength;
                                    }
                                    in.close();
                                    this._fileContents.close();
                                    this._success = true;
                                    Object object = thisFileWaitObject = FILE_RECEIVE_WAIT_OBJECT.get(hash);
                                    synchronized (object) {
                                        thisFileWaitObject.notifyAll();
                                        break block26;
                                    }
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    break block26;
                                }
                                finally {
                                    connection.disconnect();
                                }
                            }
                            System.out.println(url + " return code " + httpGetStatus);
                            break block26;
                        }
                        if (!this._fileRead.getHash().equals(hash)) break block26;
                        String fileData = jsonMessage.getString("Data");
                        byte[] contents = Base64.getDecoder().decode(fileData);
                        this._fileContents.write(contents);
                        int numberOfBytesRead = jsonMessage.getInt("NumRead");
                        System.out.println("numberOfBytesRead: " + numberOfBytesRead);
                        this._offset += numberOfBytesRead;
                        int fileSize = jsonMessage.getInt("Size");
                        int percent = this._fileContents.size() * 100 / fileSize;
                        if (fileSize == this._offset) {
                            Object thisFileWaitObject;
                            this._fileContents.close();
                            this._success = true;
                            Object object = thisFileWaitObject = FILE_RECEIVE_WAIT_OBJECT.get(hash);
                            synchronized (object) {
                                thisFileWaitObject.notifyAll();
                                break block26;
                            }
                        }
                        if (this._offset > fileSize) {
                            throw new RuntimeException("Offset past end of file");
                        }
                        System.out.println("read more file @ " + new Date());
                        ((FileReadWithOffset)this._fileRead).setOffset(this._offset);
                        this._websocketClient.send(this._fileRead);
                    }
                    catch (IOException ex) {
                        this._fileProgressNotifier.notifyFileProgressError(new FileProgressErrorEvent(this, this._remotePath, ex.getMessage()));
                    }
                    catch (Exception ex) {
                        this._fileProgressNotifier.notifyFileProgressError(new FileProgressErrorEvent(this, this._remotePath, ex.getMessage()));
                    }
                } else {
                    this._fileProgressNotifier.notifyFileProgressError(new FileProgressErrorEvent(this, this._remotePath, String.format("File Download Failed: %s", jsonMessage.toString())));
                    Object thisFileWaitObject = FILE_RECEIVE_WAIT_OBJECT.get(hash);
                    if (null != thisFileWaitObject) {
                        Object object = thisFileWaitObject;
                        synchronized (object) {
                            thisFileWaitObject.notifyAll();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getContents() {
        this._fileRead = new FileReadWithRequestId(this._remotePath);
        this._websocketClient.send(this._fileRead);
        Object thisFileWaitObject = new Object();
        FILE_RECEIVE_WAIT_OBJECT.put(this._fileRead.getHash(), thisFileWaitObject);
        try {
            Object object = thisFileWaitObject;
            synchronized (object) {
                thisFileWaitObject.wait(10000L);
            }
        }
        catch (InterruptedException ex) {
            this._fileProgressNotifier.notifyFileProgressError(new FileProgressErrorEvent(this, this._remotePath, ex.getMessage()));
        }
        this._websocketClient.removeMessageListener(this);
        if (this._success) {
            System.out.println(this._fileRead.getFilename() + " was received");
            return this._fileContents.toByteArray();
        }
        System.out.println(this._fileRead.getFilename() + " read Failed");
        return null;
    }
}

