/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.cinema.macro;

import com.integ.supporter.cinema.macro.Macro;
import com.integ.supporter.cinema.macro.MacroAction;
import com.integ.supporter.cinema.macro.MacroActionTreeNode;
import com.integ.supporter.cinema.macro.MacroFile;
import com.integ.supporter.cinema.macro.MacroTreeNode;
import com.integ.supporter.ui.jtreetable.AbstractTreeTableModel;
import com.integ.supporter.ui.jtreetable.TreeTableModel;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class MacroTreeModel
extends AbstractTreeTableModel {
    private static final String[] COLUMN_NAMES = new String[]{"Name", "Timing", "Action"};
    private static final Class<?>[] COLUMN_TYPES = new Class[]{TreeTableModel.class, String.class, String.class};
    private final MacroFile _macroFile;
    private final DefaultMutableTreeNode _rootNode;

    public MacroTreeModel(MacroFile macroFile) {
        super(new DefaultMutableTreeNode("Macros"));
        this._macroFile = macroFile;
        this._rootNode = (DefaultMutableTreeNode)this.getRoot();
        ArrayList<Macro> macros = macroFile.getMacros();
        for (Macro macro : macros) {
            MacroTreeNode macroTreeNode = new MacroTreeNode(macro);
            this._rootNode.add(macroTreeNode);
            for (MacroAction macroAction : macro.getActions()) {
                macroTreeNode.add(new MacroActionTreeNode(macroAction));
            }
        }
    }

    public void addMacro(Macro macro) {
        this._macroFile.addMacro(macro);
        MacroTreeNode macroTreeNode = new MacroTreeNode(macro);
        this._rootNode.add(macroTreeNode);
        for (MacroAction macroAction : macro.getActions()) {
            macroTreeNode.add(new MacroActionTreeNode(macroAction));
        }
        this.nodesWereInserted(this._rootNode, new int[]{this._rootNode.getChildCount() - 1});
    }

    public void nodesWereInserted(TreeNode node, int[] childIndices) {
        if (this.listenerList != null && node != null && childIndices != null && childIndices.length > 0) {
            int cCount = childIndices.length;
            Object[] newChildren = new Object[cCount];
            for (int counter = 0; counter < cCount; ++counter) {
                newChildren[counter] = node.getChildAt(childIndices[counter]);
            }
            this.fireTreeNodesInserted(this, this.getPathToRoot(node), childIndices, newChildren);
        }
    }

    public void nodeStructureChanged(TreeNode node) {
        if (node != null) {
            super.fireTreeStructureChanged(this, this.getPathToRoot(node), null, null);
        }
    }

    protected TreeNode[] getPathToRoot(TreeNode aNode) {
        return this.getPathToRoot(aNode, 0);
    }

    protected TreeNode[] getPathToRoot(TreeNode aNode, int depth) {
        TreeNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new TreeNode[depth];
        } else {
            retNodes = aNode == this.root ? new TreeNode[depth] : this.getPathToRoot(aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return COLUMN_TYPES[column];
    }

    @Override
    public Object getValueAt(Object node, int column) {
        switch (column) {
            case 0: {
                return ((TreeNode)node).toString();
            }
            case 1: {
                if (node instanceof MacroActionTreeNode) {
                    return ((MacroActionTreeNode)node).getTimingString();
                }
            }
            case 2: {
                if (!(node instanceof MacroActionTreeNode)) break;
                return ((MacroActionTreeNode)node).getAction();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        if (node instanceof MacroTreeNode) {
            return 0 == column;
        }
        return true;
    }

    @Override
    public void setValueAt(Object aValue, Object node, int column) {
    }

    @Override
    public Object getChild(Object parent, int index) {
        TreeNode treeNode = (TreeNode)parent;
        return treeNode.getChildAt(index);
    }

    @Override
    public int getChildCount(Object parent) {
        TreeNode treeNode = (TreeNode)parent;
        return treeNode.getChildCount();
    }
}

