/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.cinema;

import com.integ.supporter.SupporterMain;
import com.integ.supporter.cinema.LocalMacroFileOpener;
import com.integ.supporter.cinema.RemoteMacroFileOpener;
import com.integ.supporter.cinema.device.DeviceFile;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.filechooser.FileFilter;

public class CinemaToolsMenu
extends JMenu {
    public CinemaToolsMenu() {
        super("Cinema Tools");
        this.initMenuItems();
    }

    private void initMenuItems() {
        this.addOpenDevicesFileMenuItem();
        this.addSeparator();
        this.addOpenMacroFileMenuItem();
    }

    private void addOpenDevicesFileMenuItem() {
        JMenuItem openLocalDevicesFileMenuItem = new JMenuItem("Open Local Devices File");
        openLocalDevicesFileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setCurrentDirectory(new File(SupporterMain.CINEMA_FILES_FOLDER));
                fileChooser.setFileSelectionMode(0);
                fileChooser.addChoosableFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        String filename = file.getName();
                        return filename.startsWith("devices") && filename.endsWith(".csv");
                    }

                    @Override
                    public String getDescription() {
                        return "Devices Files";
                    }
                });
                fileChooser.setAcceptAllFileFilterUsed(true);
                int result = fileChooser.showOpenDialog(CinemaToolsMenu.super.getRootPane());
                if (result == 0) {
                    this.loadDevicesFile(fileChooser.getSelectedFile());
                }
            }

            private void loadDevicesFile(File file) {
                DeviceFile cinemaDeviceFile = new DeviceFile(file);
            }
        });
        super.add(openLocalDevicesFileMenuItem);
        JMenuItem openRemoteDevicesFileMenuItem = new JMenuItem("Open Remote Devices File");
        openRemoteDevicesFileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setCurrentDirectory(new File(SupporterMain.CINEMA_FILES_FOLDER));
                fileChooser.setFileSelectionMode(0);
                fileChooser.addChoosableFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        String filename = file.getName();
                        return filename.startsWith("devices") && filename.endsWith(".csv");
                    }

                    @Override
                    public String getDescription() {
                        return "Devices Files";
                    }
                });
                fileChooser.setAcceptAllFileFilterUsed(true);
                int result = fileChooser.showOpenDialog(CinemaToolsMenu.super.getRootPane());
                if (result == 0) {
                    this.loadDevicesFile(fileChooser.getSelectedFile());
                }
            }

            private void loadDevicesFile(File file) {
                DeviceFile cinemaDeviceFile = new DeviceFile(file);
            }
        });
        super.add(openRemoteDevicesFileMenuItem);
    }

    private void addOpenMacroFileMenuItem() {
        JMenuItem openLocalMacroFileMenuItem = new JMenuItem("Open Local Macro File");
        openLocalMacroFileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new LocalMacroFileOpener(CinemaToolsMenu.this.getRootPane());
            }
        });
        super.add(openLocalMacroFileMenuItem);
        JMenuItem openRemoteMacroFileMenuItem = new JMenuItem("Open Remote Macro File");
        openRemoteMacroFileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    new RemoteMacroFileOpener(CinemaToolsMenu.this.getRootPane());
                }
                catch (IOException ex) {
                    Logger.getLogger(CinemaToolsMenu.class.getName()).severe(ex.getMessage());
                }
            }
        });
        super.add(openRemoteMacroFileMenuItem);
    }
}

