/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.backup;

import com.integ.supporter.SupporterMain;
import com.integ.supporter.backup.BackupServiceEngine;
import com.integ.supporter.backup.BackupServiceListener;
import com.integ.supporter.backup.JniorBackup;
import com.integ.supporter.ui.TextPaneLog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class BackupTab
extends JPanel
implements BackupServiceListener {
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final TextPaneLog _textPaneLog;
    private JButton jButton1;
    private JScrollPane jScrollPane1;
    private JTextPane textPaneBackupServiceLog;

    public BackupTab() {
        this.initComponents();
        this._textPaneLog = new TextPaneLog(this.textPaneBackupServiceLog);
        Handler handler = new Handler(){

            @Override
            public void publish(LogRecord record) {
                String currentTime = SIMPLE_DATE_FORMAT.format(new Date());
                StringBuilder sb = new StringBuilder();
                sb.append(currentTime).append(", ").append(record.getMessage()).append("\r\n");
                BackupTab.this._textPaneLog.log(sb.toString());
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        };
        BackupServiceEngine.addHandler(handler);
        JniorBackup.addHandler(handler);
        BackupServiceEngine.addListener(this);
    }

    @Override
    public void jniorBackupStarted(EventObject event) {
        JniorBackup currentJniorBackup = BackupServiceEngine.getInstance().getCurrentJniorBackup();
        SupporterMain.setTabTitle(this, "Backup - Processing " + currentJniorBackup.getHost());
    }

    @Override
    public void jniorBackupEnded(EventObject event) {
        SupporterMain.setTabTitle(this, "Backup");
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.textPaneBackupServiceLog = new JTextPane();
        this.jButton1.setText("jButton1");
        this.setLayout(new BorderLayout());
        this.textPaneBackupServiceLog.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                BackupTab.this.textPaneBackupServiceLogKeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.textPaneBackupServiceLog);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void textPaneBackupServiceLogKeyPressed(KeyEvent evt) {
    }
}

