/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.backup;

import com.integ.beacon.BeaconListener;
import com.integ.beacon.JniorInfo;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.supporter.RollingLog;
import com.integ.supporter.backup.BackupServiceListener;
import com.integ.supporter.backup.BackupServicesConfig;
import com.integ.supporter.backup.JniorBackup;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.logging.Handler;
import java.util.logging.Logger;

public class BackupServiceEngine
implements Runnable,
BeaconListener {
    private static final Logger LOGGER = RollingLog.getLogger("BackupServiceEngine");
    private static final ArrayList<JniorBackup> JNIOR_BACKUP_SERVICES_COLLECTION = new ArrayList();
    private static final BackupServiceEngine INSTANCE = new BackupServiceEngine();
    private final Object WAIT_LOCK = new Object();
    private Thread _thread = null;
    private boolean _userRequestedInterrupt = false;
    private JniorBackup _currentJniorBackup;
    private JniorBackup _nextJniorBackup;
    private final ArrayList<BackupServiceListener> _listeners = new ArrayList();

    public static BackupServiceEngine getInstance() {
        return INSTANCE;
    }

    public static void addHandler(Handler handler) {
        LOGGER.addHandler(handler);
    }

    public static void addListener(BackupServiceListener listener) {
        BackupServiceEngine.INSTANCE._listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addJnior(JniorInfo jniorInfo) {
        ArrayList<JniorBackup> arrayList = JNIOR_BACKUP_SERVICES_COLLECTION;
        synchronized (arrayList) {
            INSTANCE.start();
            String ipAddress = jniorInfo.IpAddress;
            boolean backupServiceFound = false;
            for (JniorBackup jniorBackup : JNIOR_BACKUP_SERVICES_COLLECTION) {
                if (!ipAddress.equals(jniorBackup.getHost())) continue;
                backupServiceFound = true;
            }
            if (!backupServiceFound) {
                JniorBackup jniorBackup = new JniorBackup(jniorInfo);
                long lastBackupTime = BackupServicesConfig.getLastBackupTimeForJnior(jniorInfo.getSerialNumber());
                long nextBackupTime = 0L;
                if (0L != lastBackupTime) {
                    double intervalInHours = BackupServicesConfig.getBackupIntervalInHours();
                    nextBackupTime = (long)((double)lastBackupTime + 3600000.0 * intervalInHours);
                }
                jniorBackup.setNextBackupTime(nextBackupTime);
                jniorBackup.setRecursive();
                JNIOR_BACKUP_SERVICES_COLLECTION.add(jniorBackup);
                Object object = BackupServiceEngine.INSTANCE.WAIT_LOCK;
                synchronized (object) {
                    BackupServiceEngine.INSTANCE.WAIT_LOCK.notifyAll();
                }
            }
        }
    }

    public static void backupJniorNow(JniorInfo jniorInfo) {
        JniorBackup jniorBackup = BackupServiceEngine.findJniorBackupFor(jniorInfo);
        if (null == jniorBackup) {
            BackupServiceEngine.addJnior(jniorInfo);
        }
        jniorBackup.setNextBackupTime(System.currentTimeMillis());
        LOGGER.info("interrupting the service engine to process " + jniorBackup.getHost());
        BackupServiceEngine.INSTANCE._userRequestedInterrupt = true;
        BackupServiceEngine.INSTANCE._thread.interrupt();
    }

    private static JniorBackup findJniorBackupFor(JniorInfo jniorInfo) {
        for (JniorBackup jniorBackup : JNIOR_BACKUP_SERVICES_COLLECTION) {
            if (!jniorInfo.IpAddress.equals(jniorBackup.getHost())) continue;
            return jniorBackup;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configChanged() {
        Object object = BackupServiceEngine.INSTANCE.WAIT_LOCK;
        synchronized (object) {
            BackupServiceEngine.INSTANCE.WAIT_LOCK.notifyAll();
        }
    }

    private BackupServiceEngine() {
    }

    public JniorBackup getCurrentJniorBackup() {
        return this._currentJniorBackup;
    }

    @Override
    public void unitUpdated(final JniorInfo jniorInfo) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                int series = jniorInfo.getSeries();
                if (4 == series) {
                    String[] excludedIpAddresses = BackupServicesConfig.getExcludesIpAddressArray();
                    for (int i = 0; i < excludedIpAddresses.length; ++i) {
                        String excludedIpAddress = excludedIpAddresses[i];
                        if (!jniorInfo.IpAddress.equals(excludedIpAddress)) continue;
                        LOGGER.info(String.format("excluding %s becuase the ip address is in the excluded ip list", jniorInfo.IpAddress));
                        return;
                    }
                    String[] excludedHostnames = BackupServicesConfig.getExcludesHostnameArray();
                    for (int i = 0; i < excludedHostnames.length; ++i) {
                        String excludedHostname = excludedHostnames[i];
                        if (!jniorInfo.Hostname.equals(excludedHostname)) continue;
                        LOGGER.info(String.format("excluding %s becuase the hostname is in the excluded hostname list", jniorInfo.Hostname));
                        return;
                    }
                    BackupServiceEngine.addJnior(jniorInfo);
                }
            }
        });
        thread.setName(this.getClass().getName());
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        BackupServiceEngine backupServiceEngine = this;
        synchronized (backupServiceEngine) {
            if (null == this._thread) {
                this._thread = new Thread(this);
                this._thread.setName(this.getClass().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String stacktrace;
        if (!BackupServicesConfig.isEnabled()) {
            LOGGER.info("Backup Service Engine is not enabled");
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ex) {
            stacktrace = ExceptionUtils.getStackTrace(ex);
            LOGGER.severe(stacktrace);
        }
        LOGGER.info("--- Start Backup Service Engine ---");
        while (true) {
            this._userRequestedInterrupt = false;
            if (BackupServicesConfig.isEnabled()) {
                this.performBackupServices();
            }
            try {
                if (null != this._nextJniorBackup && System.currentTimeMillis() < this._nextJniorBackup.getNextBackupTime()) {
                    long sleepDuration = this._nextJniorBackup.getNextBackupTime() - System.currentTimeMillis();
                    System.out.println("BackupService is sleeping for " + (double)sleepDuration / 1000.0 + " seconds");
                    Object object = BackupServiceEngine.INSTANCE.WAIT_LOCK;
                    synchronized (object) {
                        BackupServiceEngine.INSTANCE.WAIT_LOCK.wait(sleepDuration);
                        continue;
                    }
                }
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException ex) {
                if (this._userRequestedInterrupt) continue;
                stacktrace = ExceptionUtils.getStackTrace(ex);
                LOGGER.severe(stacktrace);
                continue;
            }
            catch (Exception ex) {
                stacktrace = ExceptionUtils.getStackTrace(ex);
                LOGGER.severe(stacktrace);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performBackupServices() {
        long now = System.currentTimeMillis();
        ArrayList<JniorBackup> arrayList = JNIOR_BACKUP_SERVICES_COLLECTION;
        synchronized (arrayList) {
            JNIOR_BACKUP_SERVICES_COLLECTION.sort(new Comparator<JniorBackup>(){

                @Override
                public int compare(JniorBackup jb1, JniorBackup jb2) {
                    if (jb1.getNextBackupTime() < jb2.getNextBackupTime()) {
                        return -1;
                    }
                    if (jb1.getNextBackupTime() > jb2.getNextBackupTime()) {
                        return 1;
                    }
                    return 0;
                }
            });
            LOGGER.info("");
            int pendingJniorCount = 0;
            for (JniorBackup jniorBackup : JNIOR_BACKUP_SERVICES_COLLECTION) {
                if (System.currentTimeMillis() < jniorBackup.getNextBackupTime()) continue;
                LOGGER.info(String.format("%s should have been backed up at %s", jniorBackup.getHost(), new Date(jniorBackup.getNextBackupTime())));
                ++pendingJniorCount;
            }
            LOGGER.info(String.format("%d JNIORs waiting to be backed up", pendingJniorCount));
            LOGGER.info("");
        }
        if (0 != JNIOR_BACKUP_SERVICES_COLLECTION.size()) {
            JniorBackup jniorBackup = JNIOR_BACKUP_SERVICES_COLLECTION.get(0);
            long nextBackupTime = jniorBackup.getNextBackupTime();
            if (null == this._nextJniorBackup || this._nextJniorBackup.getNextBackupTime() > nextBackupTime) {
                this._nextJniorBackup = jniorBackup;
            }
            if (now >= nextBackupTime) {
                try {
                    this._nextJniorBackup = null;
                    this._currentJniorBackup = jniorBackup;
                    for (BackupServiceListener listener : this._listeners) {
                        listener.jniorBackupStarted(new EventObject(this));
                    }
                    jniorBackup.run();
                    this._currentJniorBackup = null;
                    for (BackupServiceListener listener : this._listeners) {
                        listener.jniorBackupEnded(new EventObject(this));
                    }
                    int n = jniorBackup.getSerialNumber();
                    double intervalInHours = BackupServicesConfig.getBackupIntervalInHours();
                    nextBackupTime = (long)((double)now + 3600000.0 * intervalInHours);
                    jniorBackup.setNextBackupTime(nextBackupTime);
                    BackupServicesConfig.setLastBackupTimeForJnior(n, now);
                }
                catch (Exception exception) {
                    String stacktrace = ExceptionUtils.getStackTrace(exception);
                    LOGGER.severe(stacktrace);
                }
            }
        }
    }
}

