/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui.dialogs;

import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.supporter.RollingLog;
import com.integ.supporter.SelectedJniorItem;
import com.integ.supporter.beacon.comparators.IpAddressComparator;
import com.integ.supporter.helpers.IP4Validator;
import com.integ.supporter.ui.TableHeaderRenderer;
import com.integ.supporter.ui.dialogs.IPAddressFormattedTextField;
import com.integ.supporter.ui.dialogs.JniorSelectionTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class JniorSelectionDialog
extends JDialog {
    private static final Logger LOGGER = RollingLog.getLogger("JniorSelectionDialog");
    private final DefaultListSelectionModel _myListSelectionModel = new DefaultListSelectionModel();
    private final ArrayList<JniorInfo> _selectedJniorList = new ArrayList();
    private JniorSelectionTableModel _tableModel;
    private JTable _table;
    private TableRowSorter _sorter;
    private JButton btnCancel;
    private JButton btnOk;
    private IPAddressFormattedTextField ipManuallyEntered;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;

    public JniorSelectionDialog(Frame parent) {
        this(parent, new JniorSelectionTableModel());
    }

    public JniorSelectionDialog(Frame parent, boolean modal) {
        this(parent, new JniorSelectionTableModel());
    }

    public JniorSelectionDialog(Frame parent, JniorSelectionTableModel tableModel) {
        super(parent, true);
        this.initComponents();
        this.setTitle("Select JNIORs");
        this.addTable(tableModel);
        this.pack();
        this.setMinimumSize(new Dimension(800, 600));
    }

    private void addTable(JniorSelectionTableModel tableModel) {
        this._tableModel = tableModel;
        this._table = new JTable(this._tableModel){

            @Override
            public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
                if (0 == columnIndex) {
                    return;
                }
                super.changeSelection(rowIndex, columnIndex, toggle, extend);
            }
        };
        this._table.setSelectionMode(2);
        this._table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this._table.getTableHeader().setReorderingAllowed(false);
        this._table.setFillsViewportHeight(true);
        this._tableModel.addTableModelListener(e -> this.checkForSelectedJnior());
        JTableHeader header = this._table.getTableHeader();
        header.setDefaultRenderer(new TableHeaderRenderer(this._table));
        this._table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer());
        this._table.setRowHeight(24);
        this._table.setShowVerticalLines(false);
        this._table.setShowHorizontalLines(false);
        TableColumnModel columnModel = this._table.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            int width = tableModel.getColumnWidth(i);
            columnModel.getColumn(i).setPreferredWidth(width);
        }
        this._table.setAutoResizeMode(0);
        this._sorter = new TableRowSorter<TableModel>(this._table.getModel());
        this._sorter.setComparator(4, new IpAddressComparator());
        this._table.setRowSorter(this._sorter);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(4, SortOrder.ASCENDING));
        this._sorter.setSortKeys(sortKeys);
        this._table.setSelectionModel(this._myListSelectionModel);
        this.addMouseListener();
        this.jScrollPane1.setViewportView(this._table);
    }

    private void checkForSelectedJnior() {
        boolean jniorSelected;
        boolean selectedJniorFound = false;
        for (int rowIndex = 0; !selectedJniorFound && rowIndex < this._table.getRowCount(); selectedJniorFound |= jniorSelected, ++rowIndex) {
            jniorSelected = (Boolean)this._table.getValueAt(rowIndex, 0);
        }
        try {
            String manuallyEnteredIPAddress = this.ipManuallyEntered.getText();
            selectedJniorFound |= IP4Validator.isValid(manuallyEnteredIPAddress);
        }
        catch (Exception ex) {
            RuntimeException rex = new RuntimeException("Error getting manually entered IP Address", ex);
            String stacktrace = ExceptionUtils.getStackTrace(rex);
            Logger.getLogger(JniorSelectionDialog.class.getName()).severe(stacktrace);
        }
        this.btnOk.setEnabled(selectedJniorFound);
    }

    public void addRowSorter(int column, Comparator comparator) {
        this._sorter.setComparator(column, comparator);
    }

    public void setSelectionType(int selectionType) {
        this._table.setSelectionMode(selectionType);
    }

    public JniorInfo[] getSelectedJniors() {
        return this._selectedJniorList.toArray(new JniorInfo[this._selectedJniorList.size()]);
    }

    public String getManuallyEneteredIPAddress() {
        return this.ipManuallyEntered.getText();
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel2 = new JPanel();
        this.ipManuallyEntered = new IPAddressFormattedTextField();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel3.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel3.add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.jPanel3, "Center");
        this.jPanel2.setLayout(new FlowLayout(2));
        this.ipManuallyEntered.setText("0.0.0.0");
        this.ipManuallyEntered.setMinimumSize(new Dimension(96, 20));
        this.ipManuallyEntered.setPreferredSize(new Dimension(96, 20));
        this.ipManuallyEntered.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                JniorSelectionDialog.this.ipManuallyEnteredKeyReleased(evt);
            }
        });
        this.jPanel2.add(this.ipManuallyEntered);
        this.btnOk.setText("OK");
        this.btnOk.setEnabled(false);
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JniorSelectionDialog.this.btnOkActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnOk);
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JniorSelectionDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnCancel);
        this.getContentPane().add((Component)this.jPanel2, "Last");
        this.jPanel1.setLayout(new FlowLayout(0));
        this.jLabel1.setText("Use the checkboxes to select one or more JNIORs.  You can select multiple rows in the table\nbefore ticking the checkbox to select multiple JNIORs at once.");
        this.jLabel1.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
        this.jLabel1.setVerticalTextPosition(1);
        this.jPanel1.add(this.jLabel1);
        this.getContentPane().add((Component)this.jPanel1, "First");
        this.pack();
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        SelectedJniorItem[] jniors;
        for (SelectedJniorItem selectedJniorItem : jniors = this._tableModel.getJniors()) {
            if (!selectedJniorItem.Selected) continue;
            this._selectedJniorList.add(selectedJniorItem.getJniorInfo());
        }
        this.setVisible(false);
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void ipManuallyEnteredKeyReleased(KeyEvent evt) {
        if ('\n' == evt.getKeyChar()) {
            this.setVisible(false);
        } else {
            this.checkForSelectedJnior();
        }
    }

    private void addMouseListener() {
        this._table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                System.out.println("me = " + me);
            }

            @Override
            public void mouseClicked(MouseEvent me) {
                int clickedViewRow = JniorSelectionDialog.this._table.rowAtPoint(me.getPoint());
                int clickedViewColumn = JniorSelectionDialog.this._table.columnAtPoint(me.getPoint());
                if (0 == clickedViewColumn) {
                    ListSelectionModel listSelectionModel = JniorSelectionDialog.this._table.getSelectionModel();
                    if (0 == listSelectionModel.getSelectionMode()) {
                        for (int rowIndex = 0; rowIndex < JniorSelectionDialog.this._table.getRowCount(); ++rowIndex) {
                            if (rowIndex == clickedViewRow) continue;
                            JniorSelectionDialog.this._table.setValueAt(false, rowIndex, 0);
                        }
                    } else {
                        int[] selectedRows = JniorSelectionDialog.this._table.getSelectedRows();
                        boolean previouslySelected = false;
                        int[] nArray = selectedRows;
                        int n = nArray.length;
                        for (int i = 0; i < n; ++i) {
                            int rowIndex = nArray[i];
                            if (rowIndex != clickedViewRow) continue;
                            previouslySelected = true;
                            break;
                        }
                        if (!previouslySelected) {
                            JniorSelectionDialog.this._table.setRowSelectionInterval(clickedViewRow, clickedViewRow);
                        }
                    }
                    boolean selected = (Boolean)JniorSelectionDialog.this._table.getValueAt(clickedViewRow, 0);
                    System.out.println("selected = " + selected);
                    for (int selectedRowIndex : listSelectionModel.getSelectedIndices()) {
                        JniorSelectionDialog.this._table.setValueAt(selected, selectedRowIndex, 0);
                    }
                } else if (1 < me.getClickCount()) {
                    boolean selected = (Boolean)JniorSelectionDialog.this._table.getValueAt(clickedViewRow, 0);
                    JniorSelectionDialog.this._table.setValueAt(!selected, clickedViewRow, 0);
                }
            }
        });
    }

    public void hideSeries3() {
        this._tableModel.hideSeries3();
    }
}

