/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.snapshot;

import com.formdev.flatlaf.ui.FlatTabbedPaneUI;
import com.integ.janoslib.net.beacon.BeaconListener;
import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.janoslib.utils.FileUtils;
import com.integ.janoslib.utils.ZipUtils;
import com.integ.supporter.CollectionModifiedEvent;
import com.integ.supporter.Constants;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.RollingLog;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.beacon.comparators.DateStringComparator;
import com.integ.supporter.config.ApplicationConfig;
import com.integ.supporter.config.JniorsSavedStates;
import com.integ.supporter.helpers.IP4Validator;
import com.integ.supporter.snapshot.DefaultMutableTreeNode2;
import com.integ.supporter.snapshot.JniorSnapshotTab;
import com.integ.supporter.snapshot.Snapshot;
import com.integ.supporter.snapshot.SnapshotAnalysisPanel;
import com.integ.supporter.snapshot.SnapshotFileCollection;
import com.integ.supporter.snapshot.SnapshotInProgressCollection;
import com.integ.supporter.snapshot.SnapshotJniorSelectionTableModel;
import com.integ.supporter.snapshot.SnapshotListener;
import com.integ.supporter.snapshot.SnapshotNeededAlertDialog;
import com.integ.supporter.snapshot.SnapshotProgressCollection;
import com.integ.supporter.snapshot.SnapshotResult;
import com.integ.supporter.snapshot.SnapshotTreeModel;
import com.integ.supporter.snapshot.ZipEntryNode;
import com.integ.supporter.snapshot.ZipFileNode;
import com.integ.supporter.snapshot.library.SnapshotLibrary;
import com.integ.supporter.snapshot.library.SnapshotLibraryEvent;
import com.integ.supporter.snapshot.library.SnapshotLibraryListener;
import com.integ.supporter.snapshot.menus.SnapshotPopupMenu;
import com.integ.supporter.snapshot.menus.SnapshotTabsPopupMenu;
import com.integ.supporter.snapshot.menus.SnapshotTreePopupMenu;
import com.integ.supporter.ui.CollectionModifiedAdapter;
import com.integ.supporter.ui.PercentageTabbedPaneUI;
import com.integ.supporter.ui.dialogs.JniorSelectionDialog;
import com.integ.supporter.ui.dialogs.LoginDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class SnapshotTab
extends JPanel
implements Runnable,
BeaconListener,
SnapshotListener {
    protected static final int ICON_SIZE = 12;
    private static final float SCALE = 0.0234375f;
    public static final Logger LOGGER = RollingLog.getLogger("SnapshotTab");
    private static final SnapshotTab Instance = new SnapshotTab();
    private final SnapshotLibrary _snapshotLibrary;
    private boolean snapshotNeededAlertDialogShown = false;
    private SnapshotTreeModel _treeModel;
    private DefaultMutableTreeNode2 _rootNode;
    private JButton abortAllButton;
    private JButton abortToolbarButton;
    private JButton clearCompletedButton;
    private JSplitPane horizontalSplitPane;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JToolBar jToolBar1;
    private JTree jTree1;
    private JButton openSnapshotDirectory;
    private JTabbedPane snapshotsTabPane;
    private JButton takeSnapshotToolbarButton;

    public static SnapshotTab getInstance() {
        return Instance;
    }

    private SnapshotTab() {
        this.initComponents();
        this.installClosableTabbedPaneUI();
        this.abortToolbarButton.setVisible(false);
        this._snapshotLibrary = new SnapshotLibrary(Constants.SNAPSHOTS_FOLDER);
        this._snapshotLibrary.addEventListener(new SnapshotLibraryListener(){

            @Override
            public void fileLoaded(SnapshotLibraryEvent snapshotLibraryEvent) {
                SnapshotFileCollection.add(snapshotLibraryEvent.getSnapshotFile());
                int count = SnapshotFileCollection.getCount();
                System.out.println("SnapshotFileCollection count = " + count);
            }

            @Override
            public void libraryLoaded(SnapshotLibraryEvent snapshotLibraryEvent) {
                SnapshotTab.this._treeModel.refresh();
                ArrayList snapshotFiles = SnapshotFileCollection.getCollection();
                ArrayList snapshotFiles2 = (ArrayList)snapshotFiles.clone();
            }
        });
        this.snapshotsTabPane.setComponentPopupMenu(new SnapshotTabsPopupMenu());
        this.snapshotsTabPane.setUI(new PercentageTabbedPaneUI());
        this.addTabChangeListener();
        this.addTreeMouseListener();
        this.snapshotsTabPane.addChangeListener(e -> this.updateMenuStatus());
        this.setDropTarget(new DropTarget(){

            @Override
            public synchronized void drop(DropTargetDropEvent evt) {
                try {
                    evt.acceptDrop(1);
                    System.out.println("evt = " + evt);
                    Transferable transferable = evt.getTransferable();
                    List droppedFiles = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    for (File file : droppedFiles) {
                        SnapshotTab.this.doSnapshotAnalysis(file);
                        SnapshotTab.this._snapshotLibrary.addSnapshotFile(file);
                        SnapshotTab.this._treeModel.refresh();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport info) {
                return info.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport info) {
                ArrayList data;
                if (!info.isDrop()) {
                    return false;
                }
                if (!info.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    this.displayDropLocation("List doesn't accept a drop of this type.");
                    return false;
                }
                Transferable t = info.getTransferable();
                try {
                    data = (ArrayList)t.getTransferData(DataFlavor.javaFileListFlavor);
                }
                catch (Exception e) {
                    return false;
                }
                for (Object file : data) {
                    System.out.println("file = " + file);
                }
                return true;
            }

            private void displayDropLocation(String string) {
                System.out.println(string);
            }
        });
        this.addCollectionListener();
        new Thread(this).start();
    }

    public JTabbedPane getTabbedPane() {
        return this.snapshotsTabPane;
    }

    private void installClosableTabbedPaneUI() {
        FlatTabbedPaneUI flatTabbedPaneUI = new FlatTabbedPaneUI();
        this.snapshotsTabPane.setUI(flatTabbedPaneUI);
        this.snapshotsTabPane.putClientProperty("JTabbedPane.tabClosable", true);
        this.snapshotsTabPane.putClientProperty("JTabbedPane.tabCloseToolTipText", "Close");
        this.snapshotsTabPane.putClientProperty("JTabbedPane.tabCloseCallback", (tabPane, tabIndex) -> {
            Component tabComponent = tabPane.getComponentAt((int)tabIndex);
            if (tabComponent instanceof JniorSnapshotTab) {
                JniorSnapshotTab jniorSnapshotTab = (JniorSnapshotTab)tabComponent;
                Snapshot snapshot = jniorSnapshotTab.getSnapshot();
                if (!snapshot.isComplete()) {
                    int result = JOptionPane.showConfirmDialog(this, "Are you sure you want to abort the snapshot for " + snapshot.getTitle(), "Are you sure?", 0);
                    if (1 == result) {
                        return;
                    }
                    snapshot.abort();
                }
                this.snapshotsTabPane.remove((int)tabIndex);
            } else {
                this.snapshotsTabPane.remove((int)tabIndex);
            }
            this.clearCompletedButton.setEnabled(0 < this.snapshotsTabPane.getTabCount());
        });
    }

    private void doSnapshotAnalysis(File file) {
        if (-1 == this.findTabByName(file.getName())) {
            SnapshotAnalysisPanel snapshotAnalysisPanel = new SnapshotAnalysisPanel(file);
            snapshotAnalysisPanel.doAnalysis();
            String name = file.getName();
            this.snapshotsTabPane.insertTab(name, null, snapshotAnalysisPanel, name, 0);
            this.snapshotsTabPane.setSelectedComponent(snapshotAnalysisPanel);
        }
    }

    public int findTabByName(String title) {
        int tabCount = this.snapshotsTabPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            String tabTitle = this.snapshotsTabPane.getTitleAt(i);
            if (!tabTitle.equals(title)) continue;
            return i;
        }
        return -1;
    }

    private void addTabChangeListener() {
        this.snapshotsTabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component selectedComponent = SnapshotTab.this.snapshotsTabPane.getSelectedComponent();
                if (null != selectedComponent && SnapshotTab.this.snapshotsTabPane.getSelectedComponent() instanceof JniorSnapshotTab) {
                    JniorSnapshotTab jniorSnapshotTab = (JniorSnapshotTab)selectedComponent;
                    SnapshotTab.this.abortToolbarButton.setEnabled(!jniorSnapshotTab.isComplete());
                }
            }
        });
    }

    private void addTreeMouseListener() {
        this.jTree1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int selectedRow = SnapshotTab.this.jTree1.getRowForLocation(e.getX(), e.getY());
                TreePath selelectedPath = SnapshotTab.this.jTree1.getPathForLocation(e.getX(), e.getY());
                if (null != selelectedPath) {
                    DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)selelectedPath.getLastPathComponent();
                    if (-1 != selectedRow) {
                        ZipFileNode zipFileNode;
                        File file;
                        if (2 == e.getClickCount()) {
                            try {
                                if (!(treeNode instanceof ZipFileNode) && treeNode instanceof ZipEntryNode && treeNode.isLeaf()) {
                                    ZipEntryNode contentNode = (ZipEntryNode)treeNode;
                                    byte[] contents = contentNode.getContents();
                                    String tempFileName = String.format("%s%s", Constants.TEMP_DIRECTORY, contentNode.toString());
                                    FileUtils.writeAllBytes(tempFileName, contents);
                                    Desktop desktop = Desktop.getDesktop();
                                    desktop.open(new File(tempFileName));
                                }
                            }
                            catch (Exception ex) {
                                Logger.getLogger(SnapshotPopupMenu.class.getName()).severe(ExceptionUtils.getStackTrace(ex));
                            }
                        } else if (treeNode instanceof ZipFileNode && (file = (zipFileNode = (ZipFileNode)treeNode).getFile()).exists()) {
                            String name = file.getName();
                            int tabCount = SnapshotTab.this.snapshotsTabPane.getTabCount();
                            for (int i = 0; i < tabCount; ++i) {
                                String tabTitle = SnapshotTab.this.snapshotsTabPane.getTitleAt(i);
                                if (!tabTitle.equals(name)) continue;
                                SnapshotTab.this.snapshotsTabPane.setSelectedIndex(i);
                                return;
                            }
                            JTextPane textPane = new JTextPane();
                            JScrollPane scrollPane = new JScrollPane();
                            scrollPane.setViewportView(textPane);
                            textPane.setCaretPosition(0);
                            SnapshotTab.this.snapshotsTabPane.insertTab(name, null, scrollPane, name, 0);
                            SnapshotTab.this.snapshotsTabPane.setSelectedComponent(scrollPane);
                            try {
                                byte[] snapshotDotLogBytes = ZipUtils.extractEntry(file.getPath(), "_snapshot.log");
                                String snapshotDotLog = new String(snapshotDotLogBytes);
                                snapshotDotLog = snapshotDotLog.replace("\r\n", "\n");
                                textPane.setText(snapshotDotLog);
                                textPane.setCaretPosition(0);
                            }
                            catch (IOException ex) {
                                Logger.getLogger(SnapshotTab.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                }
            }
        });
    }

    private void updateMenuStatus() {
        JniorSnapshotTab jniorSnapshotTab = this.getSelectedSnapshotTab();
        if (null != jniorSnapshotTab) {
            boolean isRunning = !jniorSnapshotTab.isComplete();
            this.abortToolbarButton.setEnabled(isRunning);
        }
    }

    @Override
    public void run() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        SnapshotTab snapshotTab = this;
        synchronized (snapshotTab) {
            try {
                File fileRoot = new File(Constants.SNAPSHOTS_FOLDER);
                this._rootNode = new DefaultMutableTreeNode2(new FileNode(fileRoot, true));
                this._treeModel = new SnapshotTreeModel(this._rootNode, this._snapshotLibrary);
                this.jTree1.setModel(this._treeModel);
                this.jTree1.setShowsRootHandles(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void loginFailed() {
    }

    @Override
    public void downloadFileAttempt(int index, int total, String remoteFileName) {
    }

    @Override
    public void downloadFileResult(int index, int total, String remoteFileName, boolean result) {
    }

    @Override
    public void snapshotResult(Snapshot snapshot, SnapshotResult result) {
        JniorSnapshotTab selectedSnapshotTab = this.getSelectedSnapshotTab();
        if (null != selectedSnapshotTab) {
            File snapshotZipFile;
            this.abortToolbarButton.setEnabled(!selectedSnapshotTab.isComplete());
            if (SnapshotResult.Success == result && null != (snapshotZipFile = snapshot.getZipFile())) {
                this._snapshotLibrary.addSnapshotFile(snapshotZipFile);
                this._treeModel.refresh();
            }
            this.updateTitle();
        }
    }

    @Override
    public void unitUpdated(JniorInfo jniorInfo) {
        System.out.println(String.format("%s has been announced, the last snapshot was taken: %s", jniorInfo.getSerialNumber(), new Date()));
    }

    public void startSnapshot(JniorInfo jniorInfo) {
        LOGGER.info(String.format("current thread: %s", Thread.currentThread().getName()));
        JniorSnapshotTab jniorSnapshotTab = new JniorSnapshotTab(jniorInfo);
        jniorSnapshotTab.setSnapshotListener(this);
        long lastSnapshotTime = JniorsSavedStates.getLastSnapshotTime(jniorInfo.getSerialNumber());
        long elapsedTime = System.currentTimeMillis() - lastSnapshotTime;
        int elapsedMinutes = (int)(elapsedTime / 60000L);
        if (SnapshotInProgressCollection.startSnapshot(jniorInfo, jniorSnapshotTab)) {
            this.snapshotsTabPane.insertTab("Snapshot - " + jniorInfo.IpAddress, null, jniorSnapshotTab, "Taking a snapshot of " + jniorInfo.IpAddress, 0);
            int index = this.snapshotsTabPane.indexOfComponent(jniorSnapshotTab);
            this.snapshotsTabPane.setSelectedComponent(jniorSnapshotTab);
            jniorSnapshotTab.start();
            this.updateTitle();
        }
        this.updateMenuStatus();
    }

    public void updateTitle() {
        String title = "Snapshot";
        int count = SnapshotInProgressCollection.getInProgressCount();
        if (0 < count) {
            title = String.format("Snapshot (%d)", count);
        }
    }

    public JniorSnapshotTab getSelectedSnapshotTab() {
        JniorSnapshotTab selectedTabbedPane = null;
        Component selectedComponent = this.snapshotsTabPane.getSelectedComponent();
        if (null != selectedComponent && this.snapshotsTabPane.getSelectedComponent() instanceof JniorSnapshotTab) {
            selectedTabbedPane = (JniorSnapshotTab)this.snapshotsTabPane.getSelectedComponent();
        }
        return selectedTabbedPane;
    }

    public void removeCompleted() {
        try {
            SnapshotProgressCollection.getInstance().removeCompleted();
            int completedCount = SnapshotProgressCollection.getInstance().getCompletedCount();
            this.clearCompletedButton.setEnabled(0 < completedCount);
        }
        catch (Exception ex) {
            NotificationCollection.addError("Error removing completed snapshots", ex);
        }
    }

    public void shouldShowSnapshotNeededNotification() {
        if (System.currentTimeMillis() >= ApplicationConfig.getNextSnapshotAlertTime() && !this.snapshotNeededAlertDialogShown) {
            this.snapshotNeededAlertDialogShown = true;
            SnapshotNeededAlertDialog dialog = new SnapshotNeededAlertDialog(null, true);
            dialog.setVisible(true);
        }
    }

    private void addCollectionListener() {
        SnapshotProgressCollection.getInstance().addChangeListener(e -> {
            int completedCount = SnapshotProgressCollection.getInstance().getCompletedCount();
            this.clearCompletedButton.setEnabled(0 < completedCount);
            boolean isActive = 0 < SnapshotProgressCollection.getInstance().getActiveCount();
            this.abortAllButton.setEnabled(isActive);
        });
        SnapshotProgressCollection.getInstance().addCollectionListener(new CollectionModifiedAdapter(){

            @Override
            public void itemRemoved(CollectionModifiedEvent e, Object item) {
                int tabIndex;
                Snapshot snapshot = (Snapshot)item;
                if (snapshot.isComplete() && -1 != (tabIndex = this.getTabIndexForSnaphot(snapshot))) {
                    SnapshotTab.this.snapshotsTabPane.removeTabAt(tabIndex);
                }
            }

            private int getTabIndexForSnaphot(Snapshot snapshot) {
                for (int i = 0; i < SnapshotTab.this.snapshotsTabPane.getTabCount(); ++i) {
                    JniorSnapshotTab jniorSnapshotTab;
                    Component tabComponent = SnapshotTab.this.snapshotsTabPane.getComponentAt(i);
                    if (!(tabComponent instanceof JniorSnapshotTab) || snapshot != (jniorSnapshotTab = (JniorSnapshotTab)tabComponent).getSnapshot()) continue;
                    return i;
                }
                return -1;
            }
        });
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.takeSnapshotToolbarButton = new JButton();
        this.abortToolbarButton = new JButton();
        this.openSnapshotDirectory = new JButton();
        this.clearCompletedButton = new JButton();
        this.abortAllButton = new JButton();
        this.horizontalSplitPane = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.snapshotsTabPane = new JTabbedPane();
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jToolBar1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jToolBar1.setRollover(true);
        this.takeSnapshotToolbarButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/disk.png")));
        this.takeSnapshotToolbarButton.setText("Take Snapshot");
        this.takeSnapshotToolbarButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.takeSnapshotToolbarButton.setFocusable(false);
        this.takeSnapshotToolbarButton.setVerticalTextPosition(3);
        this.takeSnapshotToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SnapshotTab.this.takeSnapshotToolbarButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.takeSnapshotToolbarButton);
        this.abortToolbarButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/stop.png")));
        this.abortToolbarButton.setText("Abort All");
        this.abortToolbarButton.setToolTipText("Close");
        this.abortToolbarButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.abortToolbarButton.setEnabled(false);
        this.abortToolbarButton.setFocusable(false);
        this.abortToolbarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SnapshotTab.this.abortToolbarButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.abortToolbarButton);
        this.openSnapshotDirectory.setIcon(new ImageIcon(this.getClass().getResource("/resources/drive.png")));
        this.openSnapshotDirectory.setText("Open Snapshots Directory");
        this.openSnapshotDirectory.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.openSnapshotDirectory.setFocusable(false);
        this.openSnapshotDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SnapshotTab.this.openSnapshotDirectoryActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.openSnapshotDirectory);
        this.clearCompletedButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/table_delete.png")));
        this.clearCompletedButton.setText("Clear Completed");
        this.clearCompletedButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.clearCompletedButton.setEnabled(false);
        this.clearCompletedButton.setFocusable(false);
        this.clearCompletedButton.setHorizontalTextPosition(4);
        this.clearCompletedButton.setVerticalTextPosition(3);
        this.clearCompletedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SnapshotTab.this.clearCompletedButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.clearCompletedButton);
        this.abortAllButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/stop.png")));
        this.abortAllButton.setText("Abort All");
        this.abortAllButton.setEnabled(false);
        this.abortAllButton.setFocusable(false);
        this.abortAllButton.setVerticalTextPosition(3);
        this.abortAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SnapshotTab.this.abortAllButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.abortAllButton);
        this.jPanel1.add((Component)this.jToolBar1, "Center");
        this.add((Component)this.jPanel1, "First");
        this.jScrollPane1.setMinimumSize(new Dimension(250, 16));
        this.jTree1.setMinimumSize(new Dimension(200, 0));
        this.jTree1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SnapshotTab.this.jTree1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTree1);
        this.horizontalSplitPane.setLeftComponent(this.jScrollPane1);
        this.snapshotsTabPane.setTabPlacement(4);
        this.horizontalSplitPane.setRightComponent(this.snapshotsTabPane);
        this.add((Component)this.horizontalSplitPane, "Center");
    }

    private void abortToolbarButtonActionPerformed(ActionEvent evt) {
        JniorSnapshotTab selectedSnapshot = this.getSelectedSnapshotTab();
        if (null != selectedSnapshot) {
            selectedSnapshot.abort();
        }
    }

    private void takeSnapshotToolbarButtonActionPerformed(ActionEvent evt) {
        JniorInfo[] selectedJniors;
        JniorSelectionDialog dlg = new JniorSelectionDialog((Frame)SupporterMain.getMainFrame(), new SnapshotJniorSelectionTableModel());
        dlg.addRowSorter(6, new DateStringComparator());
        dlg.setMinimumSize(new Dimension(1200, 600));
        dlg.setLocationRelativeTo(this);
        dlg.setVisible(true);
        for (JniorInfo selectedRemoteJniorInfo : selectedJniors = dlg.getSelectedJniors()) {
            this.startSnapshot(selectedRemoteJniorInfo);
        }
        String manuallyEnteredIPAddress = dlg.getManuallyEneteredIPAddress();
        if (IP4Validator.isValid(manuallyEnteredIPAddress)) {
            LoginDialog loginDialog = new LoginDialog((Frame)SupporterMain.getMainFrame(), true);
            loginDialog.setDescription("Snapshot for " + manuallyEnteredIPAddress + " needs credentials");
            loginDialog.centerParent();
            loginDialog.setVisible(true);
            if (loginDialog.getResult() == 1) {
                JniorInfo jniorInfo = new JniorInfo(0);
                jniorInfo.IpAddress = manuallyEnteredIPAddress;
                jniorInfo.Username = loginDialog.getUsername();
                jniorInfo.Password = loginDialog.getPassword();
                this.startSnapshot(jniorInfo);
            }
        }
    }

    private void openSnapshotDirectoryActionPerformed(ActionEvent evt) {
        File directoryToOpen = new File(Constants.SNAPSHOTS_FOLDER);
        try {
            Desktop desktop = Desktop.getDesktop();
            desktop.open(directoryToOpen);
        }
        catch (IOException | IllegalArgumentException ex) {
            NotificationCollection.addNotification(String.format("Unable to open the %s directory", directoryToOpen.getPath()), 4);
            Logger.getLogger(SnapshotPopupMenu.class.getName()).severe(ExceptionUtils.getStackTrace(ex));
        }
    }

    private void clearCompletedButtonActionPerformed(ActionEvent evt) {
        this.removeCompleted();
    }

    private void jTree1MouseClicked(MouseEvent evt) {
        if (3 == evt.getButton()) {
            JTree tree = (JTree)evt.getSource();
            TreePath treePath = tree.getPathForLocation(evt.getX(), evt.getY());
            tree.setSelectionPath(treePath);
            Object lastSelectedPathComponent = tree.getLastSelectedPathComponent();
            if (lastSelectedPathComponent instanceof ZipFileNode) {
                SnapshotTreePopupMenu popupMenu = new SnapshotTreePopupMenu();
                popupMenu.show(tree, evt.getX(), evt.getY());
            }
        }
    }

    private void abortAllButtonActionPerformed(ActionEvent evt) {
        int result = JOptionPane.showConfirmDialog(this, "Are you sure you want to abort all snapshots", "Are you sure?", 0);
        if (1 == result) {
            return;
        }
        for (int i = 0; i < this.snapshotsTabPane.getTabCount(); ++i) {
            JniorSnapshotTab jniorSnapshotTab = (JniorSnapshotTab)this.snapshotsTabPane.getComponentAt(i);
            Snapshot snapshot = jniorSnapshotTab.getSnapshot();
            if (snapshot.isComplete()) continue;
            snapshot.abort();
        }
    }

    public class FileNode {
        private File file;
        private boolean showFullPath = false;

        public FileNode(File file) {
            this.file = file;
        }

        public FileNode(File file, boolean showFullPath) {
            this.file = file;
            this.showFullPath = showFullPath;
        }

        public String toString() {
            String name = this.file.getName();
            if (name.equals("") || this.showFullPath) {
                return this.file.getAbsolutePath();
            }
            return name;
        }
    }
}

