/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.cinema;

import com.integ.janoslib.utils.FileUtils;
import com.integ.janoslib.utils.PathUtils;
import com.integ.janoslib.utils.ResourceUtils;
import com.integ.janoslib.utils.StringUtils;
import com.integ.supporter.Constants;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.cinema.MacroAction;
import com.integ.supporter.cinema.MacroActionNode;
import com.integ.supporter.cinema.MacroNode;
import com.integ.supporter.cinema.MacroPane;
import com.integ.supporter.cinema.devices.CinemaDevice;
import com.integ.supporter.cinema.devices.CinemaDeviceFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MacroFile {
    private String _macroFilePath;
    private ArrayList<MacroAction> _macroActionsList = new ArrayList();

    public MacroFile(String macroFilePath) {
        this._macroFilePath = macroFilePath;
    }

    public File getMacroFile() {
        File macroFile = new File(this._macroFilePath);
        return macroFile;
    }

    public void setMacroFilePath(String newFilePath) {
        this._macroFilePath = newFilePath;
    }

    public MacroAction[] getMacroActions() {
        return this._macroActionsList.toArray(new MacroAction[this._macroActionsList.size()]);
    }

    public void load() {
        if (null == this._macroFilePath) {
            try {
                File tempTemplateFile = new File(PathUtils.combine(Constants.TEMP_DIRECTORY, "template_macro.csv"));
                ResourceUtils.extractResource("/resources/template_macro.csv", tempTemplateFile);
                this._macroFilePath = tempTemplateFile.getPath();
            }
            catch (IOException ex) {
                Logger.getLogger(MacroPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        try {
            String macroFileContents = FileUtils.readAllText(this._macroFilePath);
            boolean loadMacroActionDescriptions = false;
            boolean loadMacros = false;
            String[] lines = StringUtils.split(macroFileContents, "\n");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                System.out.println("line = " + line);
                String[] fields = StringUtils.split(line, ",");
                if (0 == fields.length) continue;
                if ("".equals(fields[0])) {
                    loadMacroActionDescriptions = true;
                } else if ("macro name".equalsIgnoreCase(fields[0])) {
                    loadMacroActionDescriptions = false;
                    loadMacros = true;
                    continue;
                }
                if (!loadMacros) {
                    for (int j = 1; j < fields.length; ++j) {
                        String field = fields[j].trim();
                        if (j >= this._macroActionsList.size()) {
                            this._macroActionsList.add(new MacroAction(""));
                        }
                        MacroAction macroAction = this._macroActionsList.get(j - 1);
                        if ("device".equalsIgnoreCase(fields[0])) {
                            CinemaDevice cinemaDevice = CinemaDeviceFactory.getCinemaDevice(field);
                            cinemaDevice.setName(field);
                            macroAction.setDevice(cinemaDevice);
                            if (null == macroAction.getDeviceName()) {
                                macroAction.setDeviceName(field);
                            }
                        } else if ("action".equalsIgnoreCase(fields[0])) {
                            macroAction.setAction(field);
                        } else if ("data".equalsIgnoreCase(fields[0])) {
                            macroAction.setData(field);
                        }
                        if (!loadMacroActionDescriptions) continue;
                        if (!"description".equalsIgnoreCase(fields[0])) {
                            if (null == macroAction || "".equals(field)) continue;
                            macroAction.setName(macroAction.getName() + " " + field);
                            continue;
                        }
                        macroAction.setName(macroAction.getName() + " " + field);
                        if (j + 1 != fields.length) continue;
                        loadMacroActionDescriptions = false;
                    }
                }
                if (!loadMacros) continue;
                MacroNode macroNode = new MacroNode(fields[0].trim());
                for (int j = 1; j < fields.length; ++j) {
                    String field = fields[j].trim();
                    if (0 == field.length()) continue;
                    MacroAction macroAction = this._macroActionsList.get(j - 1);
                    MacroActionNode macroActionNode = new MacroActionNode(macroAction, Integer.parseInt(field));
                    macroNode.addMacroAction(macroActionNode);
                }
            }
        }
        catch (Exception ex) {
            NotificationCollection.addError("Error reading macro file: " + this._macroFilePath, ex);
        }
    }

    public void save() {
        System.out.println("");
    }
}

