/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.cinema;

import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.janoslib.utils.FileUtils;
import com.integ.janoslib.utils.PathUtils;
import com.integ.janoslib.utils.ResourceUtils;
import com.integ.janoslib.utils.StringUtils;
import com.integ.janoslib.utils.ThreadUtils;
import com.integ.supporter.Constants;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.cinema.CinemaFilePublisher;
import com.integ.supporter.cinema.Device;
import com.integ.supporter.cinema.DevicesPane;
import com.integ.supporter.cinema.RemoteCinemaFileOpener;
import com.integ.supporter.cinema.devices.CinemaDevice;
import com.integ.supporter.cinema.devices.CinemaDeviceFactory;
import com.integ.supporter.cinema.devices.InternalInputDevice;
import com.integ.supporter.cinema.devices.InternalOutputDevice;
import com.integ.supporter.cinema.editors.DataCellEditor;
import com.integ.supporter.cinema.editors.DeviceActionCellEditor;
import com.integ.supporter.cinema.editors.DeviceCellEditor;
import com.integ.supporter.cinema.models.MacroAction;
import com.integ.supporter.cinema.models.MacroActionModel;
import com.integ.supporter.cinema.models.MacroActionNode;
import com.integ.supporter.cinema.models.MacroNode;
import com.integ.supporter.cinema.models.MacroTreeTableModel;
import com.integ.supporter.cinema.renderers.ActionDataCellRenderer;
import com.integ.supporter.jrget.DescendingDateFileChooser;
import com.integ.supporter.ui.celleditors.TimingCellEditor;
import com.integ.supporter.ui.dialogs.JniorSelectionDialog;
import com.integ.supporter.ui.jtreetable.JTreeTable;
import com.integ.supporter.ui.toasts.InProgressMessageToast;
import com.integ.supporter.ui.toasts.MessageToast;
import com.integ.supporter.ui.toasts.ToastNotifications;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.TreePath;

public class MacroPane
extends JPanel {
    private final MacroTreeTableModel _macroTreeTableModel = new MacroTreeTableModel("Macros");
    private final JTreeTable _macroTreeTable;
    private final LinkedHashMap<String, CinemaDevice> _knownDevices = new LinkedHashMap();
    private String _macroFilePath;
    private String _macroFileName;
    private boolean _isExternalDeviceFound = false;
    private final MacroActionModel _macroActionTableModel = new MacroActionModel(this._knownDevices);
    private final DeviceCellEditor _externalDeviceCellEditor = new DeviceCellEditor(this._knownDevices);
    private final DeviceActionCellEditor _deviceActionCellEditor = new DeviceActionCellEditor(this._macroActionTableModel, this._knownDevices);
    private final DataCellEditor _dataColumnCellEditor = new DataCellEditor();
    private boolean _macroFileSaved = false;
    private TreePath _selectedTreePath = null;
    private final HashMap<Integer, MacroNode> _savedMacroHashMap = new HashMap();
    private final HashMap<Integer, MacroAction> _savedMacroActionHashMap = new HashMap();
    private JButton addActionButton;
    private JButton addMacroButton;
    private JButton addMinuteButton;
    private JButton addSecondButton;
    private JButton assignActionToMacroButton;
    private JPanel controlsPanel;
    private Box.Filler filler1;
    private Box.Filler filler10;
    private Box.Filler filler11;
    private Box.Filler filler2;
    private Box.Filler filler4;
    private Box.Filler filler5;
    private Box.Filler filler6;
    private Box.Filler filler7;
    private Box.Filler filler8;
    private Box.Filler filler9;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JToolBar jToolBar1;
    private JPanel leftPanel;
    private JButton linkDevicesButton;
    private JLabel linkedDevicesFilePathLabel;
    private JTable macroActionTable;
    private JPanel macroPanel;
    private JButton moveMacroActionDownButton;
    private JButton moveMacroActionUpButton;
    private JButton moveMacroDownButton;
    private JButton moveMacroUpButton;
    private JButton publishButton;
    private JButton removeActionButton;
    private JButton removeActionFromMacroButton;
    private JButton removeMacroButton;
    private JPanel rightPanel;
    private JButton saveAsButton;
    private JButton saveButton;
    private JButton subtractMinuteButton;
    private JButton subtractSecondButton;

    public MacroPane(String macroFilePath) {
        this.initComponents();
        this.loadInternalDevices();
        this.loadMacroFile(macroFilePath);
        this._macroTreeTable = new JTreeTable(this._macroTreeTableModel);
        this._macroTreeTable.setShowRoot(false);
        this._macroTreeTable.setRowSelectionAllowed(true);
        this._macroTreeTable.getTableHeader().setReorderingAllowed(false);
        this._macroTreeTable.getSelectionModel().setSelectionMode(0);
        DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)this._macroTreeTable.getTableHeader().getDefaultRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(2);
        DefaultTableCellRenderer centerAlignRenderer = new DefaultTableCellRenderer();
        centerAlignRenderer.setHorizontalAlignment(0);
        this._macroTreeTable.getColumnModel().getColumn(1).setCellRenderer(centerAlignRenderer);
        this._macroTreeTable.getColumnModel().getColumn(0).setPreferredWidth(250);
        this._macroTreeTable.getColumnModel().getColumn(1).setPreferredWidth(75);
        this._macroTreeTable.getColumnModel().getColumn(2).setPreferredWidth(400);
        this._macroTreeTable.setAutoResizeMode(0);
        this._macroTreeTable.getColumnModel().getColumn(1).setCellEditor(new TimingCellEditor());
        this._macroTreeTable.addPropertyChangeListener(evt -> {
            if ("tableCellEditor".equals(evt.getPropertyName())) {
                System.out.println("evt.getPropertyName() = " + evt.getPropertyName());
                boolean isEditing = this._macroTreeTable.isEditing();
                this.addMacroButton.setEnabled(!isEditing);
                if (isEditing) {
                    this.removeMacroButton.setEnabled(!isEditing);
                    this.moveMacroUpButton.setEnabled(!isEditing);
                    this.moveMacroDownButton.setEnabled(!isEditing);
                } else {
                    this.saveButton.setEnabled(true);
                }
            }
        });
        this._macroTreeTable.addTableSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                int selectedIndex = this._macroTreeTable.getSelectedRow();
                this._selectedTreePath = this._macroTreeTable.getSelectionPath();
                this.assignActionToMacroButton.setEnabled(-1 != selectedIndex && 0 < this.macroActionTable.getSelectedRowCount());
                this.removeActionFromMacroButton.setEnabled(false);
                this.removeMacroButton.setEnabled(-1 != selectedIndex);
                if (-1 != selectedIndex) {
                    TreePath treePath = this._macroTreeTable.getTree().getPathForRow(selectedIndex);
                    Object node = treePath.getLastPathComponent();
                    MacroNode selectedMacroNode = this.getSelectedMacroNode(treePath);
                    boolean isMacroNode = node instanceof MacroNode;
                    this.moveMacroUpButton.setEnabled(isMacroNode && 0 < selectedIndex);
                    int macroNodeRow = this._macroTreeTableModel.getRowForMacroNode(selectedMacroNode);
                    boolean isLast = macroNodeRow == this._macroTreeTableModel.getMacroNodes().size() - 1;
                    this.moveMacroDownButton.setEnabled(isMacroNode && !isLast);
                    if (node instanceof MacroNode) {
                        MacroNode macroNode = (MacroNode)node;
                    }
                    boolean isMacroActionNode = node instanceof MacroActionNode;
                    this.addMinuteButton.setEnabled(isMacroActionNode);
                    this.addSecondButton.setEnabled(isMacroActionNode);
                    this.subtractSecondButton.setEnabled(isMacroActionNode);
                    this.subtractMinuteButton.setEnabled(isMacroActionNode);
                    if (node instanceof MacroActionNode) {
                        MacroActionNode macroActionNode = (MacroActionNode)node;
                        MacroAction macroAction = macroActionNode.getMacroAction();
                        int index = this._macroActionTableModel.getRowForMacroAction(macroAction);
                        this.macroActionTable.setRowSelectionInterval(index, index);
                        this.checkTimingForMacroActionNode(macroActionNode);
                        this.removeActionFromMacroButton.setEnabled(true);
                    }
                } else {
                    this.macroActionTable.clearSelection();
                    this.moveMacroUpButton.setEnabled(false);
                    this.moveMacroDownButton.setEnabled(false);
                    this.addMinuteButton.setEnabled(false);
                    this.addSecondButton.setEnabled(false);
                    this.subtractSecondButton.setEnabled(false);
                    this.subtractMinuteButton.setEnabled(false);
                }
            }
        });
        this.macroActionTable.setModel(this._macroActionTableModel);
        defaultTableCellRenderer = (DefaultTableCellRenderer)this.macroActionTable.getTableHeader().getDefaultRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(2);
        this.macroActionTable.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.macroActionTable.getColumnModel().getColumn(1).setPreferredWidth(125);
        this.macroActionTable.getColumnModel().getColumn(2).setPreferredWidth(125);
        this.macroActionTable.getColumnModel().getColumn(3).setPreferredWidth(400);
        this.macroActionTable.setAutoResizeMode(0);
        this.setDataColumnRenderer();
        this.macroActionTable.addPropertyChangeListener(evt -> {
            if ("tableCellEditor".equals(evt.getPropertyName())) {
                System.out.println("evt.getPropertyName() = " + evt.getPropertyName());
                boolean isEditing = this.macroActionTable.isEditing();
                if (isEditing) {
                    this.removeActionButton.setEnabled(!isEditing);
                    this.moveMacroActionUpButton.setEnabled(!isEditing);
                    this.moveMacroActionDownButton.setEnabled(!isEditing);
                }
            }
        });
        this.macroActionTable.getColumnModel().getColumn(1).setCellEditor(this._externalDeviceCellEditor);
        this.macroActionTable.getColumnModel().getColumn(2).setCellEditor(this._deviceActionCellEditor);
        this.macroActionTable.getColumnModel().getColumn(3).setCellEditor(this._dataColumnCellEditor);
        this.macroActionTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                int selectedIndex = this.macroActionTable.getSelectedRow();
                this.assignActionToMacroButton.setEnabled(-1 != selectedIndex && 0 < this._macroTreeTable.getSelectedRowCount());
                this.removeActionButton.setEnabled(!this.macroActionTable.isEditing() && -1 != selectedIndex);
                this.moveMacroActionUpButton.setEnabled(-1 != selectedIndex && 0 < selectedIndex);
                this.moveMacroActionDownButton.setEnabled(-1 != selectedIndex && this.macroActionTable.getRowCount() > selectedIndex + 1);
            }
        });
        this._macroTreeTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        JScrollPane macroScrollPane = new JScrollPane(this._macroTreeTable);
        macroScrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MacroPane.this._macroTreeTable.isEditing()) {
                    MacroPane.this._macroTreeTable.getCellEditor().stopCellEditing();
                }
            }
        });
        this.macroPanel.add((Component)macroScrollPane, "Center");
        this._macroTreeTableModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                MacroPane.this._macroTreeTable.repaint();
                MacroPane.this.updateSaveButton();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                MacroPane.this._macroTreeTable.repaint();
                MacroPane.this.updateSaveButton();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                MacroPane.this._macroTreeTable.repaint();
                MacroPane.this.updateSaveButton();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                SwingUtilities.invokeLater(() -> MacroPane.this._macroTreeTable.repaint());
                MacroPane.this.updateSaveButton();
            }
        });
        this._macroActionTableModel.addTableModelListener(e -> this.updateSaveButton());
        if (this._isExternalDeviceFound) {
            this.linkDeviceFile();
        }
        this.jScrollPane1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MacroPane.this.macroActionTable.isEditing()) {
                    MacroPane.this.macroActionTable.getCellEditor().stopCellEditing();
                }
            }
        });
    }

    private JniorInfo[] getSelectedJniors() {
        JniorSelectionDialog jniorSelectionDialog = new JniorSelectionDialog((Frame)SupporterMain.getMainFrame(), true);
        jniorSelectionDialog.setSelectionType(0);
        jniorSelectionDialog.setVisible(true);
        JniorInfo[] selectedJniors = jniorSelectionDialog.getSelectedJniors();
        return selectedJniors;
    }

    private MacroNode getSelectedMacroNode(TreePath treePath) {
        if (null == treePath) {
            return null;
        }
        if (treePath.getLastPathComponent() instanceof MacroActionNode) {
            treePath = treePath.getParentPath();
        }
        return (MacroNode)treePath.getLastPathComponent();
    }

    @Override
    public final String getName() {
        if (null == this._macroFilePath) {
            return this._macroFileName;
        }
        return new File(this._macroFilePath).getName();
    }

    /*
     * WARNING - void declaration
     */
    private void loadMacroFile(String macroFilePath) {
        this._isExternalDeviceFound = false;
        if (null == macroFilePath) {
            try {
                File tempTemplateFile = new File(PathUtils.combine(Constants.TEMP_DIRECTORY, "template_macro.csv"));
                ResourceUtils.extractResource("/resources/template_macro.csv", tempTemplateFile);
                macroFilePath = tempTemplateFile.getPath();
                this.saveButton.setEnabled(false);
            }
            catch (IOException ex) {
                Logger.getLogger(MacroPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            Path path = Paths.get(Constants.TEMP_DIRECTORY, new String[0]);
            if (!macroFilePath.startsWith(path.toString())) {
                this._macroFilePath = macroFilePath;
            } else {
                this._macroFileName = new File(macroFilePath).getName();
            }
        }
        try {
            this._macroTreeTableModel.clear();
            String macroFileContents = FileUtils.readAllText(macroFilePath);
            MacroAction[] actionsArray = null;
            boolean loadMacroActionDescriptions = false;
            boolean loadMacros = false;
            String[] lines = StringUtils.split(macroFileContents, "\n");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                System.out.println("line = " + line);
                String[] fields = StringUtils.split(line, ",");
                if (0 == fields.length) continue;
                if ("".equals(fields[0])) {
                    loadMacroActionDescriptions = true;
                    if (null == actionsArray) {
                        actionsArray = new MacroAction[fields.length - 1];
                    }
                } else if ("macro name".equalsIgnoreCase(fields[0])) {
                    loadMacroActionDescriptions = false;
                    loadMacros = true;
                    continue;
                }
                if (!loadMacros) {
                    void var10_16;
                    boolean bl = true;
                    while (var10_16 < fields.length) {
                        String field = fields[var10_16].trim();
                        if ("device".equalsIgnoreCase(fields[0])) {
                            try {
                                CinemaDevice cinemaDevice = CinemaDeviceFactory.getCinemaDevice(field);
                                cinemaDevice.setName(field);
                                actionsArray[var10_16 - true].setDevice(cinemaDevice);
                                actionsArray[var10_16 - true].setDeviceName(field);
                                if (!this._knownDevices.containsKey(field)) {
                                    this._knownDevices.put(field, cinemaDevice);
                                }
                                if (!(cinemaDevice instanceof InternalInputDevice) && !(cinemaDevice instanceof InternalOutputDevice)) {
                                    this._isExternalDeviceFound = true;
                                }
                            }
                            catch (Exception ex) {
                                actionsArray[var10_16 - true].setDeviceName(field);
                                this._isExternalDeviceFound = true;
                            }
                        } else if ("action".equalsIgnoreCase(fields[0])) {
                            actionsArray[var10_16 - true].setAction(field);
                        } else if ("data".equalsIgnoreCase(fields[0])) {
                            actionsArray[var10_16 - true].setData(field);
                        }
                        if (loadMacroActionDescriptions) {
                            if (!"description".equalsIgnoreCase(fields[0])) {
                                if (null == actionsArray[var10_16 - true]) {
                                    actionsArray[var10_16 - true] = new MacroAction(field);
                                } else if (!"".equals(field)) {
                                    actionsArray[var10_16 - true].setName(actionsArray[var10_16 - true].getName() + " " + field);
                                }
                            } else {
                                if (!field.startsWith("(")) {
                                    actionsArray[var10_16 - true].setName(actionsArray[var10_16 - true].getName() + " " + field);
                                }
                                if (var10_16 + true == fields.length) {
                                    loadMacroActionDescriptions = false;
                                }
                            }
                        }
                        ++var10_16;
                    }
                }
                if (!loadMacros) continue;
                MacroNode macroNode = new MacroNode(fields[0].trim());
                for (int j = 1; j < fields.length; ++j) {
                    String field = fields[j].trim();
                    if (0 == field.length()) continue;
                    MacroAction macroAction = actionsArray[j - 1];
                    MacroActionNode macroActionNode = new MacroActionNode(macroAction, Integer.parseInt(field));
                    macroNode.addMacroAction(macroActionNode);
                    this.addPropertyChangeListenerForMacroActionNode(macroActionNode);
                }
                this.addMacroNode(macroNode);
            }
            if (null != actionsArray) {
                for (void var10_18 : actionsArray) {
                    this._savedMacroActionHashMap.put(var10_18.hashCode(), var10_18.clone());
                    this.addPropertyChangeListenerForMacroAction((MacroAction)var10_18);
                }
            }
            this._macroActionTableModel.setMacroActions(actionsArray);
        }
        catch (Exception ex) {
            NotificationCollection.addError("Error reading macro file: " + macroFilePath, ex);
        }
    }

    private void addMacroNode(MacroNode newMacroNode) {
        newMacroNode.addPropertyChangeListener(evt2 -> this.updateSaveButton());
        this._macroTreeTableModel.addMacroNode(newMacroNode);
        this._savedMacroHashMap.put(newMacroNode.hashCode(), newMacroNode.clone());
    }

    private void addPropertyChangeListenerForMacroActionNode(MacroActionNode macroActionNode) {
        macroActionNode.addPropertyChangeListener(evt2 -> this.updateSaveButton());
    }

    private void addPropertyChangeListenerForMacroAction(MacroAction macroAction) {
        macroAction.addPropertyChangeListener(evt2 -> this.updateSaveButton());
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.saveButton = new JButton();
        this.saveAsButton = new JButton();
        this.publishButton = new JButton();
        this.linkDevicesButton = new JButton();
        this.filler1 = new Box.Filler(new Dimension(12, 0), new Dimension(12, 0), new Dimension(12, Short.MAX_VALUE));
        this.linkedDevicesFilePathLabel = new JLabel();
        this.jSplitPane1 = new JSplitPane();
        this.leftPanel = new JPanel();
        this.controlsPanel = new JPanel();
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.addMinuteButton = new JButton();
        this.addSecondButton = new JButton();
        this.subtractSecondButton = new JButton();
        this.subtractMinuteButton = new JButton();
        this.filler4 = new Box.Filler(new Dimension(0, 25), new Dimension(0, 25), new Dimension(Short.MAX_VALUE, 25));
        this.jLabel2 = new JLabel();
        this.assignActionToMacroButton = new JButton();
        this.removeActionFromMacroButton = new JButton();
        this.filler5 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.macroPanel = new JPanel();
        this.jPanel5 = new JPanel();
        this.addMacroButton = new JButton();
        this.filler9 = new Box.Filler(new Dimension(5, 0), new Dimension(5, 0), new Dimension(5, Short.MAX_VALUE));
        this.removeMacroButton = new JButton();
        this.filler10 = new Box.Filler(new Dimension(10, 0), new Dimension(10, 0), new Dimension(Short.MAX_VALUE, 0));
        this.moveMacroUpButton = new JButton();
        this.filler11 = new Box.Filler(new Dimension(5, 0), new Dimension(5, 0), new Dimension(5, Short.MAX_VALUE));
        this.moveMacroDownButton = new JButton();
        this.rightPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.macroActionTable = new JTable();
        this.jPanel3 = new JPanel();
        this.addActionButton = new JButton();
        this.filler7 = new Box.Filler(new Dimension(5, 0), new Dimension(5, 0), new Dimension(5, Short.MAX_VALUE));
        this.removeActionButton = new JButton();
        this.filler6 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.moveMacroActionUpButton = new JButton();
        this.filler8 = new Box.Filler(new Dimension(5, 0), new Dimension(5, 0), new Dimension(5, Short.MAX_VALUE));
        this.moveMacroActionDownButton = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(0, 8, 8, 8));
        this.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new GridLayout(1, 0));
        this.jPanel4.setLayout(new FlowLayout(0, 0, 3));
        this.jToolBar1.setRollover(true);
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/disk.png")));
        this.saveButton.setText("Save");
        this.saveButton.setEnabled(false);
        this.saveButton.setFocusable(false);
        this.saveButton.setHorizontalTextPosition(4);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MacroPane.this.saveButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.saveButton);
        this.saveAsButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/disk_multiple.png")));
        this.saveAsButton.setText("Save As...");
        this.saveAsButton.setFocusable(false);
        this.saveAsButton.setVerticalTextPosition(3);
        this.saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MacroPane.this.saveAsButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.saveAsButton);
        this.publishButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/application_go.png")));
        this.publishButton.setText("Publish");
        this.publishButton.setFocusable(false);
        this.publishButton.setVerticalTextPosition(3);
        this.publishButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MacroPane.this.publishButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.publishButton);
        this.linkDevicesButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/link.png")));
        this.linkDevicesButton.setText("Link Devices File");
        this.linkDevicesButton.setFocusable(false);
        this.linkDevicesButton.setVerticalTextPosition(3);
        this.linkDevicesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MacroPane.this.linkDevicesButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.linkDevicesButton);
        this.jToolBar1.add(this.filler1);
        this.linkedDevicesFilePathLabel.setText("There is not a linked file");
        this.jToolBar1.add(this.linkedDevicesFilePathLabel);
        this.jPanel4.add(this.jToolBar1);
        this.jPanel2.add(this.jPanel4);
        this.add((Component)this.jPanel2, "North");
        this.leftPanel.setMinimumSize(new Dimension(300, 0));
        this.leftPanel.setName("");
        this.leftPanel.setLayout(new BorderLayout());
        this.controlsPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.controlsPanel.setLayout(new GridLayout(0, 1));
        this.controlsPanel.add(this.filler2);
        this.jPanel1.setLayout(new GridLayout(0, 1));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Timing");
        this.jPanel1.add(this.jLabel1);
        this.addMinuteButton.setText("+ Min");
        this.addMinuteButton.setEnabled(false);
        this.addMinuteButton.setMargin(new Insets(2, 4, 3, 4));
        this.addMinuteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MacroPane.this.addMinuteButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.addMinuteButton);
        this.addSecondButton.setText("+ Sec");
        this.addSecondButton.setEnabled(false);
        this.addSecondButton.setMargin(new Insets(2, 4, 3, 4));
        this.addSecondButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MacroPane.this.addSecondButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.addSecondButton);
        this.subtractSecondButton.setText("- Sec");
        this.subtractSecondButton.setEnabled(false);
        this.subtractSecondButton.setMargin(new Insets(2, 4, 3, 4));
        this.subtractSecondButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MacroPane.this.subtractSecondButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.subtractSecondButton);
        this.subtractMinuteButton.setText("- Min");
        this.subtractMinuteButton.setEnabled(false);
        this.subtractMinuteButton.setMargin(new Insets(2, 4, 3, 4));
        this.subtractMinuteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MacroPane.this.subtractMinuteButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.subtractMinuteButton);
        this.jPanel1.add(this.filler4);
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("Assign");
        this.jPanel1.add(this.jLabel2);
        this.assignActionToMacroButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/arrow_left.png")));
        this.assignActionToMacroButton.setEnabled(false);
        this.assignActionToMacroButton.setMargin(new Insets(2, 4, 3, 4));
        this.assignActionToMacroButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MacroPane.this.assignActionToMacroButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.assignActionToMacroButton);
        this.removeActionFromMacroButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/delete.png")));
        this.removeActionFromMacroButton.setEnabled(false);
        this.removeActionFromMacroButton.setMargin(new Insets(2, 4, 3, 4));
        this.removeActionFromMacroButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MacroPane.this.removeActionFromMacroButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.removeActionFromMacroButton);
        this.controlsPanel.add(this.jPanel1);
        this.controlsPanel.add(this.filler5);
        this.leftPanel.add((Component)this.controlsPanel, "East");
        this.macroPanel.setLayout(new BorderLayout());
        this.jPanel5.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel5.setLayout(new BoxLayout(this.jPanel5, 2));
        this.addMacroButton.setText("Add Macro");
        this.addMacroButton.setHorizontalTextPosition(0);
        this.addMacroButton.setVerticalTextPosition(3);
        this.addMacroButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MacroPane.this.addMacroButtonActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.addMacroButton);
        this.jPanel5.add(this.filler9);
        this.removeMacroButton.setText("Remove Macro");
        this.removeMacroButton.setEnabled(false);
        this.removeMacroButton.setHorizontalTextPosition(0);
        this.removeMacroButton.setVerticalTextPosition(3);
        this.removeMacroButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MacroPane.this.removeMacroButtonActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.removeMacroButton);
        this.jPanel5.add(this.filler10);
        this.moveMacroUpButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/arrow_up.png")));
        this.moveMacroUpButton.setEnabled(false);
        this.moveMacroUpButton.setMargin(new Insets(2, 4, 3, 4));
        this.moveMacroUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MacroPane.this.moveMacroUpButtonActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.moveMacroUpButton);
        this.jPanel5.add(this.filler11);
        this.moveMacroDownButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/arrow_down.png")));
        this.moveMacroDownButton.setEnabled(false);
        this.moveMacroDownButton.setMargin(new Insets(2, 4, 3, 4));
        this.moveMacroDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MacroPane.this.moveMacroDownButtonActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.moveMacroDownButton);
        this.macroPanel.add((Component)this.jPanel5, "Last");
        this.leftPanel.add((Component)this.macroPanel, "Center");
        this.jSplitPane1.setLeftComponent(this.leftPanel);
        this.rightPanel.setLayout(new BorderLayout());
        this.macroActionTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.macroActionTable.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.macroActionTable);
        this.rightPanel.add((Component)this.jScrollPane1, "Center");
        this.jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 2));
        this.addActionButton.setText("Add Action");
        this.addActionButton.setHorizontalTextPosition(0);
        this.addActionButton.setVerticalTextPosition(3);
        this.addActionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MacroPane.this.addActionButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.addActionButton);
        this.jPanel3.add(this.filler7);
        this.removeActionButton.setText("Remove Action");
        this.removeActionButton.setEnabled(false);
        this.removeActionButton.setHorizontalTextPosition(0);
        this.removeActionButton.setVerticalTextPosition(3);
        this.removeActionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MacroPane.this.removeActionButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.removeActionButton);
        this.jPanel3.add(this.filler6);
        this.moveMacroActionUpButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/arrow_up.png")));
        this.moveMacroActionUpButton.setEnabled(false);
        this.moveMacroActionUpButton.setHorizontalTextPosition(0);
        this.moveMacroActionUpButton.setMargin(new Insets(2, 4, 3, 4));
        this.moveMacroActionUpButton.setVerticalTextPosition(3);
        this.moveMacroActionUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MacroPane.this.moveMacroActionUpButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.moveMacroActionUpButton);
        this.jPanel3.add(this.filler8);
        this.moveMacroActionDownButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/arrow_down.png")));
        this.moveMacroActionDownButton.setEnabled(false);
        this.moveMacroActionDownButton.setHorizontalTextPosition(0);
        this.moveMacroActionDownButton.setMargin(new Insets(2, 4, 3, 4));
        this.moveMacroActionDownButton.setVerticalTextPosition(3);
        this.moveMacroActionDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MacroPane.this.moveMacroActionDownButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.moveMacroActionDownButton);
        this.rightPanel.add((Component)this.jPanel3, "Last");
        this.jSplitPane1.setRightComponent(this.rightPanel);
        this.add((Component)this.jSplitPane1, "Center");
    }

    private void addMacroButtonActionPerformed(ActionEvent evt) {
        String newMacroName = this.getMacroName();
        if ("".equals(newMacroName)) {
            return;
        }
        MacroNode newMacroNode = new MacroNode(newMacroName);
        this.addMacroNode(newMacroNode);
        this._macroTreeTable.updateUI();
    }

    private String getMacroName() {
        int index = 1;
        while (true) {
            String newMacroName = "New Macro " + index;
            boolean isUsed = false;
            for (MacroNode macroNode : this._macroTreeTableModel.getMacroNodes()) {
                if (!macroNode.getName().equalsIgnoreCase(newMacroName)) continue;
                isUsed = true;
                break;
            }
            if (!isUsed) {
                return newMacroName;
            }
            ++index;
        }
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        boolean macroFileChanged = false;
        this._macroFileSaved = false;
        if (null != this._macroFilePath) {
            try {
                File macroFile = new File(this._macroFilePath);
                String tempMacroFilePath = String.format("%s/%s", SupporterMain.getTempDirectory(), macroFile.getName());
                this.saveMacroFile(tempMacroFilePath);
                String tempMd5 = FileUtils.getFileMd5(tempMacroFilePath);
                String loadedMacroFileMd5 = FileUtils.getFileMd5(this._macroFilePath);
                if (!tempMd5.equalsIgnoreCase(loadedMacroFileMd5)) {
                    FileUtils.copyfile(new File(tempMacroFilePath), 0, macroFile, 0);
                    macroFileChanged = true;
                }
                this._macroFileSaved = true;
                this.saveButton.setEnabled(false);
            }
            catch (IOException | NoSuchAlgorithmException ex) {
                Logger.getLogger(DevicesPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            this.saveAsButtonActionPerformed(evt);
        }
        if (macroFileChanged) {
            MessageToast messageToast = new MessageToast(this.getName() + " saved!");
            messageToast.setMessageType(4);
            ToastNotifications.getInstance().display(messageToast);
        }
    }

    private void saveAsButtonActionPerformed(ActionEvent evt) {
        String filePath = "macro_";
        if (null != this._macroFilePath) {
            filePath = this._macroFilePath;
        } else if (null != this._macroFileName) {
            filePath = this._macroFileName;
        }
        DescendingDateFileChooser fileChooser = new DescendingDateFileChooser();
        fileChooser.setCurrentDirectory(new File(Constants.CINEMA_FILES_FOLDER));
        fileChooser.setSelectedFile(new File(new File(filePath).getName()));
        fileChooser.removeChoosableFileFilter(fileChooser.getChoosableFileFilters()[0]);
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String name = file.getName();
                return file.getName().startsWith("macro_") && name.endsWith(".csv");
            }

            @Override
            public String getDescription() {
                return "Macro Files";
            }
        });
        if (fileChooser.showSaveDialog(this) == 0) {
            File file = fileChooser.getSelectedFile();
            if (!file.getName().toLowerCase().endsWith(".csv")) {
                file = new File(file.getPath() + ".csv");
            }
            if (!file.getName().toLowerCase().startsWith("macro_") || !file.getName().toLowerCase().endsWith(".csv")) {
                JOptionPane.showMessageDialog(null, "Invalid file name. Please follow the macro_*.csv file pattern");
            } else {
                this._macroFileSaved = this.saveMacroFile(file.getPath());
                if (this._macroFileSaved) {
                    String oldFilePath = this._macroFilePath;
                    this._macroFilePath = file.getPath();
                    if (null == oldFilePath || !oldFilePath.equals(this._macroFilePath)) {
                        super.firePropertyChange("title", oldFilePath, this._macroFilePath);
                    }
                }
            }
        }
    }

    private void moveMacroUpButtonActionPerformed(ActionEvent evt) {
        this.moveSelectedMacroNode(-1);
    }

    private void moveMacroDownButtonActionPerformed(ActionEvent evt) {
        this.moveSelectedMacroNode(1);
    }

    private void moveSelectedMacroNode(int direction) {
        int selectedIndex = this._macroTreeTable.getSelectedRow();
        if (-1 != selectedIndex) {
            JTree tree = this._macroTreeTable.getTree();
            TreePath treePath = tree.getPathForRow(selectedIndex);
            boolean isExpanded = tree.isExpanded(treePath);
            Object node = treePath.getLastPathComponent();
            MacroNode macroNode = (MacroNode)node;
            this._macroTreeTableModel.moveMacroNode(macroNode, direction);
            this._macroTreeTable.repaint();
            int newSelectedIndex = selectedIndex + direction;
            if (isExpanded) {
                tree.expandRow(newSelectedIndex);
            }
            this._macroTreeTable.setRowSelectionInterval(newSelectedIndex, newSelectedIndex);
        }
    }

    private void removeMacroButtonActionPerformed(ActionEvent evt) {
        int selectedRow = this._macroTreeTable.getSelectedRow();
        TreePath treePath = this._macroTreeTable.getTree().getPathForRow(selectedRow);
        MacroNode selectedMacroNode = this.getSelectedMacroNode(treePath);
        int confirmation = JOptionPane.showConfirmDialog(null, String.format("Are you sure you want to remove the '%s' macro?", selectedMacroNode.getName()), "Are you sure?", 0);
        if (0 == confirmation) {
            this._macroTreeTableModel.removeMacroNode(selectedMacroNode);
            this._macroTreeTable.repaint();
        }
        this._macroTreeTable.getSelectionModel().clearSelection();
        this.removeMacroButton.setEnabled(false);
        this.assignActionToMacroButton.setEnabled(false);
    }

    private void moveMacroActionUpButtonActionPerformed(ActionEvent evt) {
        if (this.macroActionTable.isEditing()) {
            this.macroActionTable.getCellEditor().cancelCellEditing();
        }
        int selectedRow = this.macroActionTable.getSelectedRow();
        this.moveSelectedMacroActionNode(-1);
        this.macroActionTable.setRowSelectionInterval(selectedRow - 1, selectedRow - 1);
    }

    private void moveMacroActionDownButtonActionPerformed(ActionEvent evt) {
        if (this.macroActionTable.isEditing()) {
            this.macroActionTable.getCellEditor().cancelCellEditing();
        }
        int selectedRow = this.macroActionTable.getSelectedRow();
        this.moveSelectedMacroActionNode(1);
        this.macroActionTable.setRowSelectionInterval(selectedRow + 1, selectedRow + 1);
    }

    private void moveSelectedMacroActionNode(int direction) {
        int selectedIndex = this.macroActionTable.getSelectedRow();
        if (-1 != selectedIndex) {
            MacroAction macroAction = this._macroActionTableModel.getMacroActionAtRow(selectedIndex);
            this._macroActionTableModel.moveMacroActionNode(macroAction, direction);
        }
    }

    private void adjustTiming(int seconds) {
        TreePath treePath = this._selectedTreePath;
        MacroActionNode macroActionNode = (MacroActionNode)this._selectedTreePath.getLastPathComponent();
        macroActionNode.setTiming(macroActionNode.getTimingSeconds() + seconds);
        MacroNode macroNode = this.getSelectedMacroNode(this._selectedTreePath);
        this._macroTreeTableModel.sort(macroNode);
        this._macroTreeTable.repaint();
        this.checkTimingForMacroActionNode(macroActionNode);
        this._macroTreeTable.getTree().expandPath(treePath.getParentPath());
        this._macroTreeTable.setSelectionPath(treePath);
    }

    private void addMinuteButtonActionPerformed(ActionEvent evt) {
        this.adjustTiming(60);
    }

    private void addSecondButtonActionPerformed(ActionEvent evt) {
        this.adjustTiming(1);
    }

    private void subtractSecondButtonActionPerformed(ActionEvent evt) {
        this.adjustTiming(-1);
    }

    private void subtractMinuteButtonActionPerformed(ActionEvent evt) {
        this.adjustTiming(-60);
    }

    private void assignActionToMacroButtonActionPerformed(ActionEvent evt) {
        try {
            int selectedMacroRow = this._macroTreeTable.getSelectedRow();
            TreePath treePath = this._macroTreeTable.getTree().getPathForRow(selectedMacroRow);
            MacroNode selectedMacroNode = this.getSelectedMacroNode(treePath);
            selectedMacroRow = this._macroTreeTableModel.getRowForMacroNode(selectedMacroNode);
            int selectedActionRow = this.macroActionTable.getSelectedRow();
            MacroAction selectedMacroAction = this._macroActionTableModel.getMacroActionAtRow(selectedActionRow);
            for (MacroActionNode macroActionNode : selectedMacroNode.getMacroActionNodes()) {
                if (!selectedMacroAction.equals(macroActionNode._macroAction)) continue;
                MacroAction newMacroAction = macroActionNode._macroAction.clone();
                this._macroActionTableModel.addMacroAction(newMacroAction);
                selectedMacroAction = newMacroAction;
                break;
            }
            MacroActionNode macroActionNode = new MacroActionNode(selectedMacroAction, 0);
            selectedMacroNode.addMacroAction(macroActionNode);
            this.addPropertyChangeListenerForMacroActionNode(macroActionNode);
            this._macroTreeTableModel.sort(selectedMacroNode);
            int macroNodeRowIndex = this._macroTreeTableModel.getRowForMacroNode(selectedMacroNode);
            int actionNodeIndex = selectedMacroNode.getMacroActionNodes().indexOf(macroActionNode);
            int macroActionNodeRowIndex = macroNodeRowIndex + actionNodeIndex;
            this._macroTreeTableModel.structureChanged();
            treePath = this._macroTreeTable.getTree().getPathForRow(selectedMacroRow);
            this._macroTreeTable.getTree().expandPath(treePath);
            this._macroTreeTable.repaint();
            this._macroTreeTable.setSelectionPath(treePath);
        }
        catch (Exception ex) {
            NotificationCollection.addError("Error assigning action to macro", ex);
        }
    }

    private void linkDevicesButtonActionPerformed(ActionEvent evt) {
        this.linkDeviceFile();
    }

    private void linkDeviceContents(String deviceFileContents) {
        String[] deviceFileLines = deviceFileContents.split("\n");
        this._knownDevices.clear();
        this.loadInternalDevices();
        boolean readDevices = false;
        for (String line : deviceFileLines) {
            String devicePort;
            String deviceIpAddress;
            String deviceType;
            String[] deviceLineParts = line.split(",");
            if (!readDevices) {
                if (!"device name".equalsIgnoreCase(deviceLineParts[0])) continue;
                readDevices = true;
                continue;
            }
            String deviceName = deviceLineParts[0].trim();
            Device device = new Device(deviceName, deviceType = deviceLineParts[1].trim(), deviceIpAddress = deviceLineParts[2].trim(), devicePort = deviceLineParts[3].trim());
            if (this._knownDevices.containsKey(device.getName())) continue;
            CinemaDevice cinemaDevice = CinemaDeviceFactory.getCinemaDevice(deviceType);
            cinemaDevice.setName(device.getName());
            this._knownDevices.put(device.getName(), cinemaDevice);
        }
        for (MacroAction macroAction : this._macroActionTableModel.getMacroActions()) {
            System.out.println("macroAction = " + macroAction);
            CinemaDevice cinemaDevice = this._knownDevices.get(macroAction.getDeviceName());
            macroAction.setDevice(cinemaDevice);
        }
    }

    private void publishButtonActionPerformed(ActionEvent evt) {
        JniorInfo jniorInfo;
        this.saveButtonActionPerformed(null);
        if (this._macroFileSaved && null != (jniorInfo = this.getSelectedJnior())) {
            String macroFilePath = this._macroFilePath;
            CinemaFilePublisher cinemaFilePublisher = new CinemaFilePublisher(jniorInfo, macroFilePath, "/");
            cinemaFilePublisher.setTitle("Remote Macro Publisher");
            cinemaFilePublisher.setFilenameFilter((dir, name) -> (name = name.toLowerCase()).startsWith("macro") && name.endsWith(".csv"));
            InProgressMessageToast inProgressMessageToast = new InProgressMessageToast(cinemaFilePublisher);
            ToastNotifications.getInstance().display(inProgressMessageToast);
            cinemaFilePublisher.start();
        }
    }

    private void removeActionFromMacroButtonActionPerformed(ActionEvent evt) {
        TreePath treePath = this._macroTreeTable.getSelectionPath();
        int selectedRow = this._macroTreeTable.getSelectedRow();
        if (treePath.getLastPathComponent() instanceof MacroActionNode) {
            MacroActionNode selectedMacroActionNode = (MacroActionNode)treePath.getLastPathComponent();
            System.out.println("selectedMacroActionNode = " + selectedMacroActionNode);
            MacroNode selectedMacroNode = (MacroNode)treePath.getParentPath().getLastPathComponent();
            this._macroTreeTableModel.removeActionFromMacros(selectedMacroActionNode.getMacroAction());
            this._macroTreeTable.expandPath(treePath.getParentPath());
            this._macroTreeTable.setRowSelectionInterval(selectedRow - 1, selectedRow - 1);
            this.removeActionButton.setEnabled(!selectedMacroNode.getMacroActionNodes().isEmpty());
        }
    }

    private void addActionButtonActionPerformed(ActionEvent evt) {
        MacroAction macroAction = new MacroAction("New Macro Action");
        this._macroActionTableModel.addMacroAction(macroAction);
        this.addPropertyChangeListenerForMacroAction(macroAction);
    }

    private void removeActionButtonActionPerformed(ActionEvent evt) {
        int selectedRow = this.macroActionTable.getSelectedRow();
        if (-1 != selectedRow) {
            MacroAction selectedMacroAction = this._macroActionTableModel.getMacroActionAtRow(selectedRow);
            int confirmation = JOptionPane.showConfirmDialog(null, String.format("Are you sure you want to remove the '%s' action?", selectedMacroAction.getName()), "Are you sure?", 0);
            if (0 == confirmation) {
                this._macroTreeTableModel.removeActionFromMacros(selectedMacroAction);
                this._macroActionTableModel.removeMacroAction(selectedMacroAction);
            }
        }
    }

    private JniorInfo getSelectedJnior() {
        JniorSelectionDialog jniorSelectionDialog = new JniorSelectionDialog((Frame)SupporterMain.getMainFrame(), true);
        jniorSelectionDialog.setVisible(true);
        if (0 < jniorSelectionDialog.getSelectedJniors().length) {
            return jniorSelectionDialog.getSelectedJniors()[0];
        }
        return null;
    }

    private File promptForDevicesFile() {
        try {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.removeChoosableFileFilter(fileChooser.getChoosableFileFilters()[0]);
            fileChooser.setCurrentDirectory(new File(Constants.CINEMA_FILES_FOLDER));
            fileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    String name = file.getName();
                    return file.getName().startsWith("devices_") && name.endsWith(".csv");
                }

                @Override
                public String getDescription() {
                    return "Device Files";
                }
            });
            int option = fileChooser.showOpenDialog(SupporterMain.getMainFrame());
            if (option == 0) {
                File file = fileChooser.getSelectedFile();
                return file;
            }
        }
        catch (Exception ex) {
            NotificationCollection.addError("Error prompting for device file", ex);
        }
        return null;
    }

    private void checkTimingForMacroActionNode(MacroActionNode macroActionNode) {
        this.subtractSecondButton.setEnabled(macroActionNode.getTimingSeconds() >= 1);
        this.subtractMinuteButton.setEnabled(macroActionNode.getTimingSeconds() >= 60);
    }

    private boolean saveMacroFile(String filepath) {
        File file = new File(filepath);
        if (file.exists()) {
            File bakFile = new File(file.getPath() + ".bak");
            if (bakFile.exists()) {
                bakFile.delete();
            }
            boolean renamed = file.renameTo(bakFile);
            System.out.println("renamed = " + renamed);
        }
        try {
            StringBuilder fileContentsBuilder = new StringBuilder();
            ArrayList<MacroAction> macroActionsList = this._macroActionTableModel.getMacroActions();
            StringBuilder sb = new StringBuilder("Revision");
            for (MacroAction macroAction : macroActionsList) {
                sb.append(",");
            }
            System.out.println(sb.toString());
            fileContentsBuilder.append((CharSequence)sb);
            fileContentsBuilder.append("\r\n");
            sb = new StringBuilder("Date");
            for (MacroAction macroAction : macroActionsList) {
                sb.append(",");
            }
            System.out.println(sb.toString());
            fileContentsBuilder.append((CharSequence)sb);
            fileContentsBuilder.append("\r\n");
            sb = new StringBuilder("Comment");
            for (MacroAction macroAction : macroActionsList) {
                sb.append(",");
            }
            System.out.println(sb.toString());
            fileContentsBuilder.append((CharSequence)sb);
            fileContentsBuilder.append("\r\n");
            ArrayList<String[]> splitMacroActionNames = new ArrayList<String[]>();
            int maxMacroNameSplitLength = 0;
            for (MacroAction macroAction : macroActionsList) {
                String[] splitMacroActionName = macroAction.getNameWithDeviceType().split(" ");
                splitMacroActionNames.add(splitMacroActionName);
                if (splitMacroActionName.length <= maxMacroNameSplitLength) continue;
                maxMacroNameSplitLength = splitMacroActionName.length;
            }
            for (int i = 0; i < maxMacroNameSplitLength; ++i) {
                sb = new StringBuilder();
                int j = maxMacroNameSplitLength - i;
                if (1 == j) {
                    sb.append("Description");
                }
                for (String[] splitMacroActionName : splitMacroActionNames) {
                    sb.append(",");
                    if (splitMacroActionName.length < j) continue;
                    sb.append(splitMacroActionName[splitMacroActionName.length - j]);
                }
                System.out.println(sb.toString());
                fileContentsBuilder.append((CharSequence)sb);
                fileContentsBuilder.append("\r\n");
            }
            sb = new StringBuilder("Device");
            for (MacroAction macroAction : macroActionsList) {
                sb.append(",");
                sb.append(macroAction.getDeviceName());
            }
            System.out.println(sb.toString());
            fileContentsBuilder.append((CharSequence)sb);
            fileContentsBuilder.append("\r\n");
            sb = new StringBuilder("Action");
            for (MacroAction macroAction : macroActionsList) {
                sb.append(",");
                sb.append(macroAction.getAction());
            }
            System.out.println(sb.toString());
            fileContentsBuilder.append((CharSequence)sb);
            fileContentsBuilder.append("\r\n");
            sb = new StringBuilder("Data");
            for (MacroAction macroAction : macroActionsList) {
                sb.append(",");
                sb.append(macroAction.getData());
            }
            System.out.println(sb.toString());
            fileContentsBuilder.append((CharSequence)sb);
            fileContentsBuilder.append("\r\n");
            sb = new StringBuilder("Macro Name");
            for (MacroAction macroAction : macroActionsList) {
                sb.append(",");
            }
            System.out.println(sb.toString());
            fileContentsBuilder.append((CharSequence)sb);
            fileContentsBuilder.append("\r\n");
            ArrayList<MacroNode> macroNodes = this._macroTreeTableModel.getMacroNodes();
            for (MacroNode macroNode : macroNodes) {
                ArrayList<MacroActionNode> macroActionsForMacro = macroNode.getMacroActionNodes();
                sb = new StringBuilder(macroNode.getName());
                for (MacroAction macroAction : macroActionsList) {
                    sb.append(",");
                    int index = -1;
                    for (int i = 0; i < macroActionsForMacro.size(); ++i) {
                        if (macroActionsForMacro.get(i).getMacroAction() != macroAction) continue;
                        index = i;
                        break;
                    }
                    if (-1 == index) continue;
                    sb.append(macroNode.getMacroActionNodes().get(index).getTimingSeconds());
                }
                System.out.println(sb.toString());
                fileContentsBuilder.append((CharSequence)sb);
                fileContentsBuilder.append("\r\n");
            }
            FileUtils.writeAllBytes(filepath, fileContentsBuilder.toString().getBytes());
            return true;
        }
        catch (Exception ex) {
            NotificationCollection.addError("Error saving macro file", ex);
            return false;
        }
    }

    private void setDataColumnRenderer() {
        ActionDataCellRenderer actionDataCellRenderer = new ActionDataCellRenderer();
        this.macroActionTable.getColumnModel().getColumn(3).setCellRenderer(actionDataCellRenderer);
        actionDataCellRenderer.setGetTooltipListener(rowIndex -> {
            MacroAction macroAction = this._macroActionTableModel.getMacroActionAtRow(rowIndex);
            CinemaDevice cinemaDevice = macroAction.getDevice();
            String action = macroAction.getAction();
            return "";
        });
    }

    public String getMacroFilePath() {
        return this._macroFilePath;
    }

    private void loadInternalDevices() {
        String name;
        int i;
        for (i = 0; i < 12; ++i) {
            name = "DIN " + (i + 1);
            this.loadInternalDevice(name);
        }
        for (i = 0; i < 16; ++i) {
            name = "ROUT " + (i + 1);
            this.loadInternalDevice(name);
        }
        for (i = 0; i < 12; ++i) {
            name = "FPLED " + (i + 1);
            this.loadInternalDevice(name);
        }
        this.loadInternalDevice("FPLED ALL");
        this.loadInternalDevice("FPSOUND");
        this.loadInternalDevice("CINEMA_SERVER_CLIENT");
        this.loadInternalDevice("PRESHOW_CLIENT");
        this.loadInternalDevice("CINEMA_MANAGER");
    }

    private void loadInternalDevice(String name) {
        this._knownDevices.put(name, CinemaDeviceFactory.getCinemaDevice(name).setName(name));
    }

    private void linkDeviceFile() {
        Object[] options = new String[]{"Local File", "Remote File", "Not Now"};
        int result = JOptionPane.showOptionDialog(null, "External device found.  Would you like to link a devices file?", "External devices found", 1, 3, null, options, options[2]);
        try {
            JniorInfo[] selectedJniors;
            if (0 == result) {
                File selectedDeviceFile = this.promptForDevicesFile();
                if (null != selectedDeviceFile) {
                    this.linkedDevicesFilePathLabel.setText(selectedDeviceFile.getPath());
                    String deviceFileContents = FileUtils.readAllText(selectedDeviceFile.getPath());
                    this.linkDeviceContents(deviceFileContents);
                    this.linkedDevicesFilePathLabel.setText(selectedDeviceFile.getPath());
                }
            } else if (1 == result && null != (selectedJniors = this.getSelectedJniors()) && 0 < selectedJniors.length) {
                for (JniorInfo jniorInfo : selectedJniors) {
                    RemoteCinemaFileOpener remoteFileOpener = new RemoteCinemaFileOpener(jniorInfo);
                    remoteFileOpener.setTitle("Remote Devices File Opener");
                    InProgressMessageToast inProgressMessageToast = new InProgressMessageToast(remoteFileOpener);
                    ToastNotifications.getInstance().display(inProgressMessageToast);
                    remoteFileOpener.setFilenameFilter((dir, name) -> (name = name.toLowerCase()).startsWith("devices") && name.endsWith(".csv"));
                    remoteFileOpener.addProgressUpdateListener(e1 -> {
                        if (remoteFileOpener.getResult().hasCompleted()) {
                            try {
                                File localTempDeviceFile = remoteFileOpener.getLocalFile();
                                if (null != localTempDeviceFile) {
                                    String deviceFileContents = FileUtils.readAllText(localTempDeviceFile.getPath());
                                    this.linkDeviceContents(deviceFileContents);
                                    this.linkedDevicesFilePathLabel.setText(localTempDeviceFile.getPath());
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            finally {
                                ThreadUtils.sleep(500);
                                ToastNotifications.getInstance().hide(inProgressMessageToast);
                            }
                        }
                    });
                    remoteFileOpener.start();
                }
            }
        }
        catch (Exception ex) {
            NotificationCollection.addError("Error linking devices file", ex);
        }
    }

    private void updateSaveButton() {
        int i;
        boolean saveNeeded;
        if (null == this._macroFilePath) {
            this.saveButton.setEnabled(false);
            return;
        }
        boolean bl = saveNeeded = this._macroTreeTableModel.getMacroNodes().size() != this._savedMacroHashMap.size() || this._macroActionTableModel.getSize() != this._savedMacroActionHashMap.size();
        if (!saveNeeded) {
            for (i = 0; i < this._macroTreeTableModel.getMacroNodes().size(); ++i) {
                MacroNode macroNode = this._macroTreeTableModel.getMacroNodes().get(i);
                if (this._savedMacroHashMap.containsKey(macroNode.hashCode())) {
                    MacroNode savedMacroNode = this._savedMacroHashMap.get(macroNode.hashCode());
                    if (macroNode.equals(savedMacroNode)) continue;
                    saveNeeded = true;
                    break;
                }
                saveNeeded = true;
            }
        }
        if (!saveNeeded) {
            for (i = 0; i < this._macroActionTableModel.getSize(); ++i) {
                MacroAction macroAction = this._macroActionTableModel.getMacroActionAtRow(i);
                if (this._savedMacroActionHashMap.containsKey(macroAction.hashCode())) {
                    MacroAction savedMacroAction = this._savedMacroActionHashMap.get(macroAction.hashCode());
                    if (macroAction.equals(savedMacroAction)) continue;
                    saveNeeded = true;
                    break;
                }
                saveNeeded = true;
            }
        }
        this.saveButton.setEnabled(saveNeeded);
    }
}

