/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui.menus;

import com.integ.janoslib.net.beacon.Beacon;
import com.integ.janoslib.net.beacon.BeaconNetworkInterface;
import com.integ.supporter.ApplicationUpdater;
import com.integ.supporter.NTPClient;
import com.integ.supporter.ShowNetworkInterfacesDialog;
import com.integ.supporter.WebUrlLauncher;
import com.integ.supporter.ui.dialogs.AboutDialog;
import java.awt.Dimension;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class HelpMenu
extends JMenu {
    private final JMenuItem _ntpTimeMenuItem = new JMenuItem("NTP Sync: ");
    private final JMenuItem _ntpOffsetMenuItem = new JMenuItem("NTP Offset: ms");
    private final JMenuItem _ntpElapsedTimeMenuItem = new JMenuItem("NTP elapsed time:");

    public HelpMenu() {
        super("Help");
        this.initMenuItems();
    }

    private void initMenuItems() {
        this.addShowNetwork();
        super.addSeparator();
        this.addKnowledgebase();
        this.addContactUs();
        this.addJniorCom();
        super.addSeparator();
        this.addShowInterfaces();
        super.addSeparator();
        this.addCheckForUpdate();
        this.addAbout();
        this.addNtp();
    }

    private void addShowNetwork() {
        JMenuItem aboutMenuItem = new JMenuItem("Show Network...");
        aboutMenuItem.addActionListener(e -> {
            ShowNetworkInterfacesDialog dialog = new ShowNetworkInterfacesDialog(null, true);
            dialog.setLocationRelativeTo(null);
            dialog.setSize(new Dimension(600, 400));
            dialog.setVisible(true);
        });
        super.add(aboutMenuItem);
    }

    private void addKnowledgebase() {
        JMenuItem aboutMenuItem = new JMenuItem("Knowledgebase...");
        aboutMenuItem.addActionListener(e -> WebUrlLauncher.go("https://jnior.com/jnior-supporter-overview/?kb=kb-supporttool,kb-supporter&section=getting%20started"));
        super.add(aboutMenuItem);
    }

    private void addContactUs() {
        JMenuItem aboutMenuItem = new JMenuItem("Contact Us...");
        aboutMenuItem.addActionListener(e -> WebUrlLauncher.go("https://jnior.com/contact"));
        super.add(aboutMenuItem);
    }

    private void addJniorCom() {
        JMenuItem aboutMenuItem = new JMenuItem("Jnior.com...");
        aboutMenuItem.addActionListener(e -> WebUrlLauncher.go("https://jnior.com"));
        super.add(aboutMenuItem);
    }

    private void addShowInterfaces() {
        for (BeaconNetworkInterface beaconNetworkInterface : Beacon.getInstance().getNetworkInterfaces()) {
            super.add(new JMenuItem(beaconNetworkInterface.getNetworkInterface().toString()));
        }
    }

    private void addCheckForUpdate() {
        JMenuItem menuItem = new JMenuItem("Check for Update...");
        menuItem.addActionListener(e -> ApplicationUpdater.CheckForUpdate(true));
        super.add(menuItem);
    }

    private void addAbout() {
        JMenuItem aboutMenuItem = new JMenuItem("About...");
        aboutMenuItem.addActionListener(e -> {
            AboutDialog dialog = new AboutDialog(null, true);
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
        });
        super.add(aboutMenuItem);
    }

    private void addNtp() {
        NTPClient.addListener(e -> {
            this._ntpTimeMenuItem.setText("NTP Sync: " + NTPClient.getNetworkTime());
            this._ntpOffsetMenuItem.setText("NTP Offset: " + NTPClient.getOffset() + "ms");
            this._ntpElapsedTimeMenuItem.setText("NTP elapsed time: " + NTPClient.getElapsedTime() + "s");
        });
    }
}

