/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.updater.steps;

import com.integ.janoslib.utils.FileUtils;
import com.integ.janoslib.utils.HexUtils;
import com.integ.janoslib.utils.PathUtils;
import com.integ.janoslib.utils.ZipUtils;
import com.integ.supporter.Constants;
import com.integ.supporter.updater.UpdateProjectFile;
import com.integ.supporter.updater.steps.FtpStepPanel;
import com.integ.supporter.updater.steps.ProjectStep;
import com.integ.supporter.updater.steps.ProjectStepPanel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FtpStep
extends ProjectStep {
    protected String _absoluteFile = "";
    protected String _localFile = "";
    protected String _remoteFolder = "";
    protected String _remoteFile = "";
    protected String _md5 = "";
    protected boolean _updateAvailable = false;
    protected boolean _force = false;
    protected boolean _updated = false;

    public FtpStep(String name) {
        super(name);
        this._type = "LoadFtpProperty";
    }

    public FtpStep(Element xmlElement) {
        super(xmlElement);
        this._absoluteFile = this.getChildNodeString("AbsoluteFile");
        System.out.println("_absoluteFile = " + this._absoluteFile);
        this._localFile = this.getChildNodeString("LocalFile");
        System.out.println("LocalFile: " + this._localFile);
        this._remoteFolder = this.getChildNodeString("RemoteFolder");
        System.out.println("RemoteFolder: " + this._remoteFolder);
        this._remoteFile = this.getChildNodeString("RemoteFile");
        System.out.println("RemoteFile: " + this._remoteFile);
        this._md5 = this.getChildNodeString("Md5");
        this._md5 = this._md5.toLowerCase();
        System.out.println("Md5: " + this._md5);
        this.checkForUpdate();
    }

    public final void checkForUpdate() {
        if (null != this._absoluteFile && new File(this._absoluteFile).exists()) {
            try {
                byte[] fileContentBytes = FileUtils.readAllBytes(this._absoluteFile);
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(fileContentBytes);
                byte[] digest = md.digest();
                String md5String = HexUtils.bytesToHex(digest).toUpperCase();
                this._updateAvailable = !md5String.equalsIgnoreCase(this._md5);
            }
            catch (NoSuchAlgorithmException ex) {
                Logger.getLogger(ProjectStepPanel.class.getName()).severe(ex.getMessage());
            }
            catch (IOException ex) {
                Logger.getLogger(ProjectStepPanel.class.getName()).severe(ex.getMessage());
            }
        }
    }

    @Override
    public Element getXmlElement(Document document) {
        Element xmlElement = super.getXmlElement(document);
        Element element = document.createElement("AbsoluteFile");
        element.appendChild(document.createTextNode(this._absoluteFile));
        xmlElement.appendChild(element);
        element = document.createElement("LocalFile");
        element.appendChild(document.createTextNode(this._localFile));
        xmlElement.appendChild(element);
        element = document.createElement("RemoteFolder");
        element.appendChild(document.createTextNode(this._remoteFolder));
        xmlElement.appendChild(element);
        element = document.createElement("RemoteFile");
        element.appendChild(document.createTextNode(this._remoteFile));
        xmlElement.appendChild(element);
        element = document.createElement("Md5");
        element.appendChild(document.createTextNode(this._md5));
        xmlElement.appendChild(element);
        return xmlElement;
    }

    public String getAbsoluteFilePath() {
        return this._absoluteFile;
    }

    public void setAbsoluteFilePath(String path) {
        String oldPath = this._absoluteFile;
        this._absoluteFile = path;
        try {
            UpdateProjectFile updateProjectFile = this.getUpdateProjectFile();
            String title = updateProjectFile.getTitle();
            ZipUtils.addFile(updateProjectFile.getFile().getPath(), path, title);
            if (null != oldPath && !path.equals(oldPath)) {
                File oldFile = new File(oldPath);
                String pathToOldFileInZip = title + "/" + oldFile.getName();
                ZipUtils.deleteEntry(updateProjectFile.getFile().getPath(), pathToOldFileInZip);
            }
            if (null == this._remoteFile || "".equals(this._remoteFile)) {
                this._remoteFile = this._localFile;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Logger.getLogger(FtpStepPanel.class.getName()).severe(ex.getMessage());
        }
    }

    public String getLocalFile() {
        return this._localFile;
    }

    public void setLocalFile(String localFile) {
        this._localFile = localFile;
    }

    public String getRemoteFolder() {
        return this._remoteFolder;
    }

    public void setRemoteFolder(String remoteFolder) {
        String oldPath = this.getRemotePath();
        this._remoteFolder = remoteFolder;
        String newRemotePath = PathUtils.combine(this._remoteFolder, this.getRemoteFile());
        if (!newRemotePath.equalsIgnoreCase(oldPath)) {
            this._changes.firePropertyChange("RemotePath", oldPath, newRemotePath);
        }
    }

    public String getRemoteFile() {
        return this._remoteFile;
    }

    public void setRemoteFile(String remoteFile) {
        String oldPath = this.getRemotePath();
        this._remoteFile = remoteFile;
        String newRemotePath = PathUtils.combine(this.getRemoteFolder(), this._remoteFile);
        if (!newRemotePath.equalsIgnoreCase(oldPath)) {
            this._changes.firePropertyChange("RemotePath", oldPath, newRemotePath);
        }
    }

    public String getRemotePath() {
        return PathUtils.combine(this.getRemoteFolder(), this.getRemoteFile());
    }

    public String getMd5() {
        return this._md5;
    }

    void setMd5(String md5String) {
        String oldValue = this._md5;
        this._md5 = md5String.toLowerCase();
        this._changes.firePropertyChange("Md5", oldValue, this._md5);
    }

    public boolean isUpdateAvailable() {
        return this._updateAvailable;
    }

    @Override
    public boolean execute() throws Exception {
        this._updated = false;
        try {
            ZipEntry zipEntry;
            File tempFile;
            this._logger.info("  target jnior series: " + this._jniorInfo.getSeries());
            String remotePath = this.getRemotePath();
            if (!this._force) {
                String lsResponse;
                if (4 == this._jniorInfo.getSeries()) {
                    this._logger.info(String.format("  checking to see if an update for %s is needed...", remotePath));
                    lsResponse = this._jniorUpdateControlConnection.exec("ls \"" + remotePath + "\"");
                    if (lsResponse.toLowerCase().contains("no such file or directory")) {
                        this._force = true;
                    }
                    if (!this._force) {
                        String manifestResponse = this._jniorUpdateControlConnection.exec("manifest \"" + remotePath + "\"");
                        Pattern md5Pattern = Pattern.compile("[\\da-g]{32}", 2);
                        Matcher matcher = md5Pattern.matcher(manifestResponse);
                        if (matcher.find()) {
                            String uploadedMd5 = matcher.group();
                            this._logger.info(String.format("  local md5: %s, remote md5: %s", this._md5, uploadedMd5));
                            if (this._md5.equalsIgnoreCase(uploadedMd5)) {
                                this._summary = String.format("  updating %s is not needed", remotePath);
                                this._logger.info(this._summary);
                                return true;
                            }
                        } else {
                            this._logger.warning("      md5 pattern was not found in the manifest response:\n" + manifestResponse);
                        }
                    }
                } else if (3 == this._jniorInfo.getSeries() && !"".equals(this._md5)) {
                    this._logger.info(String.format("  check to see if %s exists", remotePath));
                    lsResponse = this._jniorUpdateControlConnection.exec(String.format("ls %s", remotePath));
                    boolean fileNotFound = lsResponse.toLowerCase().contains("no such");
                    if (!fileNotFound) {
                        this._logger.info(String.format("  download %s to determine if the upload is needed", remotePath));
                        tempFile = File.createTempFile(this._remoteFile, "", new File(Constants.TEMP_DIRECTORY));
                        FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
                        boolean result = this._jniorUpdateControlConnection.retrieveFile(remotePath, fileOutputStream);
                        if (result) {
                            byte[] tempFileBytes = FileUtils.readAllBytes(tempFile.getPath());
                            MessageDigest md = MessageDigest.getInstance("MD5");
                            md.update(tempFileBytes);
                            byte[] digest = md.digest();
                            String newMd5String = HexUtils.bytesToHex(digest).toUpperCase();
                            this._logger.info(String.format("  remote file md5: %s", newMd5String));
                            if (newMd5String.equalsIgnoreCase(this._md5)) {
                                this._summary = String.format("  updating %s is not needed", remotePath);
                                this._logger.info(this._summary);
                                return true;
                            }
                        }
                    }
                }
            }
            if (null != (zipEntry = this._updateProjectFile.getEntryForFile(this._localFile))) {
                byte[] fileContentBytes = ZipUtils.extractEntry(this._updateProjectFile.getFilePath(), zipEntry.getName());
                tempFile = File.createTempFile("tmp", ".tmp", new File(Constants.TEMP_DIRECTORY));
                FileUtils.writeAllBytes(tempFile.getPath(), fileContentBytes);
                tempFile.setLastModified(zipEntry.getTime());
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(tempFile.lastModified());
                Date date = cal.getTime();
                System.out.println(zipEntry.getName() + " last modified = " + date);
                String parentDirectoryListing = this._jniorUpdateControlConnection.exec("ls " + this._remoteFolder);
                if (parentDirectoryListing.toLowerCase().contains("no such")) {
                    Object path = "";
                    String[] parts = this._remoteFolder.split("/");
                    for (String part : parts) {
                        String directoryListing;
                        if ("".equals(part) || !(directoryListing = this._jniorUpdateControlConnection.exec("ls " + (String)(path = (String)path + "/" + part))).toLowerCase().contains("no such")) continue;
                        this._logger.info("Creating " + (String)path);
                        this._jniorUpdateControlConnection.exec("mkdir " + (String)path);
                        directoryListing = this._jniorUpdateControlConnection.exec("ls " + (String)path);
                        if (!directoryListing.toLowerCase().contains("no such")) continue;
                        throw new Exception("Failed to create " + (String)path);
                    }
                }
                this._logger.info(String.format("  upload %s to %s", this._localFile, remotePath));
                boolean result = this._jniorUpdateControlConnection.storeFile(remotePath, tempFile);
                if (result) {
                    this._summary = String.format("  uploaded %s to %s", this._localFile, remotePath);
                    this._logger.info(this._summary);
                }
                if (4 == this._jniorInfo.getSeries()) {
                    this._logger.info("    validating upload");
                    String manifestResponse = this._jniorUpdateControlConnection.exec("manifest " + remotePath);
                    Pattern md5Pattern = Pattern.compile("[\\da-g]{32}", 2);
                    Matcher matcher = md5Pattern.matcher(manifestResponse);
                    if (matcher.find()) {
                        String uploadedMd5 = matcher.group();
                        if (!("".equals(this._md5) || !"".equals(uploadedMd5) && this._md5.equalsIgnoreCase(uploadedMd5))) {
                            throw new RuntimeException("Upload failed");
                        }
                        this._logger.info("    upload verified");
                        this._updated = true;
                    }
                    tempFile.delete();
                } else {
                    this._updated = true;
                }
                return result;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException("unable to transfer " + this._localFile, ex);
        }
        return false;
    }
}

