/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.cinema.models;

import com.integ.supporter.cinema.devices.CinemaDevice;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Random;

public class MacroAction {
    private final int _instanceHash = new Random().nextInt() & 0xFFFFFFFF;
    private final PropertyChangeSupport _propertyChangeSupport = new PropertyChangeSupport(this);
    private String _name;
    private CinemaDevice _cinemaDevice;
    private String _cinemaDeviceName = "";
    private String _action = "";
    private String _data = "";

    public int hashCode() {
        return this._instanceHash;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public MacroAction(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        String oldValue = this.getName();
        this._name = name.trim();
        this._propertyChangeSupport.firePropertyChange("Name", oldValue, name);
    }

    public CinemaDevice getDevice() {
        return this._cinemaDevice;
    }

    public void setDevice(CinemaDevice cinemaDevice) {
        CinemaDevice oldValue = this.getDevice();
        this._cinemaDevice = cinemaDevice;
        this._propertyChangeSupport.firePropertyChange("CinemaDevice", oldValue, cinemaDevice);
    }

    public String getDeviceName() {
        return this._cinemaDeviceName;
    }

    public void setDeviceName(String cinemaDeviceName) {
        if ("null".equalsIgnoreCase(cinemaDeviceName)) {
            cinemaDeviceName = "";
        }
        String oldValue = this.getDeviceName();
        this._cinemaDeviceName = cinemaDeviceName;
        this._propertyChangeSupport.firePropertyChange("DeviceName", oldValue, cinemaDeviceName);
    }

    public String getAction() {
        return this._action;
    }

    public void setAction(String action) {
        if ("null".equalsIgnoreCase(action)) {
            action = "";
        }
        String oldValue = this.getAction();
        this._action = action;
        this._propertyChangeSupport.firePropertyChange("Action", oldValue, action);
    }

    public String getData() {
        return this._data;
    }

    public void setData(String data) {
        if ("null".equalsIgnoreCase(data)) {
            data = "";
        }
        String oldValue = this.getData();
        this._data = data;
        this._propertyChangeSupport.firePropertyChange("Data", oldValue, data);
    }

    public String getDescription() {
        if (null == this._cinemaDevice && null == this._cinemaDeviceName) {
            return "Device not defined";
        }
        String cinemaDeviceName = this._cinemaDeviceName;
        if (null != this._cinemaDevice) {
            cinemaDeviceName = this._cinemaDevice.toString();
        }
        if (null == this._action) {
            return String.format("Action for '%s' not selected", this._cinemaDevice.toString());
        }
        if (null == this._data) {
            return String.format("%s action for %s has not been defined", this._action, this._cinemaDevice.toString());
        }
        return cinemaDeviceName + " " + this._action + " " + this._data;
    }

    public String getDeviceType() {
        return this._cinemaDevice.toString().getClass().getName();
    }

    public String getNameWithDeviceType() {
        if (null != this._cinemaDevice) {
            return this._name + " (" + this.getDeviceType().replaceAll(" ", "_") + ")";
        }
        return this._name;
    }

    public String toString() {
        return this._name;
    }

    public MacroAction clone() {
        MacroAction newMacroAction = new MacroAction(this._name);
        newMacroAction.setDevice(this._cinemaDevice);
        newMacroAction.setAction(this._action);
        newMacroAction.setData(this._data);
        return newMacroAction;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!(obj instanceof MacroAction)) {
            return false;
        }
        MacroAction macroActionToCompareTo = (MacroAction)obj;
        if (!this.getName().equals(macroActionToCompareTo.getName())) {
            return false;
        }
        if (this.getDevice() != this.getDevice()) {
            return false;
        }
        if (!this.getAction().equals(macroActionToCompareTo.getAction())) {
            return false;
        }
        return this.getData().equals(macroActionToCompareTo.getData());
    }
}

