/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.jrget.models;

import com.integ.supporter.Constants;
import com.integ.supporter.jrget.models.DefaultTreeTableNode;
import com.integ.supporter.jrget.models.LocalUpdateNode;
import com.integ.supporter.jrget.models.UpdatesTreeTableModel;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.TreeNode;

public class LocalUpdatesNode
extends DefaultTreeTableNode {
    private final UpdatesTreeTableModel _model;
    private final ArrayList<File> _filesList = new ArrayList();

    public LocalUpdatesNode(UpdatesTreeTableModel model) {
        super("Local Update Projects");
        this._model = model;
        this.loadLocalUpdateProjects();
        new Thread(() -> {
            WatchKey key;
            boolean valid;
            Path dir = Paths.get(Constants.UPDATE_PROJECTS_DIRECTORY, new String[0]);
            WatchService watcher = null;
            try {
                watcher = FileSystems.getDefault().newWatchService();
                dir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            }
            catch (IOException ex) {
                Logger.getLogger(LocalUpdatesNode.class.getName()).log(Level.SEVERE, null, ex);
            }
            do {
                try {
                    key = watcher.take();
                }
                catch (InterruptedException x) {
                    return;
                }
                for (WatchEvent<?> event : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = event.kind();
                    this.loadLocalUpdateProjects();
                    if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                    this.loadLocalUpdateProjects();
                }
                this._model.fireTreeStructureChanged(this, null, null, null);
            } while (valid = key.reset());
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLocalUpdateProjects() {
        ArrayList<File> arrayList = this._filesList;
        synchronized (arrayList) {
            this._filesList.clear();
            File updateProjectsDirectory = new File(Constants.UPDATE_PROJECTS_DIRECTORY);
            File[] files = updateProjectsDirectory.listFiles();
            if (0 < files.length) {
                for (File file : files) {
                    if (!file.isFile()) continue;
                    this._filesList.add(file);
                }
                this._filesList.sort((o1, o2) -> -Long.valueOf(o1.lastModified()).compareTo(o2.lastModified()));
            }
            if (0 < super.getChildCount()) {
                super.removeAllChildren();
            }
        }
    }

    @Override
    public String toString() {
        return String.format("%s (%d)", super.getUserObject(), this.getChildCount());
    }

    @Override
    public Object getValueAt(Object node, int column) {
        return "";
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getChildCount() {
        ArrayList<File> arrayList = this._filesList;
        synchronized (arrayList) {
            return this._filesList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TreeNode getChildAt(int index) {
        ArrayList<File> arrayList = this._filesList;
        synchronized (arrayList) {
            return new LocalUpdateNode(this._filesList.get(index));
        }
    }
}

