/*
 * Decompiled with CFR 0.152.
 */
package com.integ.janoslib.net.beacon;

import com.integ.janoslib.net.IClient;
import com.integ.janoslib.net.UdpConnectionListener;
import com.integ.janoslib.net.UdpServer;
import com.integ.janoslib.net.beacon.BeaconListener;
import com.integ.janoslib.net.beacon.BeaconMessageFactory;
import com.integ.janoslib.net.beacon.BeaconNetworkInterface;
import com.integ.janoslib.net.beacon.BeaconNotifier;
import com.integ.janoslib.net.beacon.BeaconServerListener;
import com.integ.janoslib.net.beacon.BeaconServerNotifier;
import com.integ.janoslib.net.beacon.JniorCollection;
import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.janoslib.net.beacon.commands.BeaconCommand;
import com.integ.janoslib.net.beacon.commands.QueryAllCommand;
import com.integ.janoslib.net.beacon.commands.QueryCommand;
import com.integ.janoslib.net.beacon.messages.BeaconMessage;
import com.integ.janoslib.net.beacon.messages.DeathBeaconMessage;
import com.integ.janoslib.net.beacon.messages.UnknownBeaconMessage;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.janoslib.utils.HexUtils;
import com.integ.janoslib.utils.NetworkUtils;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.RollingLog;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;

public class Beacon
implements UdpConnectionListener {
    public static final Logger LOGGER = RollingLog.getLogger("Beacon");
    public static final Logger DATA_LOGGER = RollingLog.getLogger("BeaconData");
    public static final int PORT = 4444;
    private final ArrayList<UdpServer> _udpServers = new ArrayList();
    private final BeaconServerNotifier _beaconServerNotifier = new BeaconServerNotifier();
    private final BeaconNotifier _beaconNotifier = new BeaconNotifier();
    private ArrayList<BeaconNetworkInterface> _beaconInterfaces = new ArrayList();
    private final Hashtable<InetAddress, Long> _lastMessageReceived = new Hashtable();
    private static final Beacon Intance = new Beacon();
    private final Hashtable<InetAddress, JniorInfo> _queriedJniors = new Hashtable();

    public static Beacon getInstance() {
        return Intance;
    }

    private Beacon() {
    }

    public void start() {
        try {
            this._beaconInterfaces = BeaconNetworkInterface.getBeaconInterfaces();
            Thread.sleep(1000L);
            for (BeaconNetworkInterface beaconInterface : this._beaconInterfaces) {
                NetworkInterface networkInterface = beaconInterface.getNetworkInterface();
                for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                    InetAddress inetAddress = interfaceAddress.getAddress();
                    if (!(inetAddress instanceof Inet4Address)) continue;
                    UdpServer udpServer = new UdpServer(inetAddress, 4444);
                    this._udpServers.add(udpServer);
                    udpServer.setLog(LOGGER);
                    udpServer.setListener(this);
                    try {
                        udpServer.start();
                    }
                    catch (Exception ex) {
                        NotificationCollection.addError("Error starting beacon server", ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    public void addBeaconServerListener(BeaconServerListener beaconServerListener) {
        this._beaconServerNotifier.add(beaconServerListener);
    }

    public void addBeaconListener(BeaconListener beaconListener) {
        this._beaconNotifier.add(beaconListener);
    }

    public BeaconNotifier getBeaconNotifier() {
        return this._beaconNotifier;
    }

    public void removeBeaconListener(BeaconListener beaconListener) {
        this._beaconNotifier.remove(beaconListener);
    }

    @Override
    public void serverListening() {
        LOGGER.info(String.format("Listening for clients on udp port %d", 4444));
        this._beaconServerNotifier.fireServerReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processMessage(IClient client, DatagramSocket datagramSocket, DatagramPacket datagramPacket) {
        InetAddress senderAddress = datagramPacket.getAddress();
        byte[] message = Arrays.copyOf(datagramPacket.getData(), datagramPacket.getLength());
        LOGGER.info(String.format("%s: recv %d bytes on %s", senderAddress.getHostAddress(), datagramPacket.getLength(), datagramSocket.getLocalSocketAddress()));
        DATA_LOGGER.info(String.format("recv %d bytes from %s on %s\n%s", datagramPacket.getLength(), senderAddress.getHostAddress(), datagramSocket, HexUtils.hexDump(message, 0, message.length)));
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(message);
            DataInputStream dis = new DataInputStream(bais);
            int length = dis.readUnsignedShort();
            int serialNumber = dis.readInt() & 0xFFFFFFFF;
            String command = Beacon.readString(dis);
            if (-1 == serialNumber) {
                if (command.equalsIgnoreCase("get_jniors")) {
                    JSONArray jsonResponseArray = new JSONArray();
                    for (JniorInfo jniorInfo : JniorCollection.getJniors()) {
                        jsonResponseArray.put(jniorInfo.toJSON());
                    }
                    String jsonDumpString = jsonResponseArray.toString(2);
                    System.out.println("jsonDump = " + jsonDumpString);
                    byte[] jsonDumpBytes = jsonDumpString.getBytes();
                    InetAddress inetAddress = datagramPacket.getAddress();
                    int remotePort = datagramPacket.getPort();
                    DatagramPacket responsePacket = new DatagramPacket(jsonDumpBytes, jsonDumpBytes.length, inetAddress, remotePort);
                    new DatagramSocket().send(responsePacket);
                }
                return;
            }
            long MessageHash = Arrays.hashCode(message) & 0xFFFFFFFF;
            Hashtable<InetAddress, Long> jsonDumpBytes = this._lastMessageReceived;
            synchronized (jsonDumpBytes) {
                long lastMessageHash;
                if (this._lastMessageReceived.containsKey(senderAddress) && MessageHash == (lastMessageHash = this._lastMessageReceived.get(senderAddress).longValue())) {
                    LOGGER.info(String.format("%s: already processed %d bytes", senderAddress.getHostAddress(), datagramPacket.getLength()));
                    return;
                }
                this._lastMessageReceived.put(senderAddress, MessageHash);
            }
            JniorInfo jniorInfo = null;
            if (this._queriedJniors.containsKey(senderAddress)) {
                jniorInfo = this._queriedJniors.remove(senderAddress);
                jniorInfo.setSerialNumber(serialNumber);
            } else {
                jniorInfo = JniorCollection.getJniorInfoBySerialNumber(serialNumber);
            }
            jniorInfo.setActive();
            InetAddress localAddress = NetworkUtils.getLocalAddressFor(senderAddress);
            jniorInfo.setReceivingIPAddress(localAddress);
            jniorInfo.AccessibleFromLocalMachine = null != localAddress;
            jniorInfo.LastAnnounced = new Date();
            BeaconMessage beaconMessage = BeaconMessageFactory.getBeaconMessage(command, serialNumber);
            if (!(beaconMessage instanceof UnknownBeaconMessage)) {
                beaconMessage.setJniorInfo(jniorInfo);
                byte[] messageBytes = new byte[dis.available()];
                dis.readFully(messageBytes);
                beaconMessage.parse(messageBytes);
                jniorInfo.notifyInfo();
                jniorInfo.Status = beaconMessage instanceof DeathBeaconMessage ? 2 : 0;
                this._beaconNotifier.fireUnitUpdated(jniorInfo);
            } else {
                LOGGER.severe("Uknown beacon message received from " + senderAddress);
            }
        }
        catch (Exception ex) {
            String stacktrace = ExceptionUtils.getStackTrace(ex);
            LOGGER.severe(stacktrace);
        }
    }

    public void updateBeaconInterfaces() throws SocketException {
        this._beaconInterfaces = BeaconNetworkInterface.getBeaconInterfaces();
    }

    public ArrayList<BeaconNetworkInterface> getNetworkInterfaces() {
        return this._beaconInterfaces;
    }

    public void broadcastCommand(BeaconCommand beaconCommand) {
        String beaconCommandName = beaconCommand.getClass().getName();
        try {
            if (beaconCommand instanceof QueryAllCommand) {
                long start = System.currentTimeMillis();
                this.updateBeaconInterfaces();
                long elapsed = System.currentTimeMillis() - start;
                LOGGER.info(String.format("took %d to update interfaces", elapsed));
            }
            LOGGER.info(String.format("broadcasting %s\r\n%s", beaconCommandName, HexUtils.hexDump(beaconCommand.getBytes(), 0, beaconCommand.getBytes().length)));
            LOGGER.info(String.format("%d beacon interfaces", this._beaconInterfaces.size()));
            for (BeaconNetworkInterface beaconInterface : this._beaconInterfaces) {
                NetworkInterface networkInterface = beaconInterface.getNetworkInterface();
                LOGGER.info(String.format("use %s [%s]", networkInterface.getDisplayName(), networkInterface.getHardwareAddress()));
                for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                    InetAddress inetAddress = interfaceAddress.getAddress();
                    if (!(inetAddress instanceof Inet4Address)) continue;
                    this.sendCommand(interfaceAddress.getBroadcast(), 4444, beaconCommand, new InetSocketAddress(interfaceAddress.getAddress(), 0));
                }
            }
        }
        catch (SocketException ex) {
            NotificationCollection.addError("Error broadcating " + beaconCommandName, ex);
        }
    }

    public void sendCommand(InetAddress inetAddress, BeaconCommand beaconCommand) throws SocketException {
        this.sendCommand(inetAddress, 4444, beaconCommand, null);
    }

    public void sendCommand(InetAddress destinationAddress, int port, BeaconCommand beaconCommand, InetSocketAddress sendingAddress) throws SocketException {
        if (null == destinationAddress) {
            return;
        }
        if (beaconCommand instanceof QueryAllCommand) {
            JniorCollection.clearActive();
        } else if (beaconCommand instanceof QueryCommand && 0 < beaconCommand.getSerialNumber()) {
            JniorInfo jniorInfo = JniorCollection.getJniorInfoBySerialNumber(beaconCommand.getSerialNumber());
            jniorInfo.clearActive();
        }
        new Thread(() -> {
            String s = null;
            try {
                DatagramSocket datagramSocket = new DatagramSocket(sendingAddress);
                try {
                    s = null != sendingAddress ? String.format("sending %s to %s:%d bound to %s", beaconCommand.getClass().getName(), destinationAddress, port, sendingAddress) : String.format("sending %s to %s:%d", beaconCommand.getClass().getName(), destinationAddress, port);
                    LOGGER.info(s);
                    byte[] beaconMessageBytes = beaconCommand.getBytes();
                    DatagramPacket datagramPacket = new DatagramPacket(beaconMessageBytes, beaconMessageBytes.length, destinationAddress, port);
                    datagramSocket.send(datagramPacket);
                    DATA_LOGGER.info(String.format("%s: sent %d bytes on %s", sendingAddress, datagramPacket.getLength(), datagramSocket.getLocalSocketAddress()));
                    datagramSocket.setSoTimeout(5000);
                    while (true) {
                        datagramPacket = new DatagramPacket(new byte[1024], 1024);
                        datagramSocket.receive(datagramPacket);
                        datagramSocket.setSoTimeout(10);
                        this.processMessage(null, datagramSocket, datagramPacket);
                    }
                }
                catch (Throwable beaconMessageBytes) {
                    try {
                        datagramSocket.close();
                    }
                    catch (Throwable throwable) {
                        beaconMessageBytes.addSuppressed(throwable);
                    }
                    throw beaconMessageBytes;
                }
            }
            catch (SocketTimeoutException ex) {
                SocketTimeoutException ex2 = new SocketTimeoutException("error " + s);
                ex2.initCause(ex);
                String string = ExceptionUtils.getStackTrace(ex2);
            }
            catch (Exception ex2) {
                IOException ex2 = new IOException("error " + s, ex2);
                String stacktrace = ExceptionUtils.getStackTrace(ex2);
                LOGGER.severe(stacktrace);
            }
        }, "Beacon.sendCommand()").start();
    }

    public static String readString(DataInputStream dis) throws IOException {
        int length = dis.readUnsignedShort();
        byte[] stringBytes = new byte[length];
        dis.read(stringBytes);
        return new String(stringBytes);
    }
}

