/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.updater.steps;

import com.integ.supporter.updater.steps.ProjectStep;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RebootStep
extends ProjectStep {
    private boolean _mustReboot = false;
    private boolean _clearSystemMemory;

    public RebootStep(String name) {
        super(name);
        this._type = "RebootProperty";
        this._mustReboot = true;
    }

    public RebootStep(Element xmlElement) {
        super(xmlElement);
        this._mustReboot = Boolean.valueOf(this.getChildNodeString("MustReboot"));
        System.out.println("MustReboot: " + this._mustReboot);
        this._clearSystemMemory = Boolean.valueOf(this.getChildNodeString("ClearSystemMemory"));
        System.out.println("ClearSystemMemory: " + this._clearSystemMemory);
    }

    public boolean getMustReboot() {
        return this._mustReboot;
    }

    public void setMustReboot(boolean mustReboot) {
        this._mustReboot = mustReboot;
    }

    public boolean getClearSystemMemory() {
        return this._clearSystemMemory;
    }

    public void setClearSystemMemory(boolean clearSystemMemory) {
        this._clearSystemMemory = clearSystemMemory;
    }

    @Override
    public Element getXmlElement(Document document) {
        Element xmlElement = super.getXmlElement(document);
        Element element = document.createElement("MustReboot");
        element.appendChild(document.createTextNode(String.valueOf(this._mustReboot)));
        xmlElement.appendChild(element);
        element = document.createElement("ClearSystemMemory");
        element.appendChild(document.createTextNode(String.valueOf(this._clearSystemMemory)));
        xmlElement.appendChild(element);
        return xmlElement;
    }

    @Override
    public boolean execute() throws Exception {
        Object rebootCommand = "reboot";
        if (this._clearSystemMemory) {
            rebootCommand = (String)rebootCommand + " -a";
        }
        rebootCommand = 3 == this._jniorInfo.getSeries() ? (String)rebootCommand + "\ny" : (String)rebootCommand + " -f";
        if (this._mustReboot) {
            this._logger.info("Must reboot is enabled");
        }
        if (!this._mustReboot && !this._updateProjectExecutor.isRebootNeeded()) {
            this._logger.info("Reboot not needed");
            return true;
        }
        this._logger.info("  sending " + ((String)rebootCommand).replaceAll("\n", "\\n") + " command");
        this._jniorUpdateControlConnection.send((String)rebootCommand + "\r\n");
        this._logger.info("  wait for the telnet connection to disconnect");
        long connectionDisconnectTimeout = System.currentTimeMillis() + 60000L;
        while (this._jniorUpdateControlConnection.isCommandConnectionConnected()) {
            Thread.sleep(1000L);
            if (connectionDisconnectTimeout >= System.currentTimeMillis()) continue;
            this._logger.warning("  telnet client disconnection timeout");
            break;
        }
        this._jniorUpdateControlConnection.disconnect();
        for (int i = 0; i < 3; ++i) {
            Thread.sleep(3 == this._jniorInfo.getSeries() ? 30000L : 10000L);
            try {
                this._logger.info("  reconnecting to telnet client...");
                if (!this._jniorUpdateControlConnection.connect()) continue;
                this._logger.info("  reboot has completed");
                this._updateProjectExecutor.clearRebootFlag();
                break;
            }
            catch (Exception ex) {
                this._logger.severe(String.format("  %s", ex.getMessage()));
                this._jniorUpdateControlConnection.disconnect();
            }
        }
        return true;
    }
}

