/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui.toasts;

import com.integ.janoslib.net.beacon.JniorVersion;
import com.integ.janoslib.utils.PathUtils;
import com.integ.janoslib.utils.ResourceUtils;
import com.integ.supporter.Constants;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.config.GeneralConfig;
import com.integ.supporter.ui.toasts.OptionPaneToast;
import com.integ.supporter.ui.toasts.ToastNotifications;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.security.CodeSource;
import java.util.Map;
import javax.swing.JButton;
import org.json.JSONObject;

public class NewVersionAvailableToast
extends OptionPaneToast {
    private final JSONObject _latestVersionJson;

    public NewVersionAvailableToast(JniorVersion localVersion, JSONObject latestVersionJson) {
        this._latestVersionJson = latestVersionJson;
        try {
            String latestReleaseVersion = latestVersionJson.getString("version").toLowerCase();
            String latestReleaseDate = latestVersionJson.getString("date").toLowerCase();
            super.setMessage(String.format("Update Available!\n\nCurrently running version: %s\nNew version: %s, Released on %s\n\nDo you want to download and launch the new version?", localVersion.toString(), latestReleaseVersion, latestReleaseDate));
            super.setMessageType(1);
            super.setOptionType(0);
            super.setOpaque(false);
            this.addButtons();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addButtons() {
        JButton updateNowButton = new JButton("Update Now");
        updateNowButton.addActionListener(e -> {
            ToastNotifications.getInstance().hide(this);
            try {
                CodeSource codeSource = this.getClass().getProtectionDomain().getCodeSource();
                URL codeSourceLocation = codeSource.getLocation();
                URI executableUri = codeSourceLocation.toURI();
                String executingFilePath = new File(executableUri).getPath();
                String latestReleaseUrl = this._latestVersionJson.getString("url").toLowerCase();
                long latestReleaseTimestamp = this._latestVersionJson.getLong("timestamp");
                File tempUpdaterApplication = new File(PathUtils.combine(Constants.TEMP_DIRECTORY, "JniorSupporterUpdater.jar"));
                ResourceUtils.extractResource("/resources/JniorSupporterUpdater.jar", tempUpdaterApplication);
                CharSequence[] cmdArray = new String[]{"java", "-jar", "\"" + tempUpdaterApplication + "\"", latestReleaseUrl, String.valueOf(latestReleaseTimestamp), executingFilePath};
                String commandString = String.join((CharSequence)", ", cmdArray);
                ProcessBuilder processBuilder = new ProcessBuilder(commandString);
                processBuilder.inheritIO();
                Map<String, String> environment = processBuilder.environment();
                environment.put("JAVA_HOME", System.getProperty("java.home"));
                processBuilder.command((String[])cmdArray).start();
                Thread.sleep(100L);
                System.exit(0);
            }
            catch (Exception ex) {
                NotificationCollection.addError("Error launching for new release", ex);
            }
        });
        JButton maybeLaterButton = new JButton("Maybe Later");
        maybeLaterButton.addActionListener(e -> ToastNotifications.getInstance().hide(this));
        JButton skipThisVersionButton = new JButton("Skip this Version");
        skipThisVersionButton.addActionListener(e -> {
            ToastNotifications.getInstance().hide(this);
            String latestReleaseVersion = this._latestVersionJson.getString("version").toLowerCase();
            GeneralConfig.skipVersion(latestReleaseVersion);
        });
        super.setOptions(new JButton[]{updateNowButton, maybeLaterButton, skipThisVersionButton});
    }
}

