/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui;

import com.integ.supporter.BackgroundAction;
import com.integ.supporter.BackgroundActionTableModel;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.plaf.basic.BasicProgressBarUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class ProgressBarCellRenderer
extends JProgressBar
implements TableCellRenderer {
    protected final Color SUCCESS_COLOR = Color.decode("#c0ffc0");
    protected final Color SELECTION_HIGHLIGHT_COLOR = Color.decode("#2675bf");
    protected final Color PROGRESS_BAR_LIGHT_GRAY = Color.decode("#f0f0f0");

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        BackgroundActionTableModel tableModel = (BackgroundActionTableModel)table.getModel();
        BackgroundAction backgroundAction = tableModel.getBackgroundActionAt(row);
        if (backgroundAction.getResult().hasCompleted()) {
            backgroundAction.setLevel(1);
            Component c = new DefaultTableCellRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                c.setBackground(this.SUCCESS_COLOR);
            }
            return c;
        }
        if (isSelected) {
            this.setProgressBarColors(this.PROGRESS_BAR_LIGHT_GRAY, this.SELECTION_HIGHLIGHT_COLOR);
            this.setProgressBarSelectionColors(Color.BLACK, Color.WHITE);
        } else {
            this.setProgressBarColors(this.PROGRESS_BAR_LIGHT_GRAY, Color.WHITE);
            this.setProgressBarSelectionColors(Color.BLACK, Color.BLACK);
        }
        int percentage = backgroundAction.getPercentage();
        this.setValue(percentage);
        this.setStringPainted(true);
        this.setString((String)value);
        return this;
    }

    private void setProgressBarColors(Color foregroundColor, Color backgroundColor) {
        super.setForeground(foregroundColor);
        super.setBackground(backgroundColor);
    }

    private void setProgressBarSelectionColors(Color foregroundColor, Color backgroundColor) {
        this.setUI(new BasicProgressBarUI(){

            @Override
            protected Color getSelectionForeground() {
                return Color.BLACK;
            }

            @Override
            protected Color getSelectionBackground() {
                return Color.BLACK;
            }
        });
    }
}

