/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.snapshot.library;

import com.integ.supporter.RollingLog;
import com.integ.supporter.snapshot.NotSnapshotFileException;
import com.integ.supporter.snapshot.SnapshotFile;
import com.integ.supporter.snapshot.comparators.CaseIncensitiveStringComparator;
import com.integ.supporter.snapshot.comparators.DateStringComparator;
import com.integ.supporter.snapshot.comparators.FileDateComparator;
import com.integ.supporter.snapshot.library.SnapshotLibraryEvent;
import com.integ.supporter.snapshot.library.SnapshotLibraryListener;
import com.integ.supporter.snapshot.library.SnapshotLibraryNotifier;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SnapshotLibrary {
    private static final Logger LOGGER = RollingLog.getLogger("SnapshotLibrary");
    private static final String IP_PATTERN_STRING = "(?<ipaddress>\\d+\\.\\d+\\.\\d+\\.\\d+)";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("ddMMMyy");
    private static final SimpleDateFormat PATTERN_1_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd_HHmm");
    private static final SimpleDateFormat PATTERN_3_DATE_FORMAT = new SimpleDateFormat("ddMMMyyyy_HHmmss");
    private static final Pattern SNAPSHOT_PATTERN_1 = Pattern.compile("(?<ipaddress>\\d+\\.\\d+\\.\\d+\\.\\d+)_(?<date>\\d{8}_\\d{4}).zip");
    private static final Pattern SNAPSHOT_PATTERN_3 = Pattern.compile("(?<serial>\\d{9})_(?<hostname>[\\w\\d-_#]*)[@_](?<date>\\d{2}\\w{3}\\d{4}_\\d{6}).zip");
    private static final Pattern SNAPSHOT_PATTERN_2 = Pattern.compile("(?<hostname>[\\w\\d-]*)@(?<date>\\d{2}\\w{3}\\d{4}).zip");
    private static final Pattern SNAPSHOT_PATTERN_4 = Pattern.compile("jr(?<serial>\\d{9})@(?<date>\\d{2}\\w{3}\\d{4}).zip");
    private final Hashtable<String, ArrayList<File>> _snapshotsBySerial = new Hashtable();
    private final Hashtable<String, ArrayList<File>> _snapshotsByHostname = new Hashtable();
    private final Hashtable<String, ArrayList<File>> _snapshotsByDate = new Hashtable();
    private final ArrayList<File> _allSnapshots = new ArrayList();
    private final File _snapshotsDirectory;
    private final SnapshotLibraryNotifier _snapshotLibraryNotifier = new SnapshotLibraryNotifier();
    private long _lastModifiedTime = 0L;
    private int _errors = 0;
    private int _notSnapshotFileCount = 0;

    public SnapshotLibrary(final String libraryPath) {
        this._snapshotsDirectory = new File(libraryPath);
        Thread thd = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(5000L);
                            if (SnapshotLibrary.this._lastModifiedTime == SnapshotLibrary.this._snapshotsDirectory.lastModified()) continue;
                            SnapshotLibrary.this._lastModifiedTime = SnapshotLibrary.this._snapshotsDirectory.lastModified();
                            SnapshotLibrary.this.loadLibraryFolder(libraryPath);
                            SnapshotLibrary.this._snapshotLibraryNotifier.notifySnapshotLibraryLoaded(new SnapshotLibraryEvent(this));
                            System.out.println("_errors = " + SnapshotLibrary.this._errors);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.severe(ex.getMessage());
                        continue;
                    }
                    break;
                }
            }
        }, this.getClass().getName());
        thd.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLibraryFolder(String libraryPath) {
        LOGGER.info("Loading Snapshot Library: " + libraryPath);
        long start = System.currentTimeMillis();
        Hashtable<String, ArrayList<File>> hashtable = this._snapshotsBySerial;
        synchronized (hashtable) {
            this._snapshotsBySerial.clear();
        }
        hashtable = this._snapshotsByHostname;
        synchronized (hashtable) {
            this._snapshotsByHostname.clear();
        }
        hashtable = this._snapshotsByDate;
        synchronized (hashtable) {
            this._snapshotsByDate.clear();
        }
        ArrayList<File> filesList = new ArrayList<File>();
        this.loadLibraryFolder(libraryPath, 0, filesList);
        filesList.sort(new FileDateComparator());
        for (File file : filesList) {
            this.addSnapshotFile(file);
        }
        long elapsedTime = System.currentTimeMillis() - start;
        LOGGER.info(String.format("Snapshot Library loaded successfully in %.3f seconds", (double)elapsedTime / 1000.0));
    }

    private void loadLibraryFolder(String libraryPath, int levels, ArrayList<File> filesList) {
        try {
            File[] files = this._snapshotsDirectory.listFiles();
            if (files == null) {
                return;
            }
            for (File file : files) {
                if (file.isDirectory()) {
                    this.loadLibraryFolder(file.getPath(), levels - 1, filesList);
                    continue;
                }
                if (!file.getPath().endsWith(".zip")) continue;
                filesList.add(file);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String[] getSerialNumbers() {
        Enumeration<String> enumeration = this._snapshotsBySerial.keys();
        ArrayList<String> list = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
        String[] serialNumberStrings = new String[this._snapshotsBySerial.size()];
        Comparator<String> c = Comparator.comparing(String::toString);
        list.sort(c);
        return list.toArray(serialNumberStrings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] getFilesForSerialNumber(String serialNumberString) {
        Hashtable<String, ArrayList<File>> hashtable = this._snapshotsBySerial;
        synchronized (hashtable) {
            ArrayList<File> filesList = this.getSnapshotsFor(this._snapshotsBySerial, serialNumberString);
            if (null != filesList) {
                filesList.sort(new FileDateComparator());
                File[] files = new File[filesList.size()];
                return filesList.toArray(files);
            }
            return new File[0];
        }
    }

    public String[] getHostnames() {
        Enumeration<String> enumeration = this._snapshotsByHostname.keys();
        ArrayList<Object> list = new ArrayList<Object>();
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
        String[] hostnameStrings = new String[this._snapshotsBySerial.size()];
        list.sort(new CaseIncensitiveStringComparator());
        return list.toArray(hostnameStrings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] getFilesForHostname(String hostnameString) {
        Hashtable<String, ArrayList<File>> hashtable = this._snapshotsByHostname;
        synchronized (hashtable) {
            ArrayList<File> filesList = this.getSnapshotsFor(this._snapshotsByHostname, hostnameString);
            if (null == filesList) {
                LOGGER.severe("filelist for " + hostnameString + " is null");
            }
            try {
                filesList.sort(new FileDateComparator());
                File[] files = new File[filesList.size()];
                return filesList.toArray(files);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
    }

    public String[] getDates() {
        Enumeration<String> enumeration = this._snapshotsByDate.keys();
        ArrayList<String> list = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
        String[] dateStrings = new String[this._snapshotsByDate.size()];
        list.sort(new DateStringComparator());
        Collections.reverse(list);
        return list.toArray(dateStrings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] getFilesForDate(String dateString) {
        Hashtable<String, ArrayList<File>> hashtable = this._snapshotsByDate;
        synchronized (hashtable) {
            ArrayList<File> filesList = this.getSnapshotsFor(this._snapshotsByDate, dateString);
            if (null == filesList) {
                LOGGER.severe("filelist for " + dateString + " is null");
            }
            filesList.sort(new FileDateComparator());
            File[] files = new File[filesList.size()];
            return filesList.toArray(files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] getAllSnapshotFiles() {
        ArrayList<File> arrayList = this._allSnapshots;
        synchronized (arrayList) {
            this._allSnapshots.sort(new FileDateComparator());
            File[] files = new File[this._allSnapshots.size()];
            return this._allSnapshots.toArray(files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSnapshotFile(File file) {
        SnapshotLibrary snapshotLibrary = this;
        synchronized (snapshotLibrary) {
            try {
                SnapshotFile snapshotFile = new SnapshotFile(file);
                String fileName = snapshotFile.getName();
                Matcher matcher = SNAPSHOT_PATTERN_1.matcher(fileName);
                if (matcher.find()) {
                    String ipAddress = matcher.group("ipaddress");
                    String dateString = matcher.group("date");
                    Date date = PATTERN_1_DATE_FORMAT.parse(dateString);
                    this.updateSnapshotsForDate(file, DATE_FORMAT.format(date));
                } else {
                    String serialNumberString;
                    matcher = SNAPSHOT_PATTERN_3.matcher(fileName);
                    if (matcher.find()) {
                        serialNumberString = matcher.group("serial");
                        this.updateSnapshotsForSerial(file, serialNumberString);
                        String hostnameString = matcher.group("hostname");
                        this.updateSnapshotsForHostname(file, hostnameString);
                        String dateString = matcher.group("date");
                        Date date = PATTERN_3_DATE_FORMAT.parse(dateString);
                        this.updateSnapshotsForDate(file, DATE_FORMAT.format(date));
                    } else {
                        matcher = SNAPSHOT_PATTERN_4.matcher(fileName);
                        if (matcher.find()) {
                            serialNumberString = matcher.group("serial");
                            this.updateSnapshotsForSerial(file, serialNumberString);
                            String dateString = matcher.group("date");
                            Date date = PATTERN_3_DATE_FORMAT.parse(dateString);
                            this.updateSnapshotsForDate(file, DATE_FORMAT.format(date));
                        } else {
                            matcher = SNAPSHOT_PATTERN_2.matcher(fileName);
                            if (matcher.find()) {
                                String hostnameString = matcher.group("hostname");
                                this.updateSnapshotsForHostname(file, hostnameString);
                                String dateString = matcher.group("date");
                                Date date = DATE_FORMAT.parse(dateString);
                                this.updateSnapshotsForDate(file, DATE_FORMAT.format(date));
                            }
                        }
                    }
                }
                ArrayList<File> arrayList = this._allSnapshots;
                synchronized (arrayList) {
                    this._allSnapshots.add(file);
                }
                this._snapshotLibraryNotifier.notifySnapshotFileLoaded(new SnapshotLibraryEvent(this, snapshotFile));
                LOGGER.info("snapshot library loaded " + file.getPath());
            }
            catch (NotSnapshotFileException ex) {
                ++this._notSnapshotFileCount;
                ++this._errors;
                System.out.println("_errors = " + this._errors);
            }
            catch (Exception ex) {
                ArrayList<File> arrayList = this._allSnapshots;
                synchronized (arrayList) {
                    this._allSnapshots.add(file);
                }
                LOGGER.severe("error laoding snapshot file: " + ex.toString());
                ++this._errors;
                System.out.println("_errors = " + this._errors);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<File> getSnapshotsFor(Hashtable<String, ArrayList<File>> map, String key) {
        Hashtable<String, ArrayList<File>> hashtable = map;
        synchronized (hashtable) {
            if (null == key) {
                throw new RuntimeException("Unable to get snapshot.  NULL key");
            }
            if (!map.containsKey(key)) {
                map.put(key, new ArrayList());
                LOGGER.info("created " + map + "  arraylist for " + key);
                LOGGER.info(map + " has " + map.size() + " elements");
            }
            return map.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSnapshotsForSerial(File file, String serialString) {
        Hashtable<String, ArrayList<File>> hashtable = this._snapshotsBySerial;
        synchronized (hashtable) {
            ArrayList<File> snapshotFilesForSerial = this.getSnapshotsFor(this._snapshotsBySerial, serialString);
            snapshotFilesForSerial.add(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSnapshotsForHostname(File file, String hostnameString) {
        Hashtable<String, ArrayList<File>> hashtable = this._snapshotsByHostname;
        synchronized (hashtable) {
            ArrayList<File> snapshotFilesForHostname = this.getSnapshotsFor(this._snapshotsByHostname, hostnameString);
            snapshotFilesForHostname.add(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSnapshotsForDate(File file, String dateString) {
        Hashtable<String, ArrayList<File>> hashtable = this._snapshotsByDate;
        synchronized (hashtable) {
            if (null == dateString) {
                throw new RuntimeException("Unable to find date string");
            }
            ArrayList<File> snapshotFilesForDate = this.getSnapshotsFor(this._snapshotsByDate, dateString);
            snapshotFilesForDate.add(file);
        }
    }

    public void addEventListener(SnapshotLibraryListener snapshotLibraryListener) {
        this._snapshotLibraryNotifier.addEventListener(snapshotLibraryListener);
    }

    public void removeEventListener(SnapshotLibraryListener snapshotLibraryListener) {
        this._snapshotLibraryNotifier.removeEventListener(snapshotLibraryListener);
    }
}

