/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.jrget;

import com.formdev.flatlaf.extras.FlatSVGIcon;
import com.integ.supporter.jrget.models.ReleaseUpdateNode;
import com.integ.supporter.ui.ColorConstants;
import com.integ.supporter.ui.jtreetable.JTreeTable;
import com.integ.supporter.ui.jtreetable.TreeTableModelAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class ListingTreeRenderer
extends Component
implements TableCellRenderer {
    private static final DefaultTableCellRenderer DEFAULT_RENDERER = new DefaultTableCellRenderer();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component c = DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        DefaultTableCellRenderer dtcr = (DefaultTableCellRenderer)c;
        try {
            if (3 == column) {
                c.setFont(new Font("Courier New", 0, 12));
            }
            dtcr.setHorizontalAlignment(2);
            if (2 <= column) {
                dtcr.setHorizontalAlignment(4);
            }
            c.setFont(c.getFont().deriveFont(0));
            c.setForeground(Color.black);
            dtcr.setIcon(null);
            Class<?> s = ((JTreeTable)table).getModel().getClass();
            TreeTableModelAdapter tableModel = (TreeTableModelAdapter)((JTreeTable)table).getModel();
            Object node = tableModel.nodeForRow(row);
            if (null != node && node instanceof ReleaseUpdateNode) {
                ReleaseUpdateNode versionInfoNode = (ReleaseUpdateNode)node;
                String localFilename = versionInfoNode.getLocalFilename();
                boolean localFileExists = new File(localFilename).exists();
                if (localFileExists) {
                    if (1 == column) {
                        FlatSVGIcon svgIcon = new FlatSVGIcon("resources/check.svg", 12, 12);
                        FlatSVGIcon.ColorFilter grayColorFilter = new FlatSVGIcon.ColorFilter();
                        grayColorFilter.add(Color.BLACK, ColorConstants.SUCCESS_COLOR);
                        svgIcon.setColorFilter(grayColorFilter);
                        dtcr.setIcon(svgIcon);
                        dtcr.setIconTextGap(8);
                        dtcr.setHorizontalTextPosition(4);
                    }
                } else if (1 == column) {
                    FlatSVGIcon svgIcon = new FlatSVGIcon("resources/download.svg", 12, 12);
                    FlatSVGIcon.ColorFilter grayColorFilter = new FlatSVGIcon.ColorFilter();
                    grayColorFilter.add(Color.BLACK, ColorConstants.NOTIFICATION_COLOR);
                    svgIcon.setColorFilter(grayColorFilter);
                    dtcr.setIcon(svgIcon);
                    dtcr.setIconTextGap(8);
                    dtcr.setHorizontalTextPosition(4);
                }
            }
            if (isSelected) {
                c.setBackground(table.getSelectionBackground());
                c.setForeground(Color.WHITE);
            } else {
                c.setBackground(Color.WHITE);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return c;
    }
}

