/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.jrget;

import com.formdev.flatlaf.ui.FlatTabbedPaneUI;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.janoslib.utils.FileUtils;
import com.integ.supporter.CollectionModifiedEvent;
import com.integ.supporter.Constants;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.RollingLog;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.jrget.HttpFile;
import com.integ.supporter.jrget.ListingTreeRenderer;
import com.integ.supporter.jrget.UpdateProjectFileChooser;
import com.integ.supporter.jrget.models.LocalUpdateNode;
import com.integ.supporter.jrget.models.ReleaseUpdateNode;
import com.integ.supporter.jrget.models.UpdatesTreeTableModel;
import com.integ.supporter.snapshot.DefaultMutableTreeNode2;
import com.integ.supporter.snapshot.menus.SnapshotPopupMenu;
import com.integ.supporter.ui.CollectionModifiedAdapter;
import com.integ.supporter.ui.OutputTab;
import com.integ.supporter.ui.TextPaneLog;
import com.integ.supporter.ui.jtreetable.JTreeTable;
import com.integ.supporter.updater.OpenedUpdateProjects;
import com.integ.supporter.updater.UpdateProjectFile;
import com.integ.supporter.updater.UpdateProjectTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class JrGetTab
extends JPanel {
    protected static final int ICON_SIZE = 12;
    private static final float SCALE = 0.0234375f;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MM-dd-yy HH:mm:ss");
    private static final JrGetTab Instance = new JrGetTab();
    private JTreeTable _treeTable;
    private final Logger _logger;
    private final DefaultMutableTreeNode _rootNode = new DefaultMutableTreeNode2("root");
    private final DefaultMutableTreeNode _officialUpdateProjectsRootNode = new DefaultMutableTreeNode2("Official Update Pojects");
    private final DefaultTreeModel _model = new DefaultTreeModel(this._rootNode);
    private boolean _openedTabsMessageShown = false;
    private JButton createNewProjectMenuItem;
    private JSplitPane horizontalSplitPane;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JToolBar jToolBar1;
    private JTabbedPane jniorsTabbedPane;
    private JButton openUpdateProjectButton;
    private JButton openUpdatesDirectoryButton;
    private JTabbedPane updateProjectsTabbedPane;
    private JTree updateProjectsTree;
    private JScrollPane updateProjectsTreeScrollPane;
    private JSplitPane verticalSplitPane;

    public static JrGetTab getInstance() {
        return Instance;
    }

    private JrGetTab() {
        this._logger = RollingLog.getLogger("Updates");
        TextPaneLog textPaneLog = new TextPaneLog(OutputTab.getInstance().getTextPane());
        this._logger.addHandler(textPaneLog);
        this.initComponents();
        this.installClosableTabbedPaneUI();
        this.horizontalSplitPane.setRightComponent(null);
        this.horizontalSplitPane.setDividerSize(0);
        this.shouldEnableOpenButton();
        OpenedUpdateProjects.getInstance().addCollectionListener(new CollectionModifiedAdapter(){

            @Override
            public void itemAdded(CollectionModifiedEvent e, Object item) {
                UpdateProjectFile updateProjectFile = (UpdateProjectFile)item;
                String title = JrGetTab.this.getUpdateProjectTitle(updateProjectFile);
                UpdateProjectTab updateTab = new UpdateProjectTab(updateProjectFile);
                JrGetTab.this.updateProjectsTabbedPane.addTab(title, updateTab);
                JrGetTab.this.updateProjectsTabbedPane.setSelectedComponent(updateTab);
            }

            @Override
            public void itemRemoved(CollectionModifiedEvent e, Object item) {
                UpdateProjectFile updateProjectFile = (UpdateProjectFile)item;
                String title = JrGetTab.this.getUpdateProjectTitle(updateProjectFile);
                int tabIndex = -1;
                for (int i = 0; i < JrGetTab.this.updateProjectsTabbedPane.getTabCount(); ++i) {
                    if (!JrGetTab.this.updateProjectsTabbedPane.getTitleAt(i).endsWith(title)) continue;
                    tabIndex = i;
                }
                if (-1 != tabIndex) {
                    JrGetTab.this.updateProjectsTabbedPane.removeTabAt(tabIndex);
                }
            }
        });
        this.addTreeTable();
    }

    private String getUpdateProjectTitle(UpdateProjectFile updateProjectFile) {
        if (null != updateProjectFile.getTitle()) {
            return updateProjectFile.getTitle();
        }
        return String.format("%s", updateProjectFile.getFile().getName());
    }

    private void shouldEnableOpenButton() {
        try {
            boolean enableButton = false;
            TreePath[] selectedPaths = this.updateProjectsTree.getSelectionPaths();
            if (null != selectedPaths) {
                for (TreePath treePath : selectedPaths) {
                    Object lastPathComponent = treePath.getLastPathComponent();
                    if (lastPathComponent instanceof ReleaseUpdateNode) {
                        enableButton |= true;
                        continue;
                    }
                    if (!(lastPathComponent instanceof LocalUpdateNode)) continue;
                    LocalUpdateNode localUpdateProjectTreeNode = (LocalUpdateNode)lastPathComponent;
                    enableButton |= localUpdateProjectTreeNode.getFile().exists();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.openUpdateProjectButton = new JButton();
        this.openUpdatesDirectoryButton = new JButton();
        this.createNewProjectMenuItem = new JButton();
        this.verticalSplitPane = new JSplitPane();
        this.horizontalSplitPane = new JSplitPane();
        this.updateProjectsTreeScrollPane = new JScrollPane();
        this.updateProjectsTree = new JTree(new String[0]);
        this.jPanel3 = new JPanel();
        this.jniorsTabbedPane = new JTabbedPane();
        this.updateProjectsTabbedPane = new JTabbedPane();
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jToolBar1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jToolBar1.setRollover(true);
        this.openUpdateProjectButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/folder_page.png")));
        this.openUpdateProjectButton.setText("Open Update Project...");
        this.openUpdateProjectButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.openUpdateProjectButton.setFocusable(false);
        this.openUpdateProjectButton.setVerticalTextPosition(3);
        this.openUpdateProjectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JrGetTab.this.openUpdateProjectButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.openUpdateProjectButton);
        this.openUpdatesDirectoryButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/drive.png")));
        this.openUpdatesDirectoryButton.setText("Open Updates Directory");
        this.openUpdatesDirectoryButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.openUpdatesDirectoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JrGetTab.this.openUpdatesDirectoryButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.openUpdatesDirectoryButton);
        this.createNewProjectMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/resources/add.png")));
        this.createNewProjectMenuItem.setText("Create New Project");
        this.createNewProjectMenuItem.setFocusable(false);
        this.createNewProjectMenuItem.setHorizontalTextPosition(4);
        this.createNewProjectMenuItem.setVerticalTextPosition(3);
        this.createNewProjectMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JrGetTab.this.createNewProjectMenuItemActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.createNewProjectMenuItem);
        this.jPanel1.add((Component)this.jToolBar1, "Center");
        this.add((Component)this.jPanel1, "First");
        this.verticalSplitPane.setOrientation(0);
        this.horizontalSplitPane.setMinimumSize(new Dimension(115, 300));
        this.updateProjectsTreeScrollPane.setPreferredSize(new Dimension(400, 322));
        this.updateProjectsTree.setMaximumSize(null);
        this.updateProjectsTree.setPreferredSize(null);
        this.updateProjectsTree.setRequestFocusEnabled(false);
        this.updateProjectsTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JrGetTab.this.updateProjectsTreeMouseClicked(evt);
            }
        });
        this.updateProjectsTreeScrollPane.setViewportView(this.updateProjectsTree);
        this.horizontalSplitPane.setLeftComponent(this.updateProjectsTreeScrollPane);
        this.verticalSplitPane.setTopComponent(this.horizontalSplitPane);
        this.jPanel3.setLayout(new BorderLayout());
        this.jniorsTabbedPane.setTabPlacement(4);
        this.jPanel3.add((Component)this.jniorsTabbedPane, "Center");
        this.updateProjectsTabbedPane.setMinimumSize(new Dimension(0, 400));
        this.jPanel3.add((Component)this.updateProjectsTabbedPane, "Center");
        this.verticalSplitPane.setBottomComponent(this.jPanel3);
        this.add((Component)this.verticalSplitPane, "Center");
    }

    private void openUpdatesDirectoryButtonActionPerformed(ActionEvent evt) {
        File directoryToOpen = new File(Constants.UPDATE_PROJECTS_DIRECTORY);
        try {
            Desktop desktop = Desktop.getDesktop();
            desktop.open(directoryToOpen);
        }
        catch (IOException | IllegalArgumentException ex) {
            NotificationCollection.addError(String.format("Unable to open the %s directory", directoryToOpen.getPath()));
            Logger.getLogger(SnapshotPopupMenu.class.getName()).severe(ExceptionUtils.getStackTrace(ex));
        }
    }

    private void updateProjectsTreeMouseClicked(MouseEvent evt) {
        if (2 == evt.getClickCount()) {
            TreePath path = this.updateProjectsTree.getPathForLocation(evt.getX(), evt.getY());
            this.openTreePath(path);
        }
    }

    private void createNewProjectMenuItemActionPerformed(ActionEvent evt) {
        try {
            SupporterMain.getMainFrame().showUpdatesPane();
            UpdateProjectFile updateProjectFile = new UpdateProjectFile();
            updateProjectFile.setTitle("New Update Project");
            OpenedUpdateProjects.getInstance().add(updateProjectFile);
        }
        catch (Exception ex) {
            String stacktrace = ExceptionUtils.getStackTrace(ex);
            Logger.getGlobal().severe(stacktrace);
            NotificationCollection.addError(ex);
        }
    }

    private void openUpdateProjectButtonActionPerformed(ActionEvent evt) {
        File selectedFile = this.promptForUpdateProjectFile();
        if (null != selectedFile && selectedFile.exists()) {
            try {
                UpdateProjectFile updateProjectFile = new UpdateProjectFile(selectedFile);
                this.openUpdateProject(updateProjectFile);
            }
            catch (Exception ex) {
                NotificationCollection.addError("Error Opening Update Project", ex);
            }
        }
    }

    private boolean openTreePath(TreePath treePath) {
        if (null == treePath) {
            return false;
        }
        Object node = treePath.getLastPathComponent();
        try {
            boolean localFileFound = false;
            File localFile = null;
            if (node instanceof ReleaseUpdateNode) {
                boolean md5Match;
                ReleaseUpdateNode versionInfoNode = (ReleaseUpdateNode)node;
                String localFilename = versionInfoNode.getLocalFilename();
                String remoteMd5 = versionInfoNode.getMd5();
                localFile = new File(localFilename);
                localFileFound = localFile.exists();
                boolean bl = md5Match = localFileFound && FileUtils.getFileMd5(localFilename).equalsIgnoreCase(remoteMd5);
                if (!localFileFound || !md5Match) {
                    HttpFile httpFile = new HttpFile(versionInfoNode.getUrl());
                    if (httpFile.download(localFilename)) {
                        try {
                            Date date = versionInfoNode.getReleaseDate();
                            localFile.setLastModified(date.getTime());
                            this._logger.info(versionInfoNode + " update project downloaded");
                            NotificationCollection.addSuccess(versionInfoNode + " update project downloaded");
                        }
                        catch (Exception ex) {
                            Logger.getLogger(JrGetTab.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    } else {
                        String message = String.format("Unable to download %s.  Please make sure you have a valid connection to the Internet.", versionInfoNode.getUrl());
                        NotificationCollection.addError(message);
                    }
                }
                localFileFound = localFile.exists();
            } else if (node instanceof LocalUpdateNode) {
                LocalUpdateNode defaultMutableTreeNode = (LocalUpdateNode)node;
                localFile = defaultMutableTreeNode.getFile();
                localFileFound = localFile.exists();
            }
            if (localFileFound) {
                try {
                    UpdateProjectFile updateProjectFile = new UpdateProjectFile(localFile);
                    this.openUpdateProject(updateProjectFile);
                    return true;
                }
                catch (Exception ex) {
                    Logger.getLogger(JrGetTab.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        catch (Exception ex) {
            NotificationCollection.addError(String.format("Error opening '%s'", treePath));
        }
        return false;
    }

    private File promptForUpdateProjectFile() {
        try {
            UpdateProjectFileChooser fileChooser = new UpdateProjectFileChooser();
            int option = fileChooser.showOpenDialog(SupporterMain.getMainFrame());
            if (option == 0) {
                File file = fileChooser.getSelectedFile();
                return file;
            }
        }
        catch (Exception ex) {
            NotificationCollection.addError("Error prompting for update projects", ex);
        }
        return null;
    }

    private void openUpdateProject(UpdateProjectFile updateProjectFile) throws IOException {
        try {
            for (Component component : this.updateProjectsTabbedPane.getComponents()) {
                if (!(component instanceof UpdateProjectTab)) continue;
                UpdateProjectTab updateProjectTab = (UpdateProjectTab)component;
                if (!updateProjectFile.getFilePath().equalsIgnoreCase(updateProjectTab.getUpdateProjectFile().getFilePath())) continue;
                JOptionPane.showMessageDialog(SupporterMain.getMainFrame(), "The selected update project is already open.", "Already Open", 1);
                this.updateProjectsTabbedPane.setSelectedComponent(component);
                return;
            }
            if (!OpenedUpdateProjects.getInstance().contains(updateProjectFile)) {
                updateProjectFile.load();
                OpenedUpdateProjects.getInstance().add(updateProjectFile);
            }
        }
        catch (Exception ex) {
            NotificationCollection.addError("Error Opening " + updateProjectFile.getFilePath() + " Update Project", ex);
        }
    }

    private void installClosableTabbedPaneUI() {
        FlatTabbedPaneUI flatTabbedPaneUI = new FlatTabbedPaneUI();
        this.updateProjectsTabbedPane.setUI(flatTabbedPaneUI);
        this.updateProjectsTabbedPane.putClientProperty("JTabbedPane.tabClosable", true);
        this.updateProjectsTabbedPane.putClientProperty("JTabbedPane.tabCloseToolTipText", "Close");
        this.updateProjectsTabbedPane.putClientProperty("JTabbedPane.tabCloseCallback", (tabPane, tabIndex) -> {
            UpdateProjectTab updateTab = (UpdateProjectTab)tabPane.getComponentAt((int)tabIndex);
            updateTab.closeTab();
        });
    }

    private void addTreeTable() {
        try {
            UpdatesTreeTableModel updatesTreeTableModel = new UpdatesTreeTableModel();
            updatesTreeTableModel.addTreeModelListener(new TreeModelListener(){

                @Override
                public void treeNodesChanged(TreeModelEvent e) {
                }

                @Override
                public void treeNodesInserted(TreeModelEvent e) {
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent e) {
                }

                @Override
                public void treeStructureChanged(TreeModelEvent e) {
                    JrGetTab.this._treeTable.updateUI();
                    JrGetTab.this._treeTable.expandRow(1);
                    JrGetTab.this._treeTable.expandRow(0);
                }
            });
            this._treeTable = new JTreeTable(updatesTreeTableModel);
            this._treeTable.setShowRoot(false);
            this._treeTable.setRowSelectionAllowed(true);
            this._treeTable.getTableHeader().setReorderingAllowed(false);
            this._treeTable.setCellRenderer(new ListingTreeRenderer());
            this._treeTable.expandRow(0);
            this._treeTable.enableExpansion();
            this._treeTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (2 == e.getClickCount()) {
                        TreePath path = JrGetTab.this._treeTable.getPathForLocation(e.getX(), e.getY());
                        JrGetTab.this.openTreePath(path);
                    }
                }
            });
            this._treeTable.setDragEnabled(true);
            this._treeTable.setTransferHandler(new TransferHandler(){
                private File file;

                @Override
                public int getSourceActions(JComponent c) {
                    return 1;
                }

                @Override
                protected Transferable createTransferable(JComponent c) {
                    JTreeTable treeTable = (JTreeTable)c;
                    int selectedCount = treeTable.getSelectionModel().getSelectedItemsCount();
                    int i = treeTable.getSelectionModel().getMinSelectionIndex();
                    JTree tree = treeTable.getTree();
                    TreePath[] treePaths = treeTable.getSelectionPaths();
                    TreePath p = ((JTreeTable)c).getSelectionPath();
                    if (null == p) {
                        return null;
                    }
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)p.getLastPathComponent();
                    if (node instanceof LocalUpdateNode) {
                        LocalUpdateNode defaultMutableTreeNode = (LocalUpdateNode)node;
                        this.file = defaultMutableTreeNode.getFile();
                    }
                    if (null != this.file) {
                        return new Transferable(){

                            @Override
                            public Object getTransferData(DataFlavor flavor) {
                                return Arrays.asList(file);
                            }

                            @Override
                            public DataFlavor[] getTransferDataFlavors() {
                                return new DataFlavor[]{DataFlavor.javaFileListFlavor};
                            }

                            @Override
                            public boolean isDataFlavorSupported(DataFlavor flavor) {
                                return flavor.equals(DataFlavor.javaFileListFlavor);
                            }
                        };
                    }
                    return null;
                }

                @Override
                protected void exportDone(JComponent c, Transferable d, int a) {
                }
            });
            this._treeTable.getSelectionModel().setSelectionMode(1);
            this._treeTable.expandsSelectedPath(true);
            this._treeTable.getColumnModel().getColumn(0).setPreferredWidth(350);
            this._treeTable.getColumnModel().getColumn(1).setPreferredWidth(125);
            this._treeTable.getColumnModel().getColumn(2).setPreferredWidth(200);
            this._treeTable.getColumnModel().getColumn(3).setPreferredWidth(250);
            this._treeTable.setAutoResizeMode(0);
            this.horizontalSplitPane.setLeftComponent(new JScrollPane(this._treeTable));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

