/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.config;

import com.integ.supporter.Constants;
import com.integ.supporter.config.JsonConfigFile;
import java.io.File;
import org.json.JSONArray;
import org.json.JSONObject;

public class BackupServicesConfig
extends JsonConfigFile {
    private static final File BACKUP_SERVICES_CONFIG_JSON_FILE = new File(Constants.CONFIG_DIRECTORY + "BackupServicesConfig.json");
    private static final BackupServicesConfig INSTANCE = new BackupServicesConfig();

    public static BackupServicesConfig getInstance() {
        return INSTANCE;
    }

    private BackupServicesConfig() {
        super(BACKUP_SERVICES_CONFIG_JSON_FILE);
    }

    private JSONObject getExcludesJsonObject() {
        if (!this._configJson.has("Excludes")) {
            this._configJson.put("Excludes", new JSONObject());
            this.changed();
        }
        JSONObject jsonObject = this._configJson.getJSONObject("Excludes");
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEnabled() {
        BackupServicesConfig backupServicesConfig = INSTANCE;
        synchronized (backupServicesConfig) {
            INSTANCE.shouldReloadConfig();
            if (!BackupServicesConfig.INSTANCE._configJson.has("Enabled")) {
                BackupServicesConfig.setEnabled(false);
            }
            boolean enabled = BackupServicesConfig.INSTANCE._configJson.getBoolean("Enabled");
            return enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setEnabled(boolean isEnabled) {
        BackupServicesConfig backupServicesConfig = INSTANCE;
        synchronized (backupServicesConfig) {
            INSTANCE.shouldReloadConfig();
            BackupServicesConfig.INSTANCE._configJson.put("Enabled", isEnabled);
            INSTANCE.changed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getBackupIntervalInHours() {
        BackupServicesConfig backupServicesConfig = INSTANCE;
        synchronized (backupServicesConfig) {
            INSTANCE.shouldReloadConfig();
            if (!BackupServicesConfig.INSTANCE._configJson.has("BackupIntervalInHours")) {
                BackupServicesConfig.INSTANCE._configJson.put("BackupIntervalInHours", 24);
            }
            double backupIntervalInHours = BackupServicesConfig.INSTANCE._configJson.getDouble("BackupIntervalInHours");
            return backupIntervalInHours;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBackupIntervalInHours(double hours) {
        BackupServicesConfig backupServicesConfig = INSTANCE;
        synchronized (backupServicesConfig) {
            INSTANCE.shouldReloadConfig();
            BackupServicesConfig.INSTANCE._configJson.put("BackupIntervalInHours", hours);
            INSTANCE.changed();
        }
    }

    public static int[] getExcludedSerialNumbersArray() {
        BackupServicesConfig backupServicesConfig = INSTANCE;
        synchronized (backupServicesConfig) {
            JSONObject excludesJson = BackupServicesConfig.getInstance().getExcludesJsonObject();
            try {
                if (!excludesJson.has("SerialNumbers")) {
                    int[] intArray = new int[]{};
                    excludesJson.put("SerialNumbers", intArray);
                    System.out.println("_jsonConfig: " + BackupServicesConfig.INSTANCE._configJson);
                    INSTANCE.changed();
                    return intArray;
                }
                JSONArray jsonArray = excludesJson.optJSONArray("SerialNumbers");
                if (null == jsonArray) {
                    jsonArray = new JSONArray();
                }
                int[] intArray = new int[jsonArray.length()];
                for (int i = 0; i < intArray.length; ++i) {
                    intArray[i] = jsonArray.getInt(i);
                }
                return intArray;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
    }

    public static String[] getExcludedIpAddressArray() {
        BackupServicesConfig backupServicesConfig = INSTANCE;
        synchronized (backupServicesConfig) {
            JSONObject excludesJson = BackupServicesConfig.getInstance().getExcludesJsonObject();
            try {
                if (!excludesJson.has("IpAddresses")) {
                    String[] stringArray = new String[]{};
                    excludesJson.put("IpAddresses", stringArray);
                    System.out.println("_jsonConfig: " + BackupServicesConfig.INSTANCE._configJson);
                    INSTANCE.changed();
                    return stringArray;
                }
                JSONArray jsonArray = excludesJson.optJSONArray("IpAddresses");
                if (null == jsonArray) {
                    jsonArray = new JSONArray();
                }
                String[] stringArray = new String[jsonArray.length()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = jsonArray.getString(i);
                }
                return stringArray;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
    }

    public static void addExcludedIpAddress(String ipAddress) {
    }

    public static String[] getExcludedHostnameArray() {
        BackupServicesConfig backupServicesConfig = INSTANCE;
        synchronized (backupServicesConfig) {
            JSONObject excludesJson = BackupServicesConfig.getInstance().getExcludesJsonObject();
            try {
                JSONArray jsonArray;
                if (!excludesJson.has("Hostnames")) {
                    excludesJson.put("Hostnames", new String[0]);
                    INSTANCE.changed();
                }
                if (null == (jsonArray = excludesJson.optJSONArray("Hostnames"))) {
                    jsonArray = new JSONArray();
                }
                String[] stringArray = new String[jsonArray.length()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = jsonArray.getString(i);
                }
                return stringArray;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
    }
}

