/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.beacon;

import com.integ.janoslib.net.beacon.Beacon;
import com.integ.janoslib.net.beacon.BeaconListener;
import com.integ.janoslib.net.beacon.JniorCollection;
import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.supporter.JniorAnnouncementStore;
import com.integ.supporter.JniorItem;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.beacon.BeaconTab;
import com.integ.supporter.beacon.BeaconTableColumnModel;
import com.integ.supporter.beacon.HostnameChangedListener;
import com.integ.supporter.beacon.StatusChangedListener;
import com.integ.supporter.config.GeneralConfig;
import com.integ.supporter.ui.toasts.MessageToast;
import com.integ.supporter.ui.toasts.ToastNotifications;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class BeaconTableModel
extends AbstractTableModel
implements BeaconListener {
    public static final int SERIAL_INDEX = 0;
    public static final int HOSTNAME_INDEX = 1;
    public static final int IPADDRESS_INDEX = 2;
    public static final int OSVERSION_INDEX = 3;
    public static final int MODEL_INDEX = 4;
    public static final int SUBNET_INDEX = 5;
    public static final int MACADDRESS_INDEX = 6;
    public static final int BOOTTIME_INDEX = 7;
    public static final int LAST_ANNOUNCED_INDEX = 8;
    public static final int MESSAGE_INDEX = 9;
    public static final int STATUS_INDEX = 10;
    private final ArrayList<JniorItem> _rowData = new ArrayList();
    private final Hashtable<Integer, JniorItem> _jniorsBySerial = new Hashtable();
    private final ArrayList<JniorItem> _jniorListing = new ArrayList();
    protected ArrayList<HostnameChangedListener> _hostnameChangedListenerList = new ArrayList();

    public BeaconTableModel() {
        Beacon.getInstance().addBeaconListener(this);
        JniorInfo jniorInfo = new JniorInfo(-1);
        jniorInfo.IpAddress = "10.0.0.9";
    }

    @Override
    public String getColumnName(int column) {
        return BeaconTableColumnModel.COLUMNS.get((int)column).Name;
    }

    @Override
    public int getColumnCount() {
        return BeaconTableColumnModel.COLUMNS.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        ArrayList<JniorItem> arrayList = this._rowData;
        synchronized (arrayList) {
            return this._rowData.size() + this._jniorListing.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JniorItem[] getJniors() {
        try {
            ArrayList<JniorItem> arrayList = this._rowData;
            synchronized (arrayList) {
                ArrayList jniors = new ArrayList();
                Collections.addAll(jniors, this._rowData.toArray(new JniorItem[this._rowData.size()]));
                return jniors.toArray(new JniorItem[jniors.size()]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JniorItem getJniorAt(int row) {
        ArrayList<JniorItem> arrayList = this._rowData;
        synchronized (arrayList) {
            if (row < this._rowData.size()) {
                return this._rowData.get(row);
            }
            if (row < this._rowData.size() + this._jniorListing.size()) {
                return this._jniorListing.get(row - this._rowData.size());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int row, int col) {
        ArrayList<JniorItem> arrayList = this._rowData;
        synchronized (arrayList) {
            Object value = null;
            try {
                JniorItem jniorItem = null;
                if (row < this._rowData.size()) {
                    jniorItem = this._rowData.get(row);
                } else if (row < this._rowData.size() + this._jniorListing.size()) {
                    jniorItem = this._jniorListing.get(row - this._rowData.size());
                }
                if (null == jniorItem) {
                    return "";
                }
                switch (col) {
                    case 0: {
                        value = jniorItem.getSerialNumber();
                        break;
                    }
                    case 4: {
                        value = jniorItem.getModel();
                        break;
                    }
                    case 1: {
                        value = jniorItem.getHostname();
                        break;
                    }
                    case 2: {
                        value = jniorItem.getIpAddress();
                        break;
                    }
                    case 5: {
                        value = jniorItem.getSubnetMask();
                        break;
                    }
                    case 6: {
                        value = jniorItem.getPhysicalAddress();
                        break;
                    }
                    case 3: {
                        if (GeneralConfig.getShowFullOsVersion()) {
                            value = jniorItem.getFullOsVersion();
                            break;
                        }
                        value = jniorItem.getOsVersion();
                        break;
                    }
                    case 7: {
                        value = jniorItem.getBootTime();
                        break;
                    }
                    case 8: {
                        value = jniorItem.getLastAnnounced();
                        break;
                    }
                    case 9: {
                        value = jniorItem.getJniorInfo().AttentionInfo;
                        break;
                    }
                    case 10: {
                        value = jniorItem.getJniorInfo().getStatus();
                    }
                }
            }
            catch (Exception ex) {
                Logger.getLogger(this.getClass().getName()).severe(ExceptionUtils.getStackTrace(ex));
            }
            return value;
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (1 == columnIndex) {
            String newHostname = (String)value;
            JniorItem jniorItem = this._rowData.get(rowIndex);
            JniorInfo jniorInfo = jniorItem.getJniorInfo();
            if (!newHostname.equals(jniorInfo.Hostname)) {
                for (HostnameChangedListener hostnameChangedListener : this._hostnameChangedListenerList) {
                    hostnameChangedListener.hostnameChanged(jniorInfo, newHostname);
                }
            }
        }
    }

    @Override
    public void unitUpdated(JniorInfo jniorInfo) {
        try {
            SwingUtilities.invokeLater(() -> {
                JniorItem[] jniors;
                BeaconTab.LOGGER.info(String.format("table model unitUpdated: %s", jniorInfo.toString()));
                this.updateJniorInfo(jniorInfo);
                int model310Count = 0;
                int model312Count = 0;
                int model314Count = 0;
                int model410Count = 0;
                int model412Count = 0;
                int model412DMXCount = 0;
                int model414Count = 0;
                for (JniorItem jnior : jniors = this.getJniors()) {
                    if (jnior.getSerialNumber() < 300000000) {
                        ++model310Count;
                        continue;
                    }
                    if (jnior.getSerialNumber() < 400000000) {
                        ++model312Count;
                        continue;
                    }
                    if (jnior.getSerialNumber() < 500000000) {
                        ++model314Count;
                        continue;
                    }
                    if (jnior.getSerialNumber() < 700000000) {
                        ++model410Count;
                        continue;
                    }
                    if (jnior.getSerialNumber() < 800000000) {
                        ++model412Count;
                        continue;
                    }
                    if (jnior.getSerialNumber() < 900000000) {
                        ++model414Count;
                        continue;
                    }
                    if (jnior.getSerialNumber() < 900000000) continue;
                    ++model412DMXCount;
                }
                System.out.println("jnior.getSerialNumber(): " + jniorInfo.getSerialNumber() + " " + jniorInfo.Status);
                if (2 == jniorInfo.Status) {
                    MessageToast messageToast = new MessageToast(String.format("%d is rebooting...", jniorInfo.getSerialNumber()));
                    ToastNotifications.getInstance().display(messageToast);
                }
                String beaconStatus = String.format("%d JNIORs (410: %d, 412: %d, 412DMX: %d, 414: %d, 310: %d, 312: %d, 314: %d)", JniorCollection.getJniorCount(), model410Count, model412Count, model412DMXCount, model414Count, model310Count, model312Count, model314Count);
                System.out.println("beaconStatus = " + beaconStatus);
                SupporterMain.getMainFrame().getStatusBar().setStatusText(beaconStatus);
                JniorAnnouncementStore.setAnnouncementJsonObject(jniorInfo.getSerialNumber(), jniorInfo.toJSON());
                JniorAnnouncementStore.incrementBeaconSeenCount(jniorInfo.getSerialNumber());
            });
        }
        catch (Exception ex) {
            NotificationCollection.addError("Error updating JNIOR in beacon table model", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateJniorInfo(JniorInfo jniorInfo) {
        BeaconTab.LOGGER.info(String.format("%s, table model updateJniorInfo: %s", Thread.currentThread().getName(), jniorInfo.toString()));
        try {
            Hashtable<Integer, JniorItem> hashtable = this._jniorsBySerial;
            synchronized (hashtable) {
                if (!this._jniorsBySerial.containsKey(jniorInfo.getSerialNumber())) {
                    JniorItem jniorItem = new JniorItem(jniorInfo);
                    ArrayList<JniorItem> arrayList = this._rowData;
                    synchronized (arrayList) {
                        this._rowData.add(jniorItem);
                    }
                    this._jniorsBySerial.put(jniorInfo.getSerialNumber(), jniorItem);
                    int jniorRow = this.getRowCount() - 1;
                    BeaconTab.LOGGER.info(String.format("jnior added at row %d", jniorRow));
                    this.fireTableRowsInserted(jniorRow, jniorRow);
                    jniorInfo.addStatusChangedListener(new StatusChangedListener(){

                        @Override
                        public void statusChanged(JniorInfo jniorInfo, String status) {
                            JniorItem jniorItem = BeaconTableModel.this.getJniorItemBySerialNumber(jniorInfo.getSerialNumber());
                            int row = BeaconTableModel.this.getRowForJniorItem(jniorItem);
                            BeaconTableModel.this.fireTableCellUpdated(row, 10);
                        }
                    });
                } else {
                    JniorItem jniorItem = this._jniorsBySerial.get(jniorInfo.getSerialNumber());
                    jniorItem.update(jniorInfo);
                    int jniorRow = this.getRowForJniorItem(jniorItem);
                    System.out.println("jniorRow = " + jniorRow + " " + jniorInfo);
                    this.fireTableRowsUpdated(jniorRow, jniorRow);
                }
            }
        }
        catch (Exception ex) {
            NotificationCollection.addError("Error updating jnior info in beacon table model", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Hashtable<Integer, JniorItem> hashtable = this._jniorsBySerial;
        synchronized (hashtable) {
            int sizeBeforeClear = this.getRowCount();
            ArrayList<JniorItem> arrayList = this._rowData;
            synchronized (arrayList) {
                this._rowData.clear();
                this._jniorsBySerial.clear();
            }
            if (0 < sizeBeforeClear) {
                this.fireTableRowsDeleted(0, sizeBeforeClear - 1);
            }
        }
    }

    public JniorItem getJniorItemBySerialNumber(int selectedSerialNumber) {
        return this._jniorsBySerial.get(selectedSerialNumber);
    }

    public int getRowForJniorItem(JniorItem selectedJniorItem) {
        return this._rowData.indexOf(selectedJniorItem);
    }

    public void addHostnameChangedListener(HostnameChangedListener listener) {
        this._hostnameChangedListenerList.add(listener);
    }
}

