/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.backup;

import com.integ.janoslib.utils.PathUtils;
import com.integ.supporter.RollingLog;
import com.integ.supporter.backup.CacheDownloadLogic;
import com.integ.supporter.backup.DateStampDownloadLogic;
import com.integ.supporter.backup.DownloadLogic;
import com.integ.supporter.backup.IgnoreDownloadLogic;
import com.integ.supporter.backup.OverwriteDownloadLogic;
import java.util.logging.Logger;
import org.json.JSONObject;

public class DownloadLogicFactory {
    public static final Logger LOGGER = RollingLog.getLogger("BackupService");

    public static DownloadLogic get(JSONObject fileJson) {
        String filepath = fileJson.getString("path");
        String fileParentDirectory = filepath.substring(0, filepath.lastIndexOf("/"));
        String filename = filepath.substring(fileParentDirectory.length() + 1);
        String fileExtension = PathUtils.getFileExtension(filename);
        if (fileParentDirectory.equalsIgnoreCase("/temp")) {
            return new IgnoreDownloadLogic(fileJson);
        }
        if (fileParentDirectory.equalsIgnoreCase("/flash/baks")) {
            return new OverwriteDownloadLogic(fileJson);
        }
        if (fileParentDirectory.equalsIgnoreCase("/flash/cinema_backup")) {
            return new DateStampDownloadLogic(fileJson);
        }
        if ("log".equalsIgnoreCase(fileExtension) || "csv".equalsIgnoreCase(fileExtension)) {
            return new OverwriteDownloadLogic(fileJson);
        }
        if (fileExtension.endsWith("bak") || "ini".equalsIgnoreCase(fileExtension) || "json".equalsIgnoreCase(fileExtension)) {
            return new DateStampDownloadLogic(fileJson);
        }
        return new CacheDownloadLogic(fileJson);
    }
}

