/*
 * Decompiled with CFR 0.152.
 */
package com.integ.janoslib.net.beacon.messages;

import com.integ.janoslib.net.beacon.Beacon;
import com.integ.janoslib.net.beacon.JniorVersion;
import com.integ.janoslib.net.beacon.messages.BeaconMessage;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.janoslib.utils.HexUtils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class IAmJniorBeaconMessage
extends BeaconMessage {
    public IAmJniorBeaconMessage(int serialNumber) {
        super(serialNumber, "I_AM_JNIOR");
    }

    @Override
    public void parse(byte[] messageBytes) {
        String dateString = null;
        try {
            byte[] buildTagBytes;
            int bytesRead;
            ByteArrayInputStream bais = new ByteArrayInputStream(messageBytes);
            DataInputStream dis = new DataInputStream(bais);
            this._jniorInfo.AutoAnnounce = dis.readBoolean();
            this._jniorInfo.IpAddress = Beacon.readString(dis);
            this._jniorInfo.SubnetMask = Beacon.readString(dis);
            this._jniorInfo.Hostname = Beacon.readString(dis);
            this._jniorInfo.PhysicalAddress = Beacon.readString(dis);
            this._jniorInfo.FullOsVersion = this._jniorInfo.OsVersion = JniorVersion.parse(Beacon.readString(dis));
            this._jniorInfo.ProtocolPort = dis.readUnsignedShort();
            dateString = Beacon.readString(dis);
            try {
                SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("EEE MMM d HH:mm:ss Z yyyy");
                this._jniorInfo.BootTime = SIMPLE_DATE_FORMAT.parse(dateString);
            }
            catch (Exception ex) {
                Exception ex3 = new Exception("Could not parse " + dateString, ex);
                ex3.printStackTrace();
                String stacktrace = ExceptionUtils.getStackTrace(ex3);
                Beacon.LOGGER.severe(stacktrace);
                Beacon.LOGGER.severe("processAnnouncement:\n" + HexUtils.hexDump(messageBytes, 0, messageBytes.length));
            }
            if (0 == dis.available()) {
                return;
            }
            boolean isConfigured = dis.readBoolean();
            if (0 == dis.available()) {
                return;
            }
            this._jniorInfo.AttentionInfo = dis.readByte();
            if (0 == dis.available()) {
                return;
            }
            long utcDate = dis.readLong();
            this._jniorInfo.CurrentTime = new Date(utcDate);
            if (0 == dis.available()) {
                return;
            }
            short jmpPort = dis.readShort();
            if (0 != dis.available() && 6 == (bytesRead = dis.read(buildTagBytes = new byte[6]))) {
                JniorVersion versionFromBuildTagString = JniorVersion.getVersionFromBuildTag(HexUtils.bytesToHex(buildTagBytes));
                System.out.println("versionFromBuildTagString = " + versionFromBuildTagString);
                this._jniorInfo.FullOsVersion = versionFromBuildTagString;
                this._jniorInfo.BuildTag = HexUtils.bytesToHex(buildTagBytes);
            }
        }
        catch (Exception ex) {
            Exception ex2 = new Exception(this._serialNumber + " error", ex);
            String stacktrace = ExceptionUtils.getStackTrace(ex2);
            Beacon.LOGGER.severe(stacktrace);
            Beacon.LOGGER.severe("processAnnouncement:\n" + HexUtils.hexDump(messageBytes, 0, messageBytes.length));
        }
    }
}

