/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.jrget.models;

import com.integ.supporter.Constants;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.jrget.jniordotcom.OfficialReleasesJson;
import com.integ.supporter.jrget.jniordotcom.ReleasesDownloadedEvent;
import com.integ.supporter.jrget.jniordotcom.ReleasesDownloadedEventListener;
import com.integ.supporter.jrget.models.AvailableUpdateNode;
import com.integ.supporter.jrget.models.DefaultTreeTableNode;
import com.integ.supporter.jrget.models.ReleaseUpdateNode;
import com.integ.supporter.jrget.models.UpdatesTreeTableModel;
import com.integ.supporter.snapshot.DefaultMutableTreeNode2;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.json.JSONArray;
import org.json.JSONObject;

public class OfficialUpdatesNode
extends DefaultTreeTableNode
implements ReleasesDownloadedEventListener {
    private final UpdatesTreeTableModel _model;
    private final DefaultMutableTreeNode _loadingNode = new DefaultMutableTreeNode("Loading...");

    public OfficialUpdatesNode(UpdatesTreeTableModel model) {
        super("Official Updates from jnior.com");
        this._model = model;
        super.add(this._loadingNode);
        OfficialReleasesJson releasesJson = new OfficialReleasesJson();
        releasesJson.addReleaseDownloadListener(this);
        new Thread(() -> {
            try {
                releasesJson.fetch();
            }
            catch (Exception ex) {
                Logger.getLogger(OfficialUpdatesNode.class.getName()).log(Level.SEVERE, null, ex);
            }
        }).start();
    }

    @Override
    public void releasesDownloadedEvent(ReleasesDownloadedEvent releasesDownloadedEvent) {
        SwingUtilities.invokeLater(() -> {
            try {
                OfficialUpdatesNode.super.remove(this._loadingNode);
                System.out.println("process available updates");
                JSONObject releasesJson = releasesDownloadedEvent.getReleasesJson();
                if (null == releasesJson) {
                    this.add(new DefaultMutableTreeNode2("Error downloading Available Updates from jnior.com"));
                    NotificationCollection.addError("Error downloading Available Updates from jnior.com");
                    return;
                }
                JSONArray appNamesJsonArray = releasesJson.getJSONArray("app_names");
                JSONObject availableDownloadsJson = releasesJson.getJSONObject("downloads");
                for (int i = 0; i < appNamesJsonArray.length(); ++i) {
                    String appName = appNamesJsonArray.getString(i);
                    JSONObject appJson = availableDownloadsJson.getJSONObject(appName);
                    AvailableUpdateNode applicationNode = new AvailableUpdateNode(appJson);
                    OfficialUpdatesNode.super.add(applicationNode);
                    JSONArray versionsJsonArray = appJson.getJSONArray("versions");
                    for (int j = 0; j < versionsJsonArray.length() && j < 3; ++j) {
                        boolean latestVersion = 0 == j;
                        JSONObject versionJson = versionsJsonArray.getJSONObject(j);
                        String localFilename = Constants.UPDATE_PROJECTS_DIRECTORY + versionJson.getString("filename");
                        File localFile = new File(localFilename);
                        applicationNode.add(new ReleaseUpdateNode(versionJson));
                    }
                }
                System.out.println("done processing available updates");
                this._model.fireTreeStructureChanged(this, null, null, null);
            }
            catch (Exception ex) {
                NotificationCollection.addError("Error enumerating Available Updates from jnior.com");
                ex.printStackTrace();
            }
        });
    }

    @Override
    public TreeNode getChildAt(int index) {
        return super.getChildAt(index);
    }

    @Override
    public Object getValueAt(Object node, int column) {
        if (0 == column) {
            return super.toString();
        }
        return "";
    }
}

