/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.updater.steps;

import com.integ.supporter.updater.steps.ProjectStep;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RebootEraseAllStep
extends ProjectStep {
    public RebootEraseAllStep(String name) {
        super(name);
        this._type = "RebootProperty";
    }

    public RebootEraseAllStep(Element xmlElement) {
        super(xmlElement);
    }

    @Override
    public Element getXmlElement(Document document) {
        Element xmlElement = super.getXmlElement(document);
        return xmlElement;
    }

    @Override
    public boolean execute() throws Exception {
        String rebootCommand = "reboot -eraseall";
        if (3 == this._jniorInfo.getSeries()) {
            this._logger.warning("The reboot -eraseall step does not work on the Series 3");
        }
        this._logger.info("  sending " + rebootCommand.replaceAll("\n", "\\n") + " command");
        this._jniorUpdateControlConnection.send(rebootCommand + "\r\n");
        Thread.sleep(1000L);
        this._jniorUpdateControlConnection.send("y\n");
        this._logger.info("  wait for the telnet connection to disconnect");
        long connectionDisconnectTimeout = System.currentTimeMillis() + 300000L;
        while (this._jniorUpdateControlConnection.isCommandConnectionConnected()) {
            Thread.sleep(1000L);
            if (connectionDisconnectTimeout >= System.currentTimeMillis()) continue;
            this._logger.warning("  telnet client disconnection timeout");
            break;
        }
        this._jniorUpdateControlConnection.disconnect();
        long rebootTimeout = System.currentTimeMillis() + 300000L;
        while (System.currentTimeMillis() < rebootTimeout) {
            if (3 == this._jniorInfo.getSeries()) {
                Thread.sleep(30000L);
            } else {
                Thread.sleep(10000L);
            }
            try {
                this._logger.info("  reconnecting to telnet client...");
                if (!this._jniorUpdateControlConnection.connect()) continue;
                this._logger.info("  reboot has completed");
                this._updateProjectExecutor.clearRebootFlag();
                break;
            }
            catch (Exception ex) {
                this._logger.severe(String.format("  %s", ex.getMessage()));
                this._jniorUpdateControlConnection.disconnect();
            }
        }
        return true;
    }
}

