/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.beacon.renderers;

import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.janoslib.utils.ThreadUtils;
import com.integ.supporter.JniorItem;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.beacon.BeaconTab;
import com.integ.supporter.beacon.BeaconTableModel;
import com.integ.supporter.jrget.jniordotcom.OfficialReleasesJson;
import com.integ.supporter.ui.ColorConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class BeaconTableRenderer
implements TableCellRenderer {
    private static final int MILLIS_IN_SECOND = 1000;
    private static final int SECONDS_IN_MINUTE = 60;
    private static final int MINUTES_IN_HOUR = 60;
    private static final int HOURS_IN_DAY = 24;
    private static final int DAYS_IN_YEAR = 365;
    private static final long MILLISECONDS_IN_YEAR = 31536000000L;
    private static final Color SERIES3_DARK_GRAY = Color.decode("#999999");
    private static final DefaultTableCellRenderer DEFAULT_RENDERER = new DefaultTableCellRenderer();
    private final ArrayList<JniorItem> _jniorItemsNeedingRefreshed = new ArrayList();
    private JTable _table;

    public BeaconTableRenderer() {
        ThreadUtils.execute(() -> {
            while (true) {
                try {
                    block3: while (true) {
                        Thread.sleep(50L);
                        if (this._jniorItemsNeedingRefreshed.isEmpty()) continue;
                        BeaconTableModel beaconTableModel = (BeaconTableModel)this._table.getModel();
                        do {
                            JniorItem jniorItem = this._jniorItemsNeedingRefreshed.get(0);
                            if (System.currentTimeMillis() <= jniorItem.getLastAnnounced().getTime() + 1000L) continue block3;
                            this._jniorItemsNeedingRefreshed.remove(0);
                            int row = beaconTableModel.getRowForJniorItem(jniorItem);
                            if (-1 == row) continue;
                            beaconTableModel.fireTableRowsUpdated(row, row);
                            BeaconTab.LOGGER.info(String.format("refresh renderer for %s", jniorItem.getJniorInfo().toString()));
                        } while (!this._jniorItemsNeedingRefreshed.isEmpty());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    continue;
                }
                break;
            }
        }, this.getClass().getName());
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this._table = table;
        Component c = DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        try {
            BeaconTableModel model = (BeaconTableModel)table.getModel();
            if (row >= model.getRowCount()) {
                return null;
            }
            int jniorModelRow = table.convertRowIndexToModel(row);
            JniorItem jniorItem = model.getJniorAt(jniorModelRow);
            DefaultTableCellRenderer dtcr = (DefaultTableCellRenderer)c;
            dtcr.setToolTipText("");
            if (0 == column) {
                dtcr.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
            }
            if (null != jniorItem) {
                JniorInfo jniorInfo = jniorItem.getJniorInfo();
                if (column >= table.getColumnModel().getColumnCount()) {
                    return c;
                }
                TableColumn tableColumn = table.getColumnModel().getColumn(column);
                int columnModelIndex = tableColumn.getModelIndex();
                c.setForeground(Color.black);
                if (null != jniorInfo && !isSelected) {
                    if (null != jniorInfo.LastAnnounced && System.currentTimeMillis() < jniorInfo.LastAnnounced.getTime() + 1000L) {
                        c.setBackground(ColorConstants.PALE_GREEN);
                        if (!this._jniorItemsNeedingRefreshed.contains(jniorItem)) {
                            this._jniorItemsNeedingRefreshed.add(jniorItem);
                        }
                    } else if (2 == jniorInfo.Status) {
                        c.setBackground(ColorConstants.PALE_RED);
                    } else if (1 == jniorInfo.Status) {
                        c.setBackground(ColorConstants.PALE_PURPLE);
                    } else if (jniorInfo.isSeries3()) {
                        c.setBackground(SERIES3_DARK_GRAY);
                        c.setForeground(Color.WHITE);
                        Calendar manufacturedCalendar = Calendar.getInstance();
                        int year = jniorInfo.getSerialNumber() % 100000000 / 1000000;
                        manufacturedCalendar.set(1, 2000 + year);
                        int month = jniorInfo.getSerialNumber() % 100000 / 10000;
                        manufacturedCalendar.set(2, month);
                        Calendar nowCalendar = Calendar.getInstance();
                        long millis = nowCalendar.getTimeInMillis() - manufacturedCalendar.getTimeInMillis();
                        int yearsOld = (int)(millis / 31536000000L);
                        dtcr.setToolTipText(yearsOld + "+ year old Series 3 Unit.  Replacement Recommended.");
                    } else if (0 != jniorInfo.AttentionInfo) {
                        if (jniorInfo.isError()) {
                            c.setBackground(ColorConstants.PALE_ORANGE);
                        } else if (jniorInfo.isWarning()) {
                            c.setBackground(ColorConstants.PALE_YELLOW);
                        }
                    } else if (jniorItem.isHovered()) {
                        c.setBackground(ColorConstants.LIGHT_BLUE);
                    } else if (row % 2 == 0) {
                        c.setBackground(Color.WHITE);
                    } else {
                        c.setBackground(ColorConstants.LIGHT_GRAY);
                    }
                    if (3 == columnModelIndex && null != OfficialReleasesJson.OLDEST_OS_VERSION) {
                        boolean isOldOs;
                        boolean bl = isOldOs = 0 > jniorInfo.OsVersion.compareTo(OfficialReleasesJson.OLDEST_OS_VERSION);
                        if (jniorInfo.isSeries4() && isOldOs) {
                            c.setFont(new Font("Dialog", 3, 12));
                            dtcr.setToolTipText("Old OS.  Update recommended!");
                        }
                    }
                }
                if (isSelected) {
                    c.setBackground(ColorConstants.SELECTED_BLUE);
                    c.setForeground(Color.WHITE);
                }
                if (9 == columnModelIndex) {
                    c.setFont(new Font("Dialog", 1, 12));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            NotificationCollection.addError("Error getting cell renderer component", ex);
        }
        return c;
    }
}

