/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui.syntaxhighlight;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;

class MultiSyntaxDocument
extends DefaultStyledDocument {
    public static final String DEFAULT_FONT_FAMILY = "Monospaced";
    public static final int DEFAULT_FONT_SIZE = 12;
    public static final MutableAttributeSet NORMAL_ATTRIBUTE;
    public static final MutableAttributeSet STRING_ATTRIBUTE;
    public static final MutableAttributeSet KEYWORD_ATTRIBUTE;
    public static final MutableAttributeSet CRITICAL_ATTRIBUTE;
    private static final MutableAttributeSet ERROR_ATTRIBUTE;
    private static final MutableAttributeSet WARNING_ATTRIBUTE;
    private static final MutableAttributeSet GOOD_ATTRIBUTE;
    private static final MutableAttributeSet PROMPT_ATTRIBUTE;
    private static final String CRITICAL_PATTERN_STRING = "(assertion|terminating|dump|sram reformatted)";
    private static final Pattern CRITICAL_PATTERN;
    private static final String ERROR_PATTERN_STRING = "(exception|error)";
    private static final Pattern ERROR_PATTERN;
    private static final String WARNING_PATTERN_STRING = "(warn|failed|login incorrect|Unable to start)";
    private static final Pattern WARNING_PATTERN;
    private static final String GOOD_PATTERN_STRING = "(encrypted|encryption)";
    private static final Pattern GOOD_PATTERN;
    private static final String PROMPT_PATTERN_STRING = "(^.* [\\/\\w+]*>|login:|username:|password:)";
    private static final Pattern PROMPT_PATTERN;
    private final DefaultStyledDocument doc = this;
    private final Element rootElement = this.doc.getDefaultRootElement();
    private final HashMap<String, MutableAttributeSet> keywords;
    private int fontSize = 12;
    private String fontName = "Monospaced";

    public MultiSyntaxDocument(HashMap<String, MutableAttributeSet> keywords) {
        this.putProperty("__EndOfLine__", "\n");
        this.keywords = keywords;
    }

    public void setAttributeFont(ATTR_TYPE attr, int style) {
        Font f = new Font(this.fontName, style, this.fontSize);
        if (attr == ATTR_TYPE.Quote) {
            MultiSyntaxDocument.setAttributeFont(STRING_ATTRIBUTE, f);
        } else {
            MultiSyntaxDocument.setAttributeFont(NORMAL_ATTRIBUTE, f);
        }
    }

    public static void setAttributeFont(MutableAttributeSet attr, Font f) {
        StyleConstants.setBold(attr, f.isBold());
        StyleConstants.setItalic(attr, f.isItalic());
        StyleConstants.setFontFamily(attr, f.getFamily());
        StyleConstants.setFontSize(attr, f.getSize());
    }

    public void setAttributeColor(ATTR_TYPE attr, Color c) {
        if (attr == ATTR_TYPE.Quote) {
            MultiSyntaxDocument.setAttributeColor(STRING_ATTRIBUTE, c);
        } else {
            MultiSyntaxDocument.setAttributeColor(NORMAL_ATTRIBUTE, c);
        }
    }

    public static void setAttributeColor(MutableAttributeSet attr, Color c) {
        StyleConstants.setForeground(attr, c);
    }

    public void addKeyword(String keyword, MutableAttributeSet attr) {
        this.keywords.put(keyword, attr);
    }

    public MutableAttributeSet getKeywordFormatting(String keyword) {
        return this.keywords.get(keyword);
    }

    public void removeKeyword(String keyword) {
        this.keywords.remove(keyword);
    }

    public void setTabs(int charactersPerTab) {
        Font f = new Font(this.fontName, 0, this.fontSize);
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(f);
        int charWidth = fm.charWidth('w');
        int tabWidth = charWidth * charactersPerTab;
        TabStop[] tabs = new TabStop[35];
        for (int j = 0; j < tabs.length; ++j) {
            int tab = j + 1;
            tabs[j] = new TabStop(tab * tabWidth);
        }
        TabSet tabSet = new TabSet(tabs);
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setTabSet(attributes, tabSet);
        int length = this.getLength();
        this.setParagraphAttributes(0, length, attributes, false);
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        super.insertString(offset, str, a);
        this.processChangedLines(offset, str.length());
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        super.remove(offset, length);
        this.processChangedLines(offset, 0);
    }

    public void processChangedLines(int offset, int length) throws BadLocationException {
        String content = this.doc.getText(0, this.doc.getLength());
        int startLine = this.rootElement.getElementIndex(offset);
        int endLine = this.rootElement.getElementIndex(offset + length);
        for (int i = startLine; i <= endLine; ++i) {
            this.applyLineHighlighting(content, i);
        }
    }

    private void applyLineHighlighting(String content, int line) throws BadLocationException {
        int startOffset = this.rootElement.getElement(line).getStartOffset();
        int endOffset = this.rootElement.getElement(line).getEndOffset() - 1;
        int lineLength = endOffset - startOffset;
        int contentLength = content.length();
        if (endOffset >= contentLength) {
            endOffset = contentLength - 1;
        }
        this.doc.setCharacterAttributes(startOffset, lineLength, NORMAL_ATTRIBUTE, true);
        this.applyLineHighlighting(content, startOffset, endOffset);
    }

    private void applyLineHighlighting(String content, int startOffset, int endOffset) {
        if (endOffset >= startOffset) {
            try {
                Matcher matcher = CRITICAL_PATTERN.matcher(content.substring(startOffset, endOffset));
                if (matcher.find()) {
                    int length = endOffset - startOffset + 1;
                    this.doc.setCharacterAttributes(startOffset, length, CRITICAL_ATTRIBUTE, false);
                    return;
                }
                matcher = ERROR_PATTERN.matcher(content.substring(startOffset, endOffset));
                if (matcher.find()) {
                    int length = endOffset - startOffset + 1;
                    this.doc.setCharacterAttributes(startOffset, length, ERROR_ATTRIBUTE, false);
                    return;
                }
                matcher = WARNING_PATTERN.matcher(content.substring(startOffset, endOffset));
                if (matcher.find()) {
                    int length = endOffset - startOffset + 1;
                    this.doc.setCharacterAttributes(startOffset, length, WARNING_ATTRIBUTE, false);
                    return;
                }
                matcher = GOOD_PATTERN.matcher(content.substring(startOffset, endOffset));
                if (matcher.find()) {
                    int length = matcher.end() - matcher.start() + 1;
                    this.doc.setCharacterAttributes(startOffset + matcher.start(), length, GOOD_ATTRIBUTE, false);
                    return;
                }
                matcher = PROMPT_PATTERN.matcher(content.substring(startOffset, endOffset));
                if (matcher.find()) {
                    int length = matcher.end() - matcher.start() + 1;
                    this.doc.setCharacterAttributes(startOffset + matcher.start(), length, PROMPT_ATTRIBUTE, false);
                    return;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        while (startOffset <= endOffset) {
            while (this.isDelimiter(content.substring(startOffset, startOffset + 1))) {
                if (startOffset < endOffset) {
                    ++startOffset;
                    continue;
                }
                return;
            }
            if (this.isQuoteDelimiter(content.substring(startOffset, startOffset + 1))) {
                startOffset = this.getQuoteToken(content, startOffset, endOffset);
                continue;
            }
            startOffset = this.getOtherToken(content, startOffset, endOffset);
        }
    }

    private int getQuoteToken(String content, int startOffset, int endOffset) {
        String quoteDelimiter = content.substring(startOffset, startOffset + 1);
        String escapeString = this.getEscapeString(quoteDelimiter);
        int endOfQuote = startOffset;
        int index = content.indexOf(escapeString, endOfQuote + 1);
        while (index > -1 && index < endOffset) {
            endOfQuote = index + 1;
            index = content.indexOf(escapeString, endOfQuote);
        }
        index = content.indexOf(quoteDelimiter, endOfQuote + 1);
        endOfQuote = index < 0 || index > endOffset ? endOffset : index;
        this.doc.setCharacterAttributes(startOffset, endOfQuote - startOffset + 1, STRING_ATTRIBUTE, false);
        return endOfQuote + 1;
    }

    private int getOtherToken(String content, int startOffset, int endOffset) {
        int endOfToken;
        for (endOfToken = startOffset + 1; endOfToken <= endOffset && !this.isDelimiter(content.substring(endOfToken, endOfToken + 1)); ++endOfToken) {
        }
        String token = content.substring(startOffset, endOfToken);
        MutableAttributeSet attr = this.keywords.get(token);
        if (attr != null) {
            this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, attr, false);
        }
        return endOfToken + 1;
    }

    private int indexOf(String content, String needle, int offset) {
        String text;
        int index;
        while ((index = content.indexOf(needle, offset)) != -1 && !(text = this.getLine(content, index).trim()).startsWith(needle) && !text.endsWith(needle)) {
            offset = index + 1;
        }
        return index;
    }

    private int lastIndexOf(String content, String needle, int offset) {
        String text;
        int index;
        while ((index = content.lastIndexOf(needle, offset)) != -1 && !(text = this.getLine(content, index).trim()).startsWith(needle) && !text.endsWith(needle)) {
            offset = index - 1;
        }
        return index;
    }

    private String getLine(String content, int offset) {
        int line = this.rootElement.getElementIndex(offset);
        Element lineElement = this.rootElement.getElement(line);
        int start = lineElement.getStartOffset();
        int end = lineElement.getEndOffset();
        return content.substring(start, end - 1);
    }

    protected boolean isDelimiter(String character) {
        String operands = ";:{}()[]+-/%<=>!&|^~*";
        return Character.isWhitespace(character.charAt(0)) || operands.indexOf(character) != -1;
    }

    protected boolean isQuoteDelimiter(String character) {
        String quoteDelimiters = "\"'";
        return quoteDelimiters.indexOf(character) >= 0;
    }

    protected String getEscapeString(String quoteDelimiter) {
        return "\\" + quoteDelimiter;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
        StyleConstants.setFontSize(NORMAL_ATTRIBUTE, fontSize);
        StyleConstants.setFontSize(STRING_ATTRIBUTE, fontSize);
        StyleConstants.setFontSize(CRITICAL_ATTRIBUTE, fontSize);
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
        StyleConstants.setFontFamily(NORMAL_ATTRIBUTE, fontName);
        StyleConstants.setFontFamily(STRING_ATTRIBUTE, fontName);
        StyleConstants.setFontFamily(CRITICAL_ATTRIBUTE, fontName);
    }

    static {
        CRITICAL_PATTERN = Pattern.compile(CRITICAL_PATTERN_STRING, 2);
        ERROR_PATTERN = Pattern.compile(ERROR_PATTERN_STRING, 2);
        WARNING_PATTERN = Pattern.compile(WARNING_PATTERN_STRING, 2);
        GOOD_PATTERN = Pattern.compile(GOOD_PATTERN_STRING, 2);
        PROMPT_PATTERN = Pattern.compile(PROMPT_PATTERN_STRING, 2);
        NORMAL_ATTRIBUTE = new SimpleAttributeSet();
        StyleConstants.setForeground(NORMAL_ATTRIBUTE, Color.WHITE);
        StyleConstants.setFontFamily(NORMAL_ATTRIBUTE, DEFAULT_FONT_FAMILY);
        StyleConstants.setFontSize(NORMAL_ATTRIBUTE, 12);
        STRING_ATTRIBUTE = new SimpleAttributeSet();
        StyleConstants.setForeground(STRING_ATTRIBUTE, Color.decode("#E6DB74"));
        StyleConstants.setFontFamily(STRING_ATTRIBUTE, DEFAULT_FONT_FAMILY);
        StyleConstants.setFontSize(STRING_ATTRIBUTE, 12);
        KEYWORD_ATTRIBUTE = new SimpleAttributeSet();
        StyleConstants.setForeground(KEYWORD_ATTRIBUTE, new Color(0, 0, 153));
        StyleConstants.setBold(KEYWORD_ATTRIBUTE, true);
        StyleConstants.setFontFamily(KEYWORD_ATTRIBUTE, DEFAULT_FONT_FAMILY);
        StyleConstants.setFontSize(KEYWORD_ATTRIBUTE, 12);
        CRITICAL_ATTRIBUTE = new SimpleAttributeSet();
        StyleConstants.setForeground(CRITICAL_ATTRIBUTE, Color.decode("#fa8072"));
        StyleConstants.setBold(CRITICAL_ATTRIBUTE, true);
        StyleConstants.setFontFamily(CRITICAL_ATTRIBUTE, DEFAULT_FONT_FAMILY);
        StyleConstants.setFontSize(CRITICAL_ATTRIBUTE, 12);
        ERROR_ATTRIBUTE = new SimpleAttributeSet();
        StyleConstants.setForeground(ERROR_ATTRIBUTE, Color.decode("#ffa500"));
        StyleConstants.setBold(ERROR_ATTRIBUTE, true);
        StyleConstants.setFontFamily(ERROR_ATTRIBUTE, DEFAULT_FONT_FAMILY);
        StyleConstants.setFontSize(ERROR_ATTRIBUTE, 12);
        WARNING_ATTRIBUTE = new SimpleAttributeSet();
        StyleConstants.setForeground(WARNING_ATTRIBUTE, Color.decode("#ffff40"));
        StyleConstants.setBold(WARNING_ATTRIBUTE, true);
        StyleConstants.setFontFamily(WARNING_ATTRIBUTE, DEFAULT_FONT_FAMILY);
        StyleConstants.setFontSize(WARNING_ATTRIBUTE, 12);
        GOOD_ATTRIBUTE = new SimpleAttributeSet();
        StyleConstants.setForeground(GOOD_ATTRIBUTE, Color.decode("#98fb98"));
        StyleConstants.setBold(GOOD_ATTRIBUTE, true);
        StyleConstants.setFontFamily(GOOD_ATTRIBUTE, DEFAULT_FONT_FAMILY);
        StyleConstants.setFontSize(GOOD_ATTRIBUTE, 12);
        PROMPT_ATTRIBUTE = new SimpleAttributeSet();
        StyleConstants.setForeground(PROMPT_ATTRIBUTE, Color.decode("#00ffff"));
        StyleConstants.setBold(PROMPT_ATTRIBUTE, true);
        StyleConstants.setFontFamily(PROMPT_ATTRIBUTE, DEFAULT_FONT_FAMILY);
        StyleConstants.setFontSize(PROMPT_ATTRIBUTE, 12);
    }

    public static enum ATTR_TYPE {
        Normal,
        Comment,
        Quote;

    }
}

