/*
 * Decompiled with CFR 0.152.
 */
package com.integ.janoslib.net.beacon;

import com.integ.supporter.RollingLog;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;

public class BeaconNetworkInterface {
    public static final Logger LOGGER = RollingLog.getLogger("BeaconNetworkInterface");
    private final NetworkInterface _networkInterface;
    private final ArrayList<InterfaceAddress> _interfaceAddresses = new ArrayList();

    public static ArrayList<BeaconNetworkInterface> getBeaconInterfaces() throws SocketException {
        ArrayList<BeaconNetworkInterface> beaconInterfaces = new ArrayList<BeaconNetworkInterface>();
        LOGGER.info("enumerate network interfaces...");
        block0: for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
            LOGGER.info(networkInterface.toString());
            for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                InetAddress inetAddress = interfaceAddress.getAddress();
                LOGGER.info("  " + inetAddress);
                LOGGER.info("  " + inetAddress.getClass().getName());
                if (!(inetAddress instanceof Inet4Address) || networkInterface.isLoopback()) continue;
                LOGGER.info("  " + inetAddress.toString());
                InetAddress broadcastAddress = interfaceAddress.getBroadcast();
                if (null != broadcastAddress) {
                    LOGGER.info("  " + broadcastAddress.toString());
                }
                BeaconNetworkInterface beaconInterface = new BeaconNetworkInterface(networkInterface);
                beaconInterfaces.add(beaconInterface);
                continue block0;
            }
        }
        return beaconInterfaces;
    }

    public BeaconNetworkInterface(NetworkInterface networkInterface) {
        this._networkInterface = networkInterface;
        for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
            InetAddress inetAddress = interfaceAddress.getAddress();
            if (!(inetAddress instanceof Inet4Address)) continue;
            this._interfaceAddresses.add(interfaceAddress);
        }
    }

    public NetworkInterface getNetworkInterface() {
        return this._networkInterface;
    }

    public ArrayList<InterfaceAddress> getInterfaceAddresses() {
        return this._interfaceAddresses;
    }
}

