/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.beacon;

import com.integ.supporter.config.BeaconTableConfig;
import com.integ.supporter.ui.jtable.ColumnInfo;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.json.JSONObject;

public class BeaconTableColumnModel
extends DefaultTableColumnModel {
    private static final int MIN_WIDTH = 15;
    public static final ArrayList<ColumnInfo> COLUMNS = new ArrayList<ColumnInfo>(Arrays.asList(new ColumnInfo("Serial Number", 96), new ColumnInfo("Hostname", 228), new ColumnInfo("IP Address", 96), new ColumnInfo("OS Version", 96), new ColumnInfo("Model", 80), new ColumnInfo("Subnet Mask", 128), new ColumnInfo("MAC Address", 160), new ColumnInfo("Boot Time", 224), new ColumnInfo("Last Announced", 224), new ColumnInfo("Message", 80), new ColumnInfo("Status", 1024)));
    private JSONObject _columnsJson = BeaconTableConfig.getBeaconColumnInfo();

    @Override
    public void addColumn(TableColumn tableColumn) {
        super.addColumn(tableColumn);
        int columnIndex = tableColumn.getModelIndex();
        ColumnInfo columnInfo = COLUMNS.get(columnIndex);
        columnInfo.Index = columnIndex;
        if (this._columnsJson.has(columnInfo.Name)) {
            JSONObject columnJson = this._columnsJson.getJSONObject(columnInfo.Name);
            columnInfo.Visible = columnJson.getBoolean("Visible");
            columnInfo.Width = columnJson.getInt("Width");
            if (columnJson.has("Index")) {
                columnInfo.Index = columnJson.getInt("Index");
            }
        }
        if (columnInfo.Visible) {
            this.showColumn(columnIndex);
        } else {
            this.hideColumn(columnIndex);
        }
        if (columnInfo.Index < super.getColumnCount()) {
            super.moveColumn(columnIndex, columnInfo.Index);
        }
    }

    public int getMinimumWidth() {
        int minimumWidth = 0;
        for (int i = 0; i < super.getColumnCount() && i <= 3; ++i) {
            TableColumn column = super.getColumn(i);
            minimumWidth += column.getWidth();
        }
        return minimumWidth;
    }

    public void hideColumn(int columnIndex) {
        ColumnInfo columnInfo = COLUMNS.get(columnIndex);
        columnInfo.Visible = false;
        TableColumn tableColumn = super.getColumn(columnIndex);
        tableColumn.setMinWidth(0);
        tableColumn.setMaxWidth(0);
        tableColumn.setPreferredWidth(0);
    }

    public void showColumn(int columnIndex) {
        ColumnInfo columnInfo = COLUMNS.get(columnIndex);
        columnInfo.Visible = true;
        TableColumn tableColumn = super.getColumn(columnIndex);
        tableColumn.setMinWidth(15);
        tableColumn.setMaxWidth(Integer.MAX_VALUE);
        tableColumn.setPreferredWidth(columnInfo.Width);
    }

    public void setWidth(int columnIndex, int width) {
        ColumnInfo columnInfo = COLUMNS.get(columnIndex);
        columnInfo.Width = width;
    }

    public void save() {
        JSONObject columnsJson = new JSONObject();
        for (int i = 0; i < super.getColumnCount(); ++i) {
            TableColumn tableColumn = super.getColumn(i);
            ColumnInfo columnInfo = COLUMNS.get(tableColumn.getModelIndex());
            JSONObject columnJson = new JSONObject();
            columnJson.put("Name", columnInfo.Name);
            columnJson.put("Visible", columnInfo.Visible);
            columnJson.put("Width", columnInfo.Width);
            columnJson.put("Index", i);
            columnsJson.put(tableColumn.getHeaderValue().toString(), columnJson);
        }
        BeaconTableConfig.setBeaconColumnInfo(columnsJson);
    }
}

